/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.sdk.server.BigSegmentStoreStatusProviderImpl;
import com.launchdarkly.sdk.server.BigSegmentStoreWrapper;
import com.launchdarkly.sdk.server.ClientContextImpl;
import com.launchdarkly.sdk.server.ComponentsImpl;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataSourceStatusProviderImpl;
import com.launchdarkly.sdk.server.DataSourceUpdatesImpl;
import com.launchdarkly.sdk.server.DataStoreStatusProviderImpl;
import com.launchdarkly.sdk.server.DataStoreUpdatesImpl;
import com.launchdarkly.sdk.server.EvalResultAndFlag;
import com.launchdarkly.sdk.server.EvaluationOptions;
import com.launchdarkly.sdk.server.EvaluatorInterface;
import com.launchdarkly.sdk.server.EvaluatorWithHooks;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.FeatureFlagsState;
import com.launchdarkly.sdk.server.FlagTrackerImpl;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.InputValidatingEvaluator;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.MigrationOpTracker;
import com.launchdarkly.sdk.server.MigrationStage;
import com.launchdarkly.sdk.server.MigrationStageEnforcingEvaluator;
import com.launchdarkly.sdk.server.MigrationVariation;
import com.launchdarkly.sdk.server.interfaces.BigSegmentStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.BigSegmentsConfiguration;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.interfaces.FlagTracker;
import com.launchdarkly.sdk.server.interfaces.LDClientInterface;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.EventProcessor;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.com.google.common.base.Preconditions;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.http.HttpHelpers;
import com.launchdarkly.shaded.org.apache.commons.codec.binary.Hex;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class LDClient
implements LDClientInterface {
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private final String sdkKey;
    private final boolean offline;
    @VisibleForTesting
    final EvaluatorInterface evaluator;
    final EvaluatorInterface migrationEvaluator;
    final EventProcessor eventProcessor;
    final DataSource dataSource;
    final DataStore dataStore;
    private final BigSegmentStoreStatusProvider bigSegmentStoreStatusProvider;
    private final BigSegmentStoreWrapper bigSegmentStoreWrapper;
    private final DataSourceUpdateSink dataSourceUpdates;
    private final DataStoreStatusProviderImpl dataStoreStatusProvider;
    private final DataSourceStatusProviderImpl dataSourceStatusProvider;
    private final FlagTrackerImpl flagTracker;
    private final EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> flagChangeBroadcaster;
    private final ScheduledExecutorService sharedExecutor;
    private final LDLogger baseLogger;
    private final LDLogger evaluationLogger;
    private static final int EXCESSIVE_INIT_WAIT_MILLIS = 60000;

    public LDClient(String sdkKey) {
        this(sdkKey, LDConfig.DEFAULT);
    }

    private static DataModel.FeatureFlag getFlag(DataStore store, String key) {
        DataStoreTypes.ItemDescriptor item = store.get(DataModel.FEATURES, key);
        return item == null ? null : (DataModel.FeatureFlag)item.getItem();
    }

    private static DataModel.Segment getSegment(DataStore store, String key) {
        DataStoreTypes.ItemDescriptor item = store.get(DataModel.SEGMENTS, key);
        return item == null ? null : (DataModel.Segment)item.getItem();
    }

    public LDClient(String sdkKey, LDConfig config) {
        Preconditions.checkNotNull(config, "config must not be null");
        this.sdkKey = Preconditions.checkNotNull(sdkKey, "sdkKey must not be null");
        if (!HttpHelpers.isAsciiHeaderValue(sdkKey)) {
            throw new IllegalArgumentException("SDK key contained an invalid character");
        }
        this.offline = config.offline;
        this.sharedExecutor = this.createSharedExecutor(config);
        ClientContextImpl context = ClientContextImpl.fromConfig(sdkKey, config, this.sharedExecutor);
        this.baseLogger = context.getBaseLogger();
        this.evaluationLogger = this.baseLogger.subLogger("Evaluation");
        this.eventProcessor = config.events.build(context);
        EventBroadcasterImpl<BigSegmentStoreStatusProvider.StatusListener, BigSegmentStoreStatusProvider.Status> bigSegmentStoreStatusNotifier = EventBroadcasterImpl.forBigSegmentStoreStatus(this.sharedExecutor, this.baseLogger);
        BigSegmentsConfiguration bigSegmentsConfig = config.bigSegments.build(context);
        this.bigSegmentStoreWrapper = bigSegmentsConfig.getStore() != null ? new BigSegmentStoreWrapper(bigSegmentsConfig, bigSegmentStoreStatusNotifier, this.sharedExecutor, this.baseLogger.subLogger("BigSegments")) : null;
        this.bigSegmentStoreStatusProvider = new BigSegmentStoreStatusProviderImpl(bigSegmentStoreStatusNotifier, this.bigSegmentStoreWrapper);
        EventBroadcasterImpl<DataStoreStatusProvider.StatusListener, DataStoreStatusProvider.Status> dataStoreStatusNotifier = EventBroadcasterImpl.forDataStoreStatus(this.sharedExecutor, this.baseLogger);
        DataStoreUpdatesImpl dataStoreUpdates = new DataStoreUpdatesImpl(dataStoreStatusNotifier);
        this.dataStore = config.dataStore.build(context.withDataStoreUpdateSink(dataStoreUpdates));
        InputValidatingEvaluator evaluator = new InputValidatingEvaluator(this.dataStore, this.bigSegmentStoreWrapper, this.eventProcessor, this.evaluationLogger);
        if (config.hooks.getHooks().isEmpty()) {
            this.evaluator = evaluator;
            this.migrationEvaluator = new MigrationStageEnforcingEvaluator(evaluator, this.evaluationLogger);
        } else {
            this.evaluator = new EvaluatorWithHooks(evaluator, config.hooks.getHooks(), this.baseLogger.subLogger("Hooks"));
            this.migrationEvaluator = new EvaluatorWithHooks(new MigrationStageEnforcingEvaluator(evaluator, this.evaluationLogger), config.hooks.getHooks(), this.baseLogger.subLogger("Hooks"));
        }
        this.flagChangeBroadcaster = EventBroadcasterImpl.forFlagChangeEvents(this.sharedExecutor, this.baseLogger);
        this.flagTracker = new FlagTrackerImpl(this.flagChangeBroadcaster, (key, ctx) -> this.jsonValueVariation((String)key, (LDContext)ctx, LDValue.ofNull()));
        this.dataStoreStatusProvider = new DataStoreStatusProviderImpl(this.dataStore, dataStoreUpdates);
        EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> dataSourceStatusNotifier = EventBroadcasterImpl.forDataSourceStatus(this.sharedExecutor, this.baseLogger);
        DataSourceUpdatesImpl dataSourceUpdates = new DataSourceUpdatesImpl(this.dataStore, this.dataStoreStatusProvider, this.flagChangeBroadcaster, dataSourceStatusNotifier, this.sharedExecutor, context.getLogging().getLogDataSourceOutageAsErrorAfter(), this.baseLogger);
        this.dataSourceUpdates = dataSourceUpdates;
        this.dataSource = config.dataSource.build(context.withDataSourceUpdateSink(dataSourceUpdates));
        this.dataSourceStatusProvider = new DataSourceStatusProviderImpl(dataSourceStatusNotifier, dataSourceUpdates);
        Future<Void> startFuture = this.dataSource.start();
        if (!config.startWait.isZero() && !config.startWait.isNegative()) {
            if (!(this.dataSource instanceof ComponentsImpl.NullDataSource)) {
                this.baseLogger.info("Waiting up to {} milliseconds for LaunchDarkly client to start...", (Object)config.startWait.toMillis());
                if (config.startWait.toMillis() > 60000L) {
                    this.baseLogger.warn("LaunchDarkly client created with start wait time of {} milliseconds.  We recommend a timeout of less than {} milliseconds.", (Object)config.startWait.toMillis(), (Object)60000);
                }
            }
            try {
                startFuture.get(config.startWait.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                this.baseLogger.error("Timeout encountered waiting for LaunchDarkly client initialization");
            }
            catch (Exception e) {
                this.baseLogger.error("Exception encountered waiting for LaunchDarkly client initialization: {}", LogValues.exceptionSummary(e));
                this.baseLogger.debug("{}", LogValues.exceptionTrace(e));
            }
            if (!this.dataSource.isInitialized()) {
                this.baseLogger.warn("LaunchDarkly client was not successfully initialized");
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.dataSource.isInitialized();
    }

    @Override
    public void track(String eventName, LDContext context) {
        this.trackData(eventName, context, LDValue.ofNull());
    }

    @Override
    public void trackMigration(MigrationOpTracker tracker) {
        this.eventProcessor.recordMigrationEvent(tracker);
    }

    @Override
    public void trackData(String eventName, LDContext context, LDValue data) {
        if (context == null) {
            this.baseLogger.warn("Track called with null context!");
        } else if (!context.isValid()) {
            this.baseLogger.warn("Track called with invalid context: " + context.getError());
        } else {
            this.eventProcessor.recordCustomEvent(context, eventName, data, null);
        }
    }

    @Override
    public void trackMetric(String eventName, LDContext context, LDValue data, double metricValue) {
        if (context == null) {
            this.baseLogger.warn("Track called with null context!");
        } else if (!context.isValid()) {
            this.baseLogger.warn("Track called with invalid context: " + context.getError());
        } else {
            this.eventProcessor.recordCustomEvent(context, eventName, data, metricValue);
        }
    }

    @Override
    public void identify(LDContext context) {
        if (context == null) {
            this.baseLogger.warn("Identify called with null context!");
        } else if (!context.isValid()) {
            this.baseLogger.warn("Identify called with invalid context: " + context.getError());
        } else {
            this.eventProcessor.recordIdentifyEvent(context);
        }
    }

    @Override
    public FeatureFlagsState allFlagsState(LDContext context, FlagsStateOption ... options) {
        if (this.isOffline()) {
            this.evaluationLogger.debug("allFlagsState() was called when client is in offline mode.");
        }
        return this.evaluator.allFlagsState(context, options);
    }

    @Override
    public boolean boolVariation(String featureKey, LDContext context, boolean defaultValue) {
        return this.evaluator.evalAndFlag("LDClient.boolVariation", featureKey, context, LDValue.of(defaultValue), LDValueType.BOOLEAN, EvaluationOptions.EVENTS_WITHOUT_REASONS).getResult().getValue().booleanValue();
    }

    @Override
    public int intVariation(String featureKey, LDContext context, int defaultValue) {
        return this.evaluator.evalAndFlag("LDClient.intVariation", featureKey, context, LDValue.of(defaultValue), LDValueType.NUMBER, EvaluationOptions.EVENTS_WITHOUT_REASONS).getResult().getValue().intValue();
    }

    @Override
    public double doubleVariation(String featureKey, LDContext context, double defaultValue) {
        return this.evaluator.evalAndFlag("LDClient.doubleVariation", featureKey, context, LDValue.of(defaultValue), LDValueType.NUMBER, EvaluationOptions.EVENTS_WITHOUT_REASONS).getResult().getValue().doubleValue();
    }

    @Override
    public String stringVariation(String featureKey, LDContext context, String defaultValue) {
        return this.evaluator.evalAndFlag("LDClient.stringVariation", featureKey, context, LDValue.of(defaultValue), LDValueType.STRING, EvaluationOptions.EVENTS_WITHOUT_REASONS).getResult().getValue().stringValue();
    }

    @Override
    public LDValue jsonValueVariation(String featureKey, LDContext context, LDValue defaultValue) {
        return this.evaluator.evalAndFlag("LDClient.jsonValueVariation", featureKey, context, LDValue.normalize(defaultValue), null, EvaluationOptions.EVENTS_WITHOUT_REASONS).getResult().getValue();
    }

    @Override
    public EvaluationDetail<Boolean> boolVariationDetail(String featureKey, LDContext context, boolean defaultValue) {
        return this.evaluator.evalAndFlag("LDClient.boolVariationDetail", featureKey, context, LDValue.of(defaultValue), LDValueType.BOOLEAN, EvaluationOptions.EVENTS_WITH_REASONS).getResult().getAsBoolean();
    }

    @Override
    public EvaluationDetail<Integer> intVariationDetail(String featureKey, LDContext context, int defaultValue) {
        return this.evaluator.evalAndFlag("LDClient.intVariationDetail", featureKey, context, LDValue.of(defaultValue), LDValueType.NUMBER, EvaluationOptions.EVENTS_WITH_REASONS).getResult().getAsInteger();
    }

    @Override
    public EvaluationDetail<Double> doubleVariationDetail(String featureKey, LDContext context, double defaultValue) {
        return this.evaluator.evalAndFlag("LDClient.doubleVariationDetail", featureKey, context, LDValue.of(defaultValue), LDValueType.NUMBER, EvaluationOptions.EVENTS_WITH_REASONS).getResult().getAsDouble();
    }

    @Override
    public EvaluationDetail<String> stringVariationDetail(String featureKey, LDContext context, String defaultValue) {
        return this.evaluator.evalAndFlag("LDClient.stringVariationDetail", featureKey, context, LDValue.of(defaultValue), LDValueType.STRING, EvaluationOptions.EVENTS_WITH_REASONS).getResult().getAsString();
    }

    @Override
    public EvaluationDetail<LDValue> jsonValueVariationDetail(String featureKey, LDContext context, LDValue defaultValue) {
        return this.evaluator.evalAndFlag("LDClient.jsonValueVariationDetail", featureKey, context, LDValue.normalize(defaultValue), null, EvaluationOptions.EVENTS_WITH_REASONS).getResult().getAnyType();
    }

    @Override
    public MigrationVariation migrationVariation(String key, LDContext context, MigrationStage defaultStage) {
        EvalResultAndFlag res = this.migrationEvaluator.evalAndFlag("LDClient.migrationVariation", key, context, LDValue.of(defaultStage.toString()), LDValueType.STRING, EvaluationOptions.EVENTS_WITHOUT_REASONS);
        EvaluationDetail<String> resDetail = res.getResult().getAsString();
        MigrationStage stageChecked = MigrationStage.of(resDetail.getValue(), defaultStage);
        long checkRatio = 1L;
        if (res.getFlag() != null && res.getFlag().getMigration() != null && res.getFlag().getMigration().getCheckRatio() != null) {
            checkRatio = res.getFlag().getMigration().getCheckRatio();
        }
        MigrationOpTracker tracker = new MigrationOpTracker(key, res.getFlag(), resDetail, defaultStage, stageChecked, context, checkRatio, this.baseLogger);
        return new MigrationVariation(stageChecked, tracker);
    }

    @Override
    public boolean isFlagKnown(String featureKey) {
        if (!this.isInitialized()) {
            if (this.dataStore.isInitialized()) {
                this.baseLogger.warn("isFlagKnown called before client initialized for feature flag \"{}\"; using last known values from data store", (Object)featureKey);
            } else {
                this.baseLogger.warn("isFlagKnown called before client initialized for feature flag \"{}\"; data store unavailable, returning false", (Object)featureKey);
                return false;
            }
        }
        try {
            if (LDClient.getFlag(this.dataStore, featureKey) != null) {
                return true;
            }
        }
        catch (Exception e) {
            this.baseLogger.error("Encountered exception while calling isFlagKnown for feature flag \"{}\": {}", (Object)featureKey, LogValues.exceptionSummary(e));
            this.baseLogger.debug("{}", LogValues.exceptionTrace(e));
        }
        return false;
    }

    @Override
    public FlagTracker getFlagTracker() {
        return this.flagTracker;
    }

    @Override
    public BigSegmentStoreStatusProvider getBigSegmentStoreStatusProvider() {
        return this.bigSegmentStoreStatusProvider;
    }

    @Override
    public DataStoreStatusProvider getDataStoreStatusProvider() {
        return this.dataStoreStatusProvider;
    }

    @Override
    public LDLogger getLogger() {
        return this.baseLogger;
    }

    @Override
    public DataSourceStatusProvider getDataSourceStatusProvider() {
        return this.dataSourceStatusProvider;
    }

    @Override
    public void close() throws IOException {
        this.baseLogger.info("Closing LaunchDarkly Client");
        this.dataStore.close();
        this.eventProcessor.close();
        this.dataSource.close();
        this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.OFF, null);
        if (this.bigSegmentStoreWrapper != null) {
            this.bigSegmentStoreWrapper.close();
        }
        this.sharedExecutor.shutdownNow();
    }

    @Override
    public void flush() {
        this.eventProcessor.flush();
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public String secureModeHash(LDContext context) {
        if (context == null || !context.isValid()) {
            return null;
        }
        try {
            Mac mac = Mac.getInstance(HMAC_ALGORITHM);
            mac.init(new SecretKeySpec(this.sdkKey.getBytes(), HMAC_ALGORITHM));
            return Hex.encodeHexString(mac.doFinal(context.getFullyQualifiedKey().getBytes("UTF8")));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            this.baseLogger.error("Could not generate secure mode hash: {}", LogValues.exceptionSummary(e));
            this.baseLogger.debug("{}", LogValues.exceptionTrace(e));
            return null;
        }
    }

    @Override
    public String version() {
        return "7.8.0";
    }

    private ScheduledExecutorService createSharedExecutor(LDConfig config) {
        ThreadFactory threadFactory2 = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LaunchDarkly-tasks-%d").setPriority(config.threadPriority).build();
        return Executors.newSingleThreadScheduledExecutor(threadFactory2);
    }
}

