/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.eventsource;

import java.io.IOException;
import java.io.InputStream;

final class BufferedLineParser {
    private final InputStream stream;
    private final byte[] readBuffer;
    private int readBufferCount = 0;
    private int scanPos = 0;
    private int chunkStart = 0;
    private int chunkEnd = 0;
    private boolean lastCharWasCr = false;
    private boolean eof = false;

    public BufferedLineParser(InputStream stream, int bufferSize) {
        this.stream = stream;
        this.readBuffer = new byte[bufferSize];
    }

    public boolean isEof() {
        return this.eof;
    }

    public boolean read() throws IOException {
        if (this.scanPos > 0 && this.readBufferCount > this.scanPos) {
            System.arraycopy(this.readBuffer, this.scanPos, this.readBuffer, 0, this.readBufferCount - this.scanPos);
        }
        this.readBufferCount -= this.scanPos;
        this.chunkEnd = 0;
        this.chunkStart = 0;
        this.scanPos = 0;
        do {
            if (this.scanPos >= this.readBufferCount || !this.scanForTerminator()) continue;
            return true;
        } while (this.readMoreIntoBuffer());
        return false;
    }

    public byte[] getBuffer() {
        return this.readBuffer;
    }

    public int getChunkOffset() {
        return this.chunkStart;
    }

    public int getChunkSize() {
        return this.chunkEnd - this.chunkStart;
    }

    private boolean scanForTerminator() {
        byte b;
        if (this.lastCharWasCr) {
            this.lastCharWasCr = false;
            if (this.readBuffer[this.scanPos] == 10) {
                ++this.scanPos;
                ++this.chunkStart;
            }
        }
        while (this.scanPos < this.readBufferCount && (b = this.readBuffer[this.scanPos]) != 10 && b != 13) {
            ++this.scanPos;
        }
        this.chunkEnd = this.scanPos;
        if (this.scanPos == this.readBufferCount) {
            return false;
        }
        ++this.scanPos;
        if (this.readBuffer[this.chunkEnd] == 13) {
            if (this.scanPos == this.readBufferCount) {
                this.lastCharWasCr = true;
            } else if (this.readBuffer[this.scanPos] == 10) {
                ++this.scanPos;
            }
        }
        return true;
    }

    private boolean readMoreIntoBuffer() throws IOException {
        if (this.readBufferCount == this.readBuffer.length) {
            return false;
        }
        int readCount = this.stream.read(this.readBuffer, this.readBufferCount, this.readBuffer.length - this.readBufferCount);
        if (readCount < 0) {
            this.eof = true;
            return false;
        }
        this.readBufferCount += readCount;
        return true;
    }
}

