/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.logging;

import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class LogValues {
    private LogValues() {
    }

    public static Object defer(StringProvider stringProvider) {
        return new DeferImpl(stringProvider);
    }

    public static Object exceptionSummary(Throwable e) {
        return e;
    }

    public static Object exceptionTrace(final Throwable e) {
        return e == null ? null : LogValues.defer(new StringProvider(){

            @Override
            public String get() {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                return sw.toString();
            }
        });
    }

    private static final class DeferImpl {
        private final StringProvider stringProvider;

        DeferImpl(StringProvider stringProvider) {
            this.stringProvider = stringProvider;
        }

        public String toString() {
            return this.stringProvider.get();
        }
    }

    public static interface StringProvider {
        public String get();
    }
}

