/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.sdk.server.BigSegmentStoreWrapper;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataModelPreprocessing;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.EvaluationRecorder;
import com.launchdarkly.sdk.server.EvaluatorBucketing;
import com.launchdarkly.sdk.server.EvaluatorHelpers;
import com.launchdarkly.sdk.server.PrerequisiteEvalRecord;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStoreTypes;
import com.launchdarkly.shaded.javax.annotation.Nonnull;
import com.launchdarkly.shaded.javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Evaluator {
    static final String INVALID_FLAG_KEY_THAT_THROWS_EXCEPTION = "$ test error flag $";
    static final RuntimeException EXPECTED_EXCEPTION_FROM_INVALID_FLAG = new RuntimeException("deliberate test error");
    private final Getters getters;
    private final LDLogger logger;

    Evaluator(Getters getters, LDLogger logger) {
        this.getters = getters;
        this.logger = logger;
    }

    EvalResult evaluate(DataModel.FeatureFlag flag, LDContext context, @Nonnull EvaluationRecorder recorder) {
        if (flag.getKey() == INVALID_FLAG_KEY_THAT_THROWS_EXCEPTION) {
            throw EXPECTED_EXCEPTION_FROM_INVALID_FLAG;
        }
        EvaluatorState state = new EvaluatorState();
        state.originalFlag = flag;
        try {
            EvalResult result = this.evaluateInternal(flag, context, recorder, state);
            if (state.bigSegmentsStatus != null) {
                result = result.withReason(result.getReason().withBigSegmentsStatus(state.bigSegmentsStatus));
            }
            if (state.prerequisiteEvalRecords != null && !state.prerequisiteEvalRecords.isEmpty()) {
                result = result.withPrerequisiteEvalRecords(state.prerequisiteEvalRecords);
            }
            return result;
        }
        catch (EvaluationException e) {
            this.logger.error("Could not evaluate flag \"{}\": {}", (Object)flag.getKey(), (Object)e.getMessage());
            return EvalResult.error(e.errorKind);
        }
    }

    private EvalResult evaluateInternal(DataModel.FeatureFlag flag, LDContext context, @Nonnull EvaluationRecorder recorder, EvaluatorState state) {
        if (!flag.isOn()) {
            return EvaluatorHelpers.offResult(flag);
        }
        EvalResult prereqFailureResult = this.checkPrerequisites(flag, context, recorder, state);
        if (prereqFailureResult != null) {
            return prereqFailureResult;
        }
        EvalResult targetMatchResult = Evaluator.checkTargets(flag, context);
        if (targetMatchResult != null) {
            return targetMatchResult;
        }
        List<DataModel.Rule> rules = flag.getRules();
        int nRules = rules.size();
        for (int i = 0; i < nRules; ++i) {
            DataModel.Rule rule = rules.get(i);
            if (!this.ruleMatchesContext(flag, rule, context, state)) continue;
            return this.computeRuleMatch(flag, context, rule, i);
        }
        return this.getValueForVariationOrRollout(flag, flag.getFallthrough(), context, flag.preprocessed == null ? null : flag.preprocessed.fallthroughResults, EvaluationReason.fallthrough());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EvalResult checkPrerequisites(DataModel.FeatureFlag flag, LDContext context, @Nonnull EvaluationRecorder recorder, EvaluatorState state) {
        List<DataModel.Prerequisite> prerequisites = flag.getPrerequisites();
        int nPrerequisites = prerequisites.size();
        if (nPrerequisites == 0) {
            return null;
        }
        try {
            if (flag != state.originalFlag) {
                if (state.prerequisiteStack == null) {
                    state.prerequisiteStack = new ArrayList();
                }
                state.prerequisiteStack.add(flag.getKey());
            }
            for (int i = 0; i < nPrerequisites; ++i) {
                DataModel.Prerequisite prereq = prerequisites.get(i);
                String prereqKey = prereq.getKey();
                if (prereqKey.equals(state.originalFlag.getKey()) || flag != state.originalFlag && prereqKey.equals(flag.getKey()) || state.prerequisiteStack != null && state.prerequisiteStack.contains(prereqKey)) {
                    throw new EvaluationException(EvaluationReason.ErrorKind.MALFORMED_FLAG, "prerequisite relationship to \"" + prereqKey + "\" caused a circular reference; this is probably a temporary condition due to an incomplete update");
                }
                boolean prereqOk = true;
                DataModel.FeatureFlag prereqFeatureFlag = this.getters.getFlag(prereq.getKey());
                if (prereqFeatureFlag == null) {
                    this.logger.error("Could not retrieve prerequisite flag \"{}\" when evaluating \"{}\"", (Object)prereq.getKey(), (Object)flag.getKey());
                    prereqOk = false;
                } else {
                    EvalResult prereqEvalResult = this.evaluateInternal(prereqFeatureFlag, context, recorder, state);
                    if (!prereqFeatureFlag.isOn() || prereqEvalResult.getVariationIndex() != prereq.getVariation()) {
                        prereqOk = false;
                    }
                    state.prerequisiteEvalRecords.add(new PrerequisiteEvalRecord(prereqFeatureFlag, flag, prereqEvalResult));
                    recorder.recordPrerequisiteEvaluation(prereqFeatureFlag, flag, context, prereqEvalResult);
                }
                if (prereqOk) continue;
                EvalResult evalResult = EvaluatorHelpers.prerequisiteFailedResult(flag, prereq);
                return evalResult;
            }
            EvalResult evalResult = null;
            return evalResult;
        }
        finally {
            if (state.prerequisiteStack != null && !state.prerequisiteStack.isEmpty()) {
                state.prerequisiteStack.remove(state.prerequisiteStack.size() - 1);
            }
        }
    }

    private static EvalResult checkTargets(DataModel.FeatureFlag flag, LDContext context) {
        List<DataModel.Target> contextTargets = flag.getContextTargets();
        List<DataModel.Target> userTargets = flag.getTargets();
        int nContextTargets = contextTargets.size();
        int nUserTargets = userTargets.size();
        if (nContextTargets == 0) {
            LDContext userContext;
            if (nUserTargets != 0 && (userContext = context.getIndividualContext(ContextKind.DEFAULT)) != null) {
                for (int i = 0; i < nUserTargets; ++i) {
                    DataModel.Target t2 = userTargets.get(i);
                    if (!t2.getValues().contains(userContext.getKey())) continue;
                    return EvaluatorHelpers.targetMatchResult(flag, t2);
                }
            }
            return null;
        }
        block1: for (int i = 0; i < nContextTargets; ++i) {
            DataModel.Target t3 = contextTargets.get(i);
            if (t3.getContextKind() == null || t3.getContextKind().isDefault()) {
                LDContext userContext = context.getIndividualContext(ContextKind.DEFAULT);
                if (userContext == null) continue;
                for (int j = 0; j < nUserTargets; ++j) {
                    DataModel.Target ut = userTargets.get(j);
                    if (ut.getVariation() != t3.getVariation()) continue;
                    if (!ut.getValues().contains(userContext.getKey())) continue block1;
                    return EvaluatorHelpers.targetMatchResult(flag, t3);
                }
                continue;
            }
            if (!EvaluatorHelpers.contextKeyIsInTargetList(context, t3.getContextKind(), t3.getValues())) continue;
            return EvaluatorHelpers.targetMatchResult(flag, t3);
        }
        return null;
    }

    private EvalResult getValueForVariationOrRollout(DataModel.FeatureFlag flag, DataModel.VariationOrRollout vr, LDContext context, DataModelPreprocessing.EvalResultFactoryMultiVariations precomputedResults, EvaluationReason reason) {
        int variation = -1;
        boolean inExperiment = false;
        Integer maybeVariation = vr.getVariation();
        if (maybeVariation != null) {
            variation = maybeVariation;
        } else {
            DataModel.Rollout rollout = vr.getRollout();
            if (rollout != null && !rollout.getVariations().isEmpty()) {
                float bucket = EvaluatorBucketing.computeBucketValue(rollout.isExperiment(), rollout.getSeed(), context, rollout.getContextKind(), flag.getKey(), rollout.getBucketBy(), flag.getSalt());
                boolean contextWasFound = bucket >= 0.0f;
                float sum = 0.0f;
                List<DataModel.WeightedVariation> variations = rollout.getVariations();
                int nVariations = variations.size();
                for (int i = 0; i < nVariations; ++i) {
                    DataModel.WeightedVariation wv = variations.get(i);
                    if (!(bucket < (sum += (float)wv.getWeight() / 100000.0f))) continue;
                    variation = wv.getVariation();
                    inExperiment = vr.getRollout().isExperiment() && !wv.isUntracked() && contextWasFound;
                    break;
                }
                if (variation < 0) {
                    DataModel.WeightedVariation lastVariation = rollout.getVariations().get(rollout.getVariations().size() - 1);
                    variation = lastVariation.getVariation();
                    boolean bl = inExperiment = vr.getRollout().isExperiment() && !lastVariation.isUntracked();
                }
            }
        }
        if (variation < 0) {
            this.logger.error("Data inconsistency in feature flag \"{}\": variation/rollout object with no variation or rollout", (Object)flag.getKey());
            return EvalResult.error(EvaluationReason.ErrorKind.MALFORMED_FLAG);
        }
        if (precomputedResults != null) {
            return precomputedResults.forVariation(variation, inExperiment);
        }
        return EvalResult.of(EvaluatorHelpers.evaluationDetailForVariation(flag, variation, inExperiment ? Evaluator.experimentize(reason) : reason));
    }

    private static EvaluationReason experimentize(EvaluationReason reason) {
        if (reason.getKind() == EvaluationReason.Kind.FALLTHROUGH) {
            return EvaluationReason.fallthrough(true);
        }
        if (reason.getKind() == EvaluationReason.Kind.RULE_MATCH) {
            return EvaluationReason.ruleMatch(reason.getRuleIndex(), reason.getRuleId(), true);
        }
        return reason;
    }

    private boolean ruleMatchesContext(DataModel.FeatureFlag flag, DataModel.Rule rule, LDContext context, EvaluatorState state) {
        List<DataModel.Clause> clauses = rule.getClauses();
        int nClauses = clauses.size();
        for (int i = 0; i < nClauses; ++i) {
            DataModel.Clause clause = clauses.get(i);
            if (this.clauseMatchesContext(clause, context, state)) continue;
            return false;
        }
        return true;
    }

    private boolean clauseMatchesContext(DataModel.Clause clause, LDContext context, EvaluatorState state) {
        if (clause.getOp() == DataModel.Operator.segmentMatch) {
            return EvaluatorHelpers.maybeNegate(clause, this.matchAnySegment(clause.getValues(), context, state));
        }
        AttributeRef attr = clause.getAttribute();
        if (attr == null) {
            throw new EvaluationException(EvaluationReason.ErrorKind.MALFORMED_FLAG, "rule clause did not specify an attribute");
        }
        if (!attr.isValid()) {
            throw new EvaluationException(EvaluationReason.ErrorKind.MALFORMED_FLAG, "invalid attribute reference \"" + attr.getError() + "\"");
        }
        if (attr.getDepth() == 1 && attr.getComponent(0).equals("kind")) {
            return EvaluatorHelpers.maybeNegate(clause, EvaluatorHelpers.matchClauseByKind(clause, context));
        }
        LDContext actualContext = context.getIndividualContext(clause.getContextKind());
        if (actualContext == null) {
            return false;
        }
        LDValue contextValue = actualContext.getValue(attr);
        if (contextValue.isNull()) {
            return false;
        }
        if (contextValue.getType() == LDValueType.ARRAY) {
            int nValues = contextValue.size();
            for (int i = 0; i < nValues; ++i) {
                LDValue value = contextValue.get(i);
                if (!EvaluatorHelpers.matchClauseWithoutSegments(clause, value)) continue;
                return EvaluatorHelpers.maybeNegate(clause, true);
            }
            return EvaluatorHelpers.maybeNegate(clause, false);
        }
        if (contextValue.getType() != LDValueType.OBJECT) {
            return EvaluatorHelpers.maybeNegate(clause, EvaluatorHelpers.matchClauseWithoutSegments(clause, contextValue));
        }
        return false;
    }

    private boolean matchAnySegment(List<LDValue> values2, LDContext context, EvaluatorState state) {
        int nValues = values2.size();
        for (int i = 0; i < nValues; ++i) {
            LDValue clauseValue = values2.get(i);
            if (!clauseValue.isString()) continue;
            String segmentKey = clauseValue.stringValue();
            if (state.segmentStack != null && state.segmentStack.contains(segmentKey)) {
                throw new EvaluationException(EvaluationReason.ErrorKind.MALFORMED_FLAG, "segment rule referencing segment \"" + segmentKey + "\" caused a circular reference; this is probably a temporary condition due to an incomplete update");
            }
            DataModel.Segment segment = this.getters.getSegment(segmentKey);
            if (segment == null || !this.segmentMatchesContext(segment, context, state)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean segmentMatchesContext(DataModel.Segment segment, LDContext context, EvaluatorState state) {
        List<DataModel.SegmentRule> rules;
        if (segment.isUnbounded()) {
            Boolean membershipResult;
            BigSegmentStoreTypes.Membership membershipData;
            if (segment.getGeneration() == null) {
                state.bigSegmentsStatus = EvaluationReason.BigSegmentsStatus.NOT_CONFIGURED;
                return false;
            }
            LDContext matchContext = context.getIndividualContext(segment.getUnboundedContextKind());
            if (matchContext == null) {
                return false;
            }
            String key = matchContext.getKey();
            BigSegmentStoreTypes.Membership membership = membershipData = state.bigSegmentsMembership == null ? null : (BigSegmentStoreTypes.Membership)state.bigSegmentsMembership.get(key);
            if (membershipData == null) {
                BigSegmentStoreWrapper.BigSegmentsQueryResult queryResult = this.getters.getBigSegments(key);
                if (queryResult == null) {
                    state.bigSegmentsStatus = EvaluationReason.BigSegmentsStatus.NOT_CONFIGURED;
                } else {
                    membershipData = queryResult.membership;
                    state.bigSegmentsStatus = queryResult.status;
                    if (state.bigSegmentsMembership == null) {
                        state.bigSegmentsMembership = new HashMap();
                    }
                    state.bigSegmentsMembership.put(key, membershipData);
                }
            }
            Boolean bl = membershipResult = membershipData == null ? null : membershipData.checkMembership(Evaluator.makeBigSegmentRef(segment));
            if (membershipResult != null) {
                return membershipResult;
            }
        } else {
            if (EvaluatorHelpers.contextKeyIsInTargetList(context, ContextKind.DEFAULT, segment.getIncluded())) {
                return true;
            }
            if (EvaluatorHelpers.contextKeyIsInTargetLists(context, segment.getIncludedContexts())) {
                return true;
            }
            if (EvaluatorHelpers.contextKeyIsInTargetList(context, ContextKind.DEFAULT, segment.getExcluded())) {
                return false;
            }
            if (EvaluatorHelpers.contextKeyIsInTargetLists(context, segment.getExcludedContexts())) {
                return false;
            }
        }
        if (!(rules = segment.getRules()).isEmpty()) {
            if (state.segmentStack == null) {
                state.segmentStack = new ArrayList();
            }
            state.segmentStack.add(segment.getKey());
            int nRules = rules.size();
            try {
                for (int i = 0; i < nRules; ++i) {
                    DataModel.SegmentRule rule = rules.get(i);
                    if (!this.segmentRuleMatchesContext(rule, context, state, segment.getKey(), segment.getSalt())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                state.segmentStack.remove(state.segmentStack.size() - 1);
            }
        }
        return false;
    }

    private boolean segmentRuleMatchesContext(DataModel.SegmentRule segmentRule, LDContext context, EvaluatorState state, String segmentKey, String salt) {
        double weight;
        List<DataModel.Clause> clauses = segmentRule.getClauses();
        int nClauses = clauses.size();
        for (int i = 0; i < nClauses; ++i) {
            DataModel.Clause c = clauses.get(i);
            if (this.clauseMatchesContext(c, context, state)) continue;
            return false;
        }
        if (segmentRule.getWeight() == null) {
            return true;
        }
        double bucket = EvaluatorBucketing.computeBucketValue(false, null, context, segmentRule.getRolloutContextKind(), segmentKey, segmentRule.getBucketBy(), salt);
        return bucket < (weight = (double)segmentRule.getWeight().intValue() / 100000.0);
    }

    private EvalResult computeRuleMatch(DataModel.FeatureFlag flag, LDContext context, DataModel.Rule rule, int ruleIndex) {
        if (rule.preprocessed != null) {
            return this.getValueForVariationOrRollout(flag, rule, context, rule.preprocessed.allPossibleResults, null);
        }
        EvaluationReason reason = EvaluationReason.ruleMatch(ruleIndex, rule.getId());
        return this.getValueForVariationOrRollout(flag, rule, context, null, reason);
    }

    static String makeBigSegmentRef(DataModel.Segment segment) {
        return String.format("%s.g%d", segment.getKey(), segment.getGeneration());
    }

    private static class EvaluatorState {
        private Map<String, BigSegmentStoreTypes.Membership> bigSegmentsMembership = null;
        private EvaluationReason.BigSegmentsStatus bigSegmentsStatus = null;
        private DataModel.FeatureFlag originalFlag = null;
        private List<String> prerequisiteStack = null;
        private List<PrerequisiteEvalRecord> prerequisiteEvalRecords = new ArrayList<PrerequisiteEvalRecord>(0);
        private List<String> segmentStack = null;

        private EvaluatorState() {
        }
    }

    static class EvaluationException
    extends RuntimeException {
        final EvaluationReason.ErrorKind errorKind;

        EvaluationException(EvaluationReason.ErrorKind errorKind, String message) {
            this.errorKind = errorKind;
        }
    }

    static interface Getters {
        @Nullable
        public DataModel.FeatureFlag getFlag(String var1);

        @Nullable
        public DataModel.Segment getSegment(String var1);

        public BigSegmentStoreWrapper.BigSegmentsQueryResult getBigSegments(String var1);
    }
}

