/*
 * Decompiled with CFR 0.152.
 */
package com.layer1.clients.auth;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Layer1Digest {
    private static final String SIGNATURE_ALGORITHM = "rsa-v1_5-sha256";
    private static final String DIGEST_ALGORITHM = "sha-256";
    private final PrivateKey signingKey;
    private final String clientId;

    public Layer1Digest(String signingPrivateKey, String clientId) {
        this.clientId = clientId;
        try {
            String preparedKey = this.prepareKey(signingPrivateKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.signingKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(preparedKey)));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load private key", e);
        }
    }

    public Map<String, String> buildHeaders(String url, String payload, String method) {
        HashMap<String, String> headerParams = new HashMap<String, String>();
        String contentDigest = null;
        if (!Objects.isNull(payload) && !payload.isEmpty()) {
            try {
                contentDigest = this.createDigest(DIGEST_ALGORITHM, payload);
                headerParams.put("Content-Digest", contentDigest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Failed to create digest", e);
            }
        }
        String signatureParameters = this.createSignatureParameters(contentDigest);
        headerParams.put("Signature-Input", "sig=" + signatureParameters);
        try {
            headerParams.put("Signature", String.format("sig=:%s:", this.sign(String.format("\"@method\": %s%n\"@target-uri\": %s%n%s\"@signature-params\": %s", method.toUpperCase(), url, contentDigest == null ? "" : "\"content-digest\": " + contentDigest + "\n", signatureParameters), this.signingKey)));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to sign request", e);
        }
        return headerParams;
    }

    private String sign(String signatureBase, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signer = Signature.getInstance("SHA256withRSA");
        signer.initSign(privateKey);
        signer.update(signatureBase.getBytes());
        return Base64.getEncoder().encodeToString(signer.sign());
    }

    private String createSignatureParameters(String contentDigest) {
        return String.format("(\"@method\" \"@target-uri\"%s);created=%d;keyid=\"%s\";alg=\"%s\"", contentDigest == null ? "" : " \"content-digest\"", Instant.now().toEpochMilli() / 1000L, this.clientId, SIGNATURE_ALGORITHM);
    }

    private String createDigest(String digestAlgorithm, String data) throws NoSuchAlgorithmException {
        return String.format("%s=:%s:", digestAlgorithm, this.getDigest(digestAlgorithm, data));
    }

    private String getDigest(String algorithm, String data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        byte[] hash = digest.digest(data.getBytes());
        return Base64.getEncoder().encodeToString(hash);
    }

    private String prepareKey(String rawKey) {
        String newKey = rawKey.replace("-----BEGIN PRIVATE KEY-----", "");
        newKey = newKey.replace("-----END PRIVATE KEY-----", "");
        return newKey.replaceAll("\\s+", "");
    }
}

