/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.analyzer;

public class Check {
    private double threshold = -1.0;
    private double tolerance = 5.0;
    private ToleranceDirection toleranceDirection = ToleranceDirection.UPPER_LOWER_TOLERANCE;
    private double minValue;
    private double maxValue;

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
        this.updateMinMaxValue();
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
        this.updateMinMaxValue();
    }

    public void setToleranceDirection(String toleranceDirection) {
        this.toleranceDirection = ToleranceDirection.valueOf(toleranceDirection);
        this.updateMinMaxValue();
    }

    public Boolean valid(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Value must be positive. " + value);
        }
        if (this.threshold >= 0.0) {
            if (ToleranceDirection.EQUALS.equals((Object)this.toleranceDirection)) {
                return value == this.threshold;
            }
            return value >= this.minValue && value <= this.maxValue;
        }
        return null;
    }

    private void updateMinMaxValue() {
        this.maxValue = ToleranceDirection.UPPER_TOLERANCE.equals((Object)this.toleranceDirection) || ToleranceDirection.UPPER_LOWER_TOLERANCE.equals((Object)this.toleranceDirection) ? this.threshold + this.threshold * this.tolerance / 100.0 : (ToleranceDirection.UPPER.equals((Object)this.toleranceDirection) ? Double.MAX_VALUE : this.threshold);
        this.minValue = ToleranceDirection.LOWER_TOLERANCE.equals((Object)this.toleranceDirection) || ToleranceDirection.UPPER_LOWER_TOLERANCE.equals((Object)this.toleranceDirection) ? this.threshold - this.threshold * this.tolerance / 100.0 : (ToleranceDirection.LOWER.equals((Object)this.toleranceDirection) ? 0.0 : this.threshold);
    }

    static enum ToleranceDirection {
        UPPER,
        LOWER,
        UPPER_TOLERANCE,
        LOWER_TOLERANCE,
        UPPER_LOWER_TOLERANCE,
        EQUALS;

    }
}

