/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.analyzer.util;

import com.lazerycode.jmeter.analyzer.config.Environment;
import com.lazerycode.jmeter.analyzer.parser.AggregatedResponses;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import org.codehaus.plexus.util.StringUtils;

public class FileUtil {
    private static final String TOKEN_FROM = "_FROM_";
    private static final String TOKEN_TO = "_TO_";
    private static final int READ_BUFFER = 1024;

    public static String urlEncode(String name) throws UnsupportedEncodingException {
        return URLEncoder.encode(name, "UTF-8");
    }

    public static File initializeFile(File dir, String name, String resultDataFileRelativePath) throws IOException {
        File result;
        File directory = dir;
        if (Environment.ENVIRONMENT.isPreserveDirectories() && StringUtils.isNotEmpty((String)resultDataFileRelativePath)) {
            String filename = dir.getAbsolutePath() + File.separator + resultDataFileRelativePath;
            directory = new File(filename);
        }
        if (!(result = new File(directory, name)).getParentFile().mkdirs() && !result.getParentFile().exists()) {
            throw new IOException("Cannot create directories: " + result.getParentFile().getAbsolutePath());
        }
        if (result.exists() && !result.delete()) {
            throw new IOException("Failed to delete file: " + result.getAbsolutePath());
        }
        if (!result.createNewFile()) {
            throw new IOException("Failed to create file: " + result.getAbsolutePath());
        }
        return result;
    }

    public static void readResources(Properties remoteResources, File targetDir, String resultDataFileRelativePath, Collection<AggregatedResponses> testResults, String fromuntilDateFormat) throws IOException {
        long[] startEnd = FileUtil.getStartEnd(testResults);
        long start = startEnd[0];
        long end = startEnd[1];
        SimpleDateFormat dateFormat = new SimpleDateFormat(fromuntilDateFormat);
        String fromString = FileUtil.urlEncode(dateFormat.format(new Date(start)));
        String endString = FileUtil.urlEncode(dateFormat.format(new Date(end)));
        for (String url : remoteResources.stringPropertyNames()) {
            String fullUrl = url.replace(TOKEN_FROM, fromString);
            fullUrl = fullUrl.replace(TOKEN_TO, endString);
            String fileName = remoteResources.getProperty(url);
            File file = FileUtil.initializeFile(targetDir, fileName, resultDataFileRelativePath);
            FileUtil.read(fullUrl, file);
        }
    }

    private static long[] getStartEnd(Collection<AggregatedResponses> testResults) {
        long from = Long.MAX_VALUE;
        long to = 0L;
        for (AggregatedResponses entry : testResults) {
            if (from > entry.getStart()) {
                from = entry.getStart();
            }
            if (to >= entry.getEnd()) continue;
            to = entry.getEnd();
        }
        return new long[]{from, to};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void read(String url, File target) throws IOException {
        try {
            URLConnection connection = new URL(url).openConnection();
            InputStream in = connection.getInputStream();
            try {
                FileOutputStream out = new FileOutputStream(target);
                try {
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = in.read(buffer)) > -1) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            throw new IOException("Error writing " + url + " to " + target, e);
        }
    }
}

