/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.analyzer.writer;

import com.google.common.annotations.VisibleForTesting;
import com.lazerycode.jmeter.analyzer.ConfigurationCharts;
import com.lazerycode.jmeter.analyzer.config.Environment;
import com.lazerycode.jmeter.analyzer.parser.AggregatedResponses;
import com.lazerycode.jmeter.analyzer.statistics.Quantile;
import com.lazerycode.jmeter.analyzer.statistics.Samples;
import com.lazerycode.jmeter.analyzer.util.FileUtil;
import com.lazerycode.jmeter.analyzer.writer.ChartUtil;
import com.lazerycode.jmeter.analyzer.writer.WriterBase;
import freemarker.template.TemplateException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ChartWriter
extends WriterBase {
    private static final int Q = 1000;
    private static final long SECONDS_ROUND = 10L;

    public boolean equals(Object obj) {
        return obj instanceof ChartWriter;
    }

    @Override
    public void write(Map<String, AggregatedResponses> testResults) throws IOException, TemplateException {
        for (Map.Entry<String, AggregatedResponses> entry : testResults.entrySet()) {
            String name = entry.getKey();
            AggregatedResponses aggregatedResponses = entry.getValue();
            this.writeCharts(aggregatedResponses, name);
        }
    }

    @VisibleForTesting
    protected OutputStream getOut(File file) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    private void writeCharts(AggregatedResponses aggregatedResponses, String name) throws IOException, TemplateException {
        XYPlot durationPlot = this.createDurationPlot(aggregatedResponses);
        XYPlot sizePlot = this.createSizePlot(aggregatedResponses);
        XYPlot activeThreadsPlot = this.createActiveThreadsPlot(aggregatedResponses);
        XYPlot throughputPlot = this.createThroughputPlot(aggregatedResponses);
        XYPlot responseTimesPlot = this.createResponseTimesPlot(aggregatedResponses);
        CombinedDomainXYPlot combinedThroughputActiveThreadsPlot = ChartUtil.createCombinedDomainDatePlot();
        combinedThroughputActiveThreadsPlot.add(throughputPlot, 2);
        combinedThroughputActiveThreadsPlot.add(activeThreadsPlot, 1);
        File requestChartFile = this.getFile(this.chartFileName(name, "-throughput-"));
        String chartName = "Throughput (" + name + ")";
        this.renderChart(chartName, (XYPlot)combinedThroughputActiveThreadsPlot, requestChartFile);
        requestChartFile = this.getFile(this.chartFileName(name, "-response_times-"));
        chartName = "Response times (" + name + ")";
        this.renderChart(chartName, responseTimesPlot, requestChartFile);
        requestChartFile = this.getFile(this.chartFileName(name, "-durations-"));
        chartName = "Requests Duration (" + name + ")";
        this.renderChart(chartName, durationPlot, requestChartFile);
        requestChartFile = this.getFile(this.chartFileName(name, "-sizes-"));
        chartName = "Requests Size (" + name + ")";
        this.renderChart(chartName, sizePlot, requestChartFile);
    }

    private XYPlot createDurationPlot(AggregatedResponses aggregatedResponses) {
        XYPlot plot = ChartUtil.createDatePlot("Duration (ms)");
        Samples durations = aggregatedResponses.getDuration();
        ChartUtil.addDatasetRender(plot, (XYDataset)new XYSeriesCollection(this.createAverageValuesSeries("Average", durations.getTimestamps(), durations.getSamples(), durations.getMinTimestamp())), (XYItemRenderer)ChartUtil.createLineAndShapeRenderer());
        return ChartUtil.addDatasetRender(plot, (XYDataset)new XYSeriesCollection(this.createValuesSeries("Duration", durations.getTimestamps(), durations.getSamples(), durations.getMinTimestamp())), (XYItemRenderer)ChartUtil.createBarRenderer());
    }

    private XYPlot createSizePlot(AggregatedResponses aggregatedResponses) {
        XYPlot plot = ChartUtil.createDatePlot("Size (bytes)");
        Samples durations = aggregatedResponses.getSize();
        ChartUtil.addDatasetRender(plot, (XYDataset)new XYSeriesCollection(this.createAverageValuesSeries("Average", durations.getTimestamps(), durations.getSamples(), durations.getMinTimestamp())), (XYItemRenderer)ChartUtil.createLineAndShapeRenderer());
        return ChartUtil.addDatasetRender(plot, (XYDataset)new XYSeriesCollection(this.createValuesSeries("Size", durations.getTimestamps(), durations.getSamples(), durations.getMinTimestamp())), (XYItemRenderer)ChartUtil.createBarRenderer());
    }

    private XYPlot createActiveThreadsPlot(AggregatedResponses aggregatedResponses) {
        XYPlot plot = ChartUtil.createDatePlot("Thread Count");
        Samples activeThreads = aggregatedResponses.getActiveThreads();
        return ChartUtil.addDatasetRender(plot, (XYDataset)new XYSeriesCollection(this.createValuesSeries("Threads", activeThreads.getTimestamps(), activeThreads.getSamples(), activeThreads.getMinTimestamp())), (XYItemRenderer)ChartUtil.createSecondaryLineAndShapeRenderer());
    }

    private XYPlot createThroughputPlot(AggregatedResponses aggregatedResponses) {
        TreeMap<Long, Long> throughput = new TreeMap<Long, Long>();
        for (long timestamp : aggregatedResponses.getActiveThreads().getTimestamps()) {
            long timestampRound = this.convert(timestamp);
            Long throughputResult = (Long)throughput.get(timestampRound);
            if (null == throughputResult) {
                throughput.put(timestampRound, 10L);
                continue;
            }
            throughputResult = throughputResult + 10L;
            throughput.put(timestampRound, throughputResult);
        }
        ArrayList<Long> timestamps = new ArrayList<Long>(throughput.keySet());
        ArrayList<Long> samples = new ArrayList<Long>(throughput.values());
        long minTimestamp = this.convert(aggregatedResponses.getActiveThreads().getMinTimestamp());
        XYPlot plot = ChartUtil.createDatePlot("Requests (req/s)");
        ChartUtil.addDatasetRender(plot, (XYDataset)new XYSeriesCollection(this.createAverageValuesSeries("Average", timestamps, samples, minTimestamp)), (XYItemRenderer)ChartUtil.createLineAndShapeRenderer());
        return ChartUtil.addDatasetRender(plot, (XYDataset)new XYSeriesCollection(this.createValuesSeries("Throughput", timestamps, samples, minTimestamp)), (XYItemRenderer)ChartUtil.createLineAndShapeRenderer());
    }

    private XYPlot createResponseTimesPlot(AggregatedResponses aggregatedResponses) {
        Samples durations = aggregatedResponses.getDuration();
        double[] values = new double[durations.getSamples().size()];
        for (int i = 0; i < durations.getSamples().size(); ++i) {
            values[i] = durations.getSamples().get(i).longValue();
        }
        HistogramDataset histogramdataset = new HistogramDataset();
        histogramdataset.addSeries((Comparable)((Object)"Request Count"), values, 40);
        ArrayList<Double> y = new ArrayList<Double>(1001);
        ArrayList<Long> x = new ArrayList<Long>(1001);
        Quantile quantile = durations.getQuantiles(1000);
        y.add(0.0);
        x.add(0L);
        for (int i = 1; i < 1000; ++i) {
            y.add((double)i / 10.0);
            x.add(quantile.getQuantile(i));
        }
        y.add(100.0);
        x.add(durations.getMax());
        XYPlot plot = ChartUtil.createResponseTimesPlot("Response Times (ms)");
        ChartUtil.addDatasetRender(plot, (XYDataset)new XYSeriesCollection(this.createValuesSeries("Percentiles", x, y, 0L)), (XYItemRenderer)ChartUtil.createLineAndShapeRenderer());
        ChartUtil.addDatasetRender(plot, (XYDataset)histogramdataset, (XYItemRenderer)ChartUtil.createBarRenderer());
        plot.mapDatasetToRangeAxis(1, 1);
        return plot;
    }

    private XYSeries createValuesSeries(String seriesName, List<? extends Number> x, List<? extends Number> y, long minimumTimestamp) {
        XYSeries series = new XYSeries((Comparable)((Object)seriesName));
        for (int i = 0; i < y.size(); ++i) {
            series.add(x.get(i).doubleValue() - (double)minimumTimestamp, y.get(i));
        }
        return series;
    }

    private XYSeries createAverageValuesSeries(String seriesName, List<Long> x, List<Long> y, long minimumTimestamp) {
        XYSeries series = new XYSeries((Comparable)((Object)seriesName));
        long total = 0L;
        for (int i = 0; i < y.size(); ++i) {
            long current = y.get(i);
            long timestamp = x.get(i);
            series.add((double)(timestamp - minimumTimestamp), (double)(total += current) / ((double)i + 1.0));
        }
        return series;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderChart(String name, XYPlot plot, File target) throws IOException {
        OutputStream out = this.getOut(target);
        try {
            ConfigurationCharts configurationCharts = Environment.ENVIRONMENT.getConfigurationCharts();
            ChartUtilities.writeChartAsPNG((OutputStream)out, (JFreeChart)ChartUtil.createJFreeChart(name, plot, configurationCharts.getHeight()), (int)configurationCharts.getWidth(), (int)configurationCharts.getHeight(), null);
        }
        finally {
            out.close();
        }
    }

    private String chartFileName(String name, String type) throws UnsupportedEncodingException {
        return FileUtil.urlEncode(name) + type + super.getFileName() + ".png";
    }

    private long convert(long timestamp) {
        long ratio = 100L;
        return timestamp / ratio * ratio;
    }
}

