/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.configuration;

import com.lazerycode.jmeter.configuration.JMeterCommandLineArguments;
import com.lazerycode.jmeter.properties.JMeterPropertiesFiles;
import com.lazerycode.jmeter.properties.PropertyContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RemoteArgumentsArrayBuilder {
    public List<String> buildRemoteArgumentsArray(Map<JMeterPropertiesFiles, PropertyContainer> masterPropertiesMap) {
        if (masterPropertiesMap == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<JMeterPropertiesFiles, PropertyContainer> entry : masterPropertiesMap.entrySet()) {
            Properties properties = entry.getValue().getFinalPropertyObject();
            switch (entry.getKey()) {
                case SYSTEM_PROPERTIES: {
                    result.addAll(this.buildTypedPropertiesForContainer(JMeterCommandLineArguments.SYSTEM_PROPERTY, properties));
                    break;
                }
                case GLOBAL_PROPERTIES: {
                    result.addAll(this.buildTypedPropertiesForContainer(JMeterCommandLineArguments.JMETER_GLOBAL_PROP, properties));
                    break;
                }
            }
        }
        return result;
    }

    private List<String> buildTypedPropertiesForContainer(JMeterCommandLineArguments cmdLineArg, Properties props) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            if (cmdLineArg == JMeterCommandLineArguments.SYSTEM_PROPERTY) {
                result.add(cmdLineArg.getCommandLineArgument() + e.getKey());
                result.add(e.getValue().toString());
                continue;
            }
            result.add(cmdLineArg.getCommandLineArgument() + e.getKey() + "=" + e.getValue());
        }
        return result;
    }
}

