/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ErrorScanner {
    private static final String ERROR_ELEMENT = "<error>true</error>";
    private static final String REQUEST_FAILURE_ELEMENT = "s=\"false\"";
    private static final String FAILURE_ELEMENT = "<failure>true</failure>";
    private boolean ignoreErrors;
    private boolean ignoreFailures;
    private int failureCount = 0;
    private int errorCount = 0;

    public ErrorScanner(boolean ignoreErrors, boolean ignoreFailures) {
        this.ignoreErrors = ignoreErrors;
        this.ignoreFailures = ignoreFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTestPassed(File file) throws IOException {
        this.resetErrorAndFailureCount();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                this.checkLineForErrors(line);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return this.errorCount == 0 && this.failureCount == 0;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    protected boolean checkLineForErrors(String line) {
        boolean lineContainsError = false;
        if (line.contains(ERROR_ELEMENT) && !this.ignoreErrors) {
            ++this.errorCount;
            lineContainsError = true;
        }
        if ((line.contains(FAILURE_ELEMENT) || line.contains(REQUEST_FAILURE_ELEMENT)) && !this.ignoreFailures) {
            ++this.failureCount;
            lineContainsError = true;
        }
        return lineContainsError;
    }

    private void resetErrorAndFailureCount() {
        this.failureCount = 0;
        this.errorCount = 0;
    }
}

