/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter;

import com.lazerycode.jmeter.ErrorScanner;
import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.configuration.ProxyConfig;
import com.lazerycode.jmeter.configuration.RemoteConfig;
import com.lazerycode.jmeter.configuration.ReportConfig;
import com.lazerycode.jmeter.properties.JMeterPropertiesFiles;
import com.lazerycode.jmeter.properties.PropertyHandler;
import com.lazerycode.jmeter.reporting.ReportGenerator;
import com.lazerycode.jmeter.testrunner.TestManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class JMeterMojo
extends AbstractMojo {
    private List<String> testFilesIncluded;
    private List<String> testFilesExcluded;
    private File testFilesDirectory;
    private boolean testResultsTimestamp;
    private Map<String, String> propertiesJMeter;
    private Map<String, String> propertiesSaveService;
    private Map<String, String> propertiesUpgrade;
    private Map<String, String> propertiesUser;
    private Map<String, String> propertiesGlobal;
    private Map<String, String> propertiesSystem;
    private boolean propertiesReplacedByCustomFiles;
    private boolean ignoreResultFailures;
    private boolean ignoreResultErrors;
    private ProxyConfig proxyConfig;
    private RemoteConfig remoteConfig;
    private ReportConfig reportConfig;
    private boolean suppressJMeterOutput;
    private boolean useOldTestEndDetection;
    private MavenProject mavenProject;
    private List<Artifact> pluginArtifacts;
    private File workDir;
    private File binDir;
    private File libExt;
    private File logsDir;
    private String jmeterConfigArtifact = "ApacheJMeter_config";
    private JMeterArgumentsArray testArgs;
    private PropertyHandler pluginProperties;
    private int jmeterExitCheckPause = 2500;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" P E R F O R M A N C E    T E S T S");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" ");
        this.generateJMeterDirectoryTree();
        this.propertyConfiguration();
        this.setJMeterClasspath();
        this.initialiseJMeterArgumentsArray();
        TestManager jMeterTestManager = new TestManager(this.testArgs, this.logsDir, this.testFilesDirectory, this.testFilesIncluded, this.testFilesExcluded, this.suppressJMeterOutput);
        jMeterTestManager.setRemoteConfig(this.remoteConfig);
        try {
            this.jmeterExitCheckPause = Integer.parseInt(this.pluginProperties.getPropertyObject(JMeterPropertiesFiles.JMETER_PROPERTIES).getProperty("jmeter.exit.check.pause"));
        }
        catch (Exception ex) {
            this.getLog().warn((CharSequence)("Unable to parse the 'jmeter.exit.check.pause' entry in jmeter.properties!  Falling back to a default value of '" + this.jmeterExitCheckPause + "'."));
        }
        jMeterTestManager.setExitCheckPause(this.jmeterExitCheckPause);
        jMeterTestManager.setTestEndDetection(this.useOldTestEndDetection);
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)this.proxyConfig.toString());
        List<String> testResults = jMeterTestManager.executeTests();
        new ReportGenerator(this.reportConfig).makeReport(testResults);
        this.checkForErrors(testResults);
    }

    private void generateJMeterDirectoryTree() {
        this.workDir = new File(this.mavenProject.getBasedir() + File.separator + "target" + File.separator + "jmeter");
        this.workDir.mkdirs();
        this.logsDir = new File(this.workDir + File.separator + "jmeter-logs");
        this.logsDir.mkdirs();
        this.binDir = new File(this.workDir + File.separator + "bin");
        this.binDir.mkdirs();
        this.libExt = new File(this.workDir + File.separator + "lib" + File.separator + "ext");
        this.libExt.mkdirs();
        File reportDir = new File(this.workDir + File.separator + "report");
        reportDir.mkdirs();
        this.reportConfig.setOutputDirectory(reportDir);
        new File(this.workDir + File.separator + "lib" + File.separator + "junit").mkdirs();
        System.setProperty("user.dir", this.binDir.getAbsolutePath());
    }

    private void propertyConfiguration() throws MojoExecutionException {
        this.pluginProperties = new PropertyHandler(this.testFilesDirectory, this.binDir, this.getArtifactNamed(this.jmeterConfigArtifact), this.propertiesReplacedByCustomFiles);
        this.pluginProperties.setJMeterProperties(this.propertiesJMeter);
        this.pluginProperties.setJMeterGlobalProperties(this.propertiesGlobal);
        this.pluginProperties.setJMeterSaveServiceProperties(this.propertiesSaveService);
        this.pluginProperties.setJMeterUpgradeProperties(this.propertiesUpgrade);
        this.pluginProperties.setJmeterUserProperties(this.propertiesUser);
        this.pluginProperties.setJMeterSystemProperties(this.propertiesSystem);
        this.pluginProperties.configureJMeterPropertiesFiles();
    }

    private void setJMeterClasspath() throws MojoExecutionException {
        ArrayList<String> classPath = new ArrayList<String>();
        for (Artifact artifact : this.pluginArtifacts) {
            try {
                if (artifact.getArtifactId().startsWith("ApacheJMeter_")) {
                    FileUtils.copyFile((File)artifact.getFile(), (File)new File(this.libExt + File.separator + artifact.getFile().getName()));
                }
                classPath.add(artifact.getFile().getCanonicalPath());
            }
            catch (IOException mx) {
                throw new MojoExecutionException("Unable to get the canonical path for " + artifact);
            }
        }
        System.setProperty("java.class.path", StringUtils.join(classPath.iterator(), (String)File.pathSeparator));
    }

    private Artifact getArtifactNamed(String artifactName) throws MojoExecutionException {
        for (Artifact artifact : this.pluginArtifacts) {
            if (!artifact.getArtifactId().equals(artifactName)) continue;
            return artifact;
        }
        throw new MojoExecutionException("Unable to find artifact '" + artifactName + "'!");
    }

    private void initialiseJMeterArgumentsArray() throws MojoExecutionException {
        this.testArgs = new JMeterArgumentsArray(this.reportConfig.getOutputDirectory().getAbsolutePath());
        this.testArgs.setResultsTimestamp(this.testResultsTimestamp);
        this.testArgs.setJMeterHome(this.workDir.getAbsolutePath());
        this.testArgs.setProxyConfig(this.proxyConfig);
    }

    private void checkForErrors(List<String> results) throws MojoExecutionException, MojoFailureException {
        ErrorScanner scanner = new ErrorScanner(this.ignoreResultErrors, this.ignoreResultFailures);
        int totalErrorCount = 0;
        int totalFailureCount = 0;
        boolean failed = false;
        try {
            for (String file : results) {
                if (scanner.hasTestPassed(new File(file))) continue;
                totalErrorCount = scanner.getErrorCount();
                totalFailureCount = scanner.getFailureCount();
                failed = true;
            }
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)"Test Results:");
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)("Tests Run: " + results.size() + ", Failures: " + totalFailureCount + ", Errors: " + totalErrorCount + ""));
            this.getLog().info((CharSequence)" ");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't read log file", (Exception)e);
        }
        if (failed) {
            if (totalErrorCount == 0) {
                throw new MojoFailureException("There were test failures.  See the jmeter logs for details.");
            }
            if (totalFailureCount == 0) {
                throw new MojoFailureException("There were test errors.  See the jmeter logs for details.");
            }
            throw new MojoFailureException("There were test errors and failures.  See the jmeter logs for details.");
        }
    }
}

