/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.configuration;

import com.lazerycode.jmeter.UtilityFunctions;
import com.lazerycode.jmeter.configuration.JMeterCommandLineArguments;
import com.lazerycode.jmeter.configuration.ProxyConfig;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;

public class JMeterArgumentsArray {
    private LinkedHashMap<JMeterCommandLineArguments, Boolean> argumentMap = new LinkedHashMap();
    private DateFormat fmt = new SimpleDateFormat("yyMMdd");
    private boolean timestampResults = true;
    private String remoteStartList = null;
    private String nonProxyHosts = null;
    private String proxyHost = null;
    private String proxyPort = null;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String customPropertiesFile = null;
    private String jMeterGlobalPropertiesFile = null;
    private String testFile = null;
    private String resultsFileName = null;
    private String jMeterHome = null;
    private String reportDirectory = null;
    private String overrideRootLogLevel = null;
    private String systemPropertiesFile = null;
    private Map<String, String> jMeterUserProperties = null;
    private Map<String, String> jMeterGlobalProperties = null;
    private Map<String, String> systemProperties = null;
    private Map<String, String> overrideLogCategories = null;

    public JMeterArgumentsArray(String reportDirectory) {
        this.reportDirectory = reportDirectory;
        this.argumentMap.put(JMeterCommandLineArguments.NONGUI_OPT, true);
        this.argumentMap.put(JMeterCommandLineArguments.TESTFILE_OPT, false);
        this.argumentMap.put(JMeterCommandLineArguments.LOGFILE_OPT, false);
        this.argumentMap.put(JMeterCommandLineArguments.JMETER_HOME_OPT, false);
        this.argumentMap.put(JMeterCommandLineArguments.SYSTEM_PROPFILE, false);
        this.argumentMap.put(JMeterCommandLineArguments.SYSTEM_PROPERTY, false);
        this.argumentMap.put(JMeterCommandLineArguments.JMETER_PROPERTY, false);
        this.argumentMap.put(JMeterCommandLineArguments.JMETER_GLOBAL_PROP, false);
        this.argumentMap.put(JMeterCommandLineArguments.LOGLEVEL, false);
        this.argumentMap.put(JMeterCommandLineArguments.PROPFILE2_OPT, false);
        this.argumentMap.put(JMeterCommandLineArguments.REMOTE_OPT, false);
        this.argumentMap.put(JMeterCommandLineArguments.PROXY_HOST, false);
        this.argumentMap.put(JMeterCommandLineArguments.PROXY_PORT, false);
        this.argumentMap.put(JMeterCommandLineArguments.PROXY_USERNAME, false);
        this.argumentMap.put(JMeterCommandLineArguments.PROXY_PASSWORD, false);
        this.argumentMap.put(JMeterCommandLineArguments.NONPROXY_HOSTS, false);
        this.argumentMap.put(JMeterCommandLineArguments.REMOTE_STOP, false);
        this.argumentMap.put(JMeterCommandLineArguments.REMOTE_OPT_PARAM, false);
    }

    public void setRemoteStop(boolean value) {
        this.argumentMap.put(JMeterCommandLineArguments.REMOTE_STOP, value);
    }

    public void setRemoteStartAll(boolean value) {
        this.argumentMap.put(JMeterCommandLineArguments.REMOTE_OPT, value);
    }

    public void setRemoteStart(String value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.remoteStartList = value;
        this.argumentMap.put(JMeterCommandLineArguments.REMOTE_OPT_PARAM, true);
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.setProxyHostDetails(proxyConfig.getHost(), proxyConfig.getPort());
        this.setProxyUsername(proxyConfig.getUsername());
        this.setProxyPassword(proxyConfig.getPassword());
        this.setNonProxyHosts(proxyConfig.getHostExclusions());
    }

    private void setProxyHostDetails(String value, int port) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.proxyHost = value;
        this.proxyPort = Integer.toString(port);
        this.argumentMap.put(JMeterCommandLineArguments.PROXY_HOST, true);
        this.argumentMap.put(JMeterCommandLineArguments.PROXY_PORT, true);
    }

    private void setProxyUsername(String value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.proxyUsername = value;
        this.argumentMap.put(JMeterCommandLineArguments.PROXY_USERNAME, true);
    }

    private void setProxyPassword(String value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.proxyPassword = value;
        this.argumentMap.put(JMeterCommandLineArguments.PROXY_PASSWORD, true);
    }

    private void setNonProxyHosts(String value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.nonProxyHosts = value;
        this.argumentMap.put(JMeterCommandLineArguments.NONPROXY_HOSTS, true);
    }

    public void setACustomPropertiesFile(File value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.customPropertiesFile = value.getAbsolutePath();
        this.argumentMap.put(JMeterCommandLineArguments.PROPFILE2_OPT, true);
    }

    @Deprecated
    public void setASystemPropertiesFile(File value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.systemPropertiesFile = value.getAbsolutePath();
        this.argumentMap.put(JMeterCommandLineArguments.SYSTEM_PROPFILE, true);
    }

    @Deprecated
    public void setUserProperties(Map<String, String> value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.jMeterUserProperties = value;
        this.argumentMap.put(JMeterCommandLineArguments.JMETER_PROPERTY, true);
    }

    @Deprecated
    public void setGlobalProperties(Map<String, String> value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.jMeterGlobalProperties = value;
        this.jMeterUserProperties = value;
        this.argumentMap.put(JMeterCommandLineArguments.JMETER_GLOBAL_PROP, true);
        this.argumentMap.put(JMeterCommandLineArguments.JMETER_PROPERTY, true);
    }

    @Deprecated
    public void setRemoteProperties(Map<String, String> value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.jMeterGlobalProperties = value;
        this.argumentMap.put(JMeterCommandLineArguments.JMETER_GLOBAL_PROP, true);
    }

    @Deprecated
    public void setRemotePropertiesFile(File value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.jMeterGlobalPropertiesFile = value.getAbsolutePath();
        this.argumentMap.put(JMeterCommandLineArguments.JMETER_GLOBAL_PROP, true);
    }

    public void setLogCategoriesOverrides(Map<String, String> value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.overrideLogCategories = value;
        this.argumentMap.put(JMeterCommandLineArguments.LOGLEVEL, true);
    }

    public void setLogRootOverride(String value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.overrideRootLogLevel = value;
        this.argumentMap.put(JMeterCommandLineArguments.LOGLEVEL, true);
    }

    @Deprecated
    public void setSystemProperties(Map<String, String> value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.systemProperties = value;
        this.argumentMap.put(JMeterCommandLineArguments.SYSTEM_PROPERTY, true);
    }

    public void setTestFile(File value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.testFile = value.getAbsolutePath();
        this.argumentMap.put(JMeterCommandLineArguments.TESTFILE_OPT, true);
        this.resultsFileName = this.timestampResults ? this.reportDirectory + File.separator + value.getName().substring(0, value.getName().lastIndexOf(".")) + "-" + this.fmt.format(new Date()) + ".jtl" : this.reportDirectory + File.separator + value.getName().substring(0, value.getName().lastIndexOf(".")) + ".jtl";
        this.argumentMap.put(JMeterCommandLineArguments.LOGFILE_OPT, true);
    }

    public void setJMeterHome(String value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.jMeterHome = value;
        this.argumentMap.put(JMeterCommandLineArguments.JMETER_HOME_OPT, true);
    }

    public void setResultsTimestamp(boolean value) {
        this.timestampResults = value;
    }

    public String getResultsFileName() {
        return this.resultsFileName;
    }

    public String[] buildArgumentsArray() throws MojoExecutionException {
        if (!this.argumentMap.get((Object)JMeterCommandLineArguments.TESTFILE_OPT).booleanValue()) {
            throw new MojoExecutionException("No test specified!");
        }
        if (!this.argumentMap.get((Object)JMeterCommandLineArguments.LOGFILE_OPT).booleanValue()) {
            throw new MojoExecutionException("Log file not set!");
        }
        if (!this.argumentMap.get((Object)JMeterCommandLineArguments.JMETER_HOME_OPT).booleanValue()) {
            throw new MojoExecutionException("JMETER_HOME not set!");
        }
        ArrayList<String> argumentsArray = new ArrayList<String>();
        block20: for (Map.Entry<JMeterCommandLineArguments, Boolean> argument : this.argumentMap.entrySet()) {
            if (!argument.getValue().booleanValue()) continue;
            switch (argument.getKey()) {
                case NONGUI_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.NONGUI_OPT.getCommandLineArgument());
                    break;
                }
                case TESTFILE_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.TESTFILE_OPT.getCommandLineArgument());
                    argumentsArray.add(this.testFile);
                    break;
                }
                case LOGFILE_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.LOGFILE_OPT.getCommandLineArgument());
                    argumentsArray.add(this.resultsFileName);
                    break;
                }
                case JMETER_HOME_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.JMETER_HOME_OPT.getCommandLineArgument());
                    argumentsArray.add(this.jMeterHome);
                    break;
                }
                case JMETER_PROPERTY: {
                    Set<String> userPropertySet = this.jMeterUserProperties.keySet();
                    for (String property : userPropertySet) {
                        argumentsArray.add(JMeterCommandLineArguments.JMETER_PROPERTY.getCommandLineArgument());
                        argumentsArray.add(property + "=" + this.jMeterUserProperties.get(property));
                    }
                    continue block20;
                }
                case JMETER_GLOBAL_PROP: {
                    if (this.jMeterGlobalPropertiesFile == null) {
                        Set<String> globalPropertySet = this.jMeterGlobalProperties.keySet();
                        for (String property : globalPropertySet) {
                            argumentsArray.add(JMeterCommandLineArguments.JMETER_GLOBAL_PROP.getCommandLineArgument());
                            argumentsArray.add(property + "=" + this.jMeterGlobalProperties.get(property));
                        }
                        continue block20;
                    }
                    argumentsArray.add(JMeterCommandLineArguments.JMETER_GLOBAL_PROP.getCommandLineArgument());
                    argumentsArray.add(this.jMeterGlobalPropertiesFile);
                    break;
                }
                case LOGLEVEL: {
                    if (this.overrideRootLogLevel == null) {
                        Set<String> logCategorySet = this.overrideLogCategories.keySet();
                        for (String category : logCategorySet) {
                            argumentsArray.add(JMeterCommandLineArguments.LOGLEVEL.getCommandLineArgument());
                            argumentsArray.add(category + "=" + this.overrideLogCategories.get(category));
                        }
                        continue block20;
                    }
                    argumentsArray.add(JMeterCommandLineArguments.LOGLEVEL.getCommandLineArgument());
                    argumentsArray.add(this.overrideRootLogLevel);
                    break;
                }
                case SYSTEM_PROPERTY: {
                    Set<String> systemPropertySet = this.systemProperties.keySet();
                    for (String property : systemPropertySet) {
                        argumentsArray.add(JMeterCommandLineArguments.SYSTEM_PROPERTY.getCommandLineArgument());
                        argumentsArray.add(property + "=" + this.systemProperties.get(property));
                    }
                    continue block20;
                }
                case SYSTEM_PROPFILE: {
                    argumentsArray.add(JMeterCommandLineArguments.SYSTEM_PROPFILE.getCommandLineArgument());
                    argumentsArray.add(this.systemPropertiesFile);
                    break;
                }
                case PROPFILE2_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.PROPFILE2_OPT.getCommandLineArgument());
                    argumentsArray.add(this.customPropertiesFile);
                    break;
                }
                case REMOTE_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.REMOTE_OPT.getCommandLineArgument());
                    break;
                }
                case PROXY_HOST: {
                    argumentsArray.add(JMeterCommandLineArguments.PROXY_HOST.getCommandLineArgument());
                    argumentsArray.add(this.proxyHost);
                    break;
                }
                case PROXY_PORT: {
                    argumentsArray.add(JMeterCommandLineArguments.PROXY_PORT.getCommandLineArgument());
                    argumentsArray.add(this.proxyPort);
                    break;
                }
                case PROXY_USERNAME: {
                    argumentsArray.add(JMeterCommandLineArguments.PROXY_USERNAME.getCommandLineArgument());
                    argumentsArray.add(this.proxyUsername);
                    break;
                }
                case PROXY_PASSWORD: {
                    argumentsArray.add(JMeterCommandLineArguments.PROXY_PASSWORD.getCommandLineArgument());
                    argumentsArray.add(this.proxyPassword);
                    break;
                }
                case NONPROXY_HOSTS: {
                    argumentsArray.add(JMeterCommandLineArguments.NONPROXY_HOSTS.getCommandLineArgument());
                    argumentsArray.add(this.nonProxyHosts);
                    break;
                }
                case REMOTE_STOP: {
                    argumentsArray.add(JMeterCommandLineArguments.REMOTE_STOP.getCommandLineArgument());
                    break;
                }
                case REMOTE_OPT_PARAM: {
                    argumentsArray.add(JMeterCommandLineArguments.REMOTE_OPT_PARAM.getCommandLineArgument());
                    argumentsArray.add(this.remoteStartList);
                }
            }
        }
        return argumentsArray.toArray(new String[argumentsArray.size()]);
    }
}

