/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.properties;

import com.lazerycode.jmeter.JMeterMojo;
import com.lazerycode.jmeter.properties.ReservedProperties;
import java.util.Map;
import java.util.Properties;

public class PropertyFileMerger
extends JMeterMojo {
    public Properties mergePropertiesFiles(Properties source, Properties additions) {
        if (source == null && additions == null) {
            return new Properties();
        }
        if (source == null) {
            return this.stripReservedProperties(additions);
        }
        if (additions == null) {
            return this.stripReservedProperties(source);
        }
        Properties merged = source;
        merged.putAll((Map<?, ?>)additions);
        return this.stripReservedProperties(merged);
    }

    public Properties mergeProperties(Map<String, String> customProperties, Properties baseProperties) {
        if (customProperties != null && !customProperties.isEmpty()) {
            for (String key : customProperties.keySet()) {
                baseProperties.setProperty(key, customProperties.get(key));
                this.warnUserOfPossibleErrors(key, baseProperties);
            }
        }
        baseProperties = this.stripReservedProperties(baseProperties);
        return baseProperties;
    }

    private Properties stripReservedProperties(Properties propertyFile) {
        for (ReservedProperties reservedProperty : ReservedProperties.values()) {
            if (!propertyFile.containsKey(reservedProperty.getPropertyKey())) continue;
            propertyFile.remove(reservedProperty.getPropertyKey());
            this.getLog().warn((CharSequence)("Unable to set '" + reservedProperty.getPropertyKey() + "', it is a reserved property in the jmeter-maven-plugin"));
        }
        return propertyFile;
    }

    private void warnUserOfPossibleErrors(String value, Properties baseProperties) {
        for (String key : baseProperties.stringPropertyNames()) {
            if (key.equals(value) || !key.toLowerCase().equals(value.toLowerCase())) continue;
            this.getLog().warn((CharSequence)("You have set a property called '" + value + "' which is very similar to '" + key + "'!"));
        }
    }
}

