/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.properties;

import com.lazerycode.jmeter.JMeterMojo;
import com.lazerycode.jmeter.UtilityFunctions;
import com.lazerycode.jmeter.properties.JMeterPropertiesFiles;
import com.lazerycode.jmeter.properties.PropertyContainer;
import com.lazerycode.jmeter.properties.PropertyFileMerger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;

public class PropertyHandler
extends JMeterMojo {
    private static EnumMap<JMeterPropertiesFiles, PropertyContainer> masterPropertiesMap = new EnumMap(JMeterPropertiesFiles.class);
    private File propertySourceDirectory;
    private File propertyOutputDirectory;
    private boolean replaceDefaultProperties;

    public PropertyHandler(File sourceDirectory, File outputDirectory, Artifact jMeterConfigArtifact, boolean replaceDefaultProperties) throws MojoExecutionException {
        for (JMeterPropertiesFiles propertyFile : JMeterPropertiesFiles.values()) {
            masterPropertiesMap.put(propertyFile, new PropertyContainer());
        }
        this.setSourceDirectory(sourceDirectory);
        this.setOutputDirectory(outputDirectory);
        this.replaceDefaultProperties = replaceDefaultProperties;
        try {
            this.loadDefaultProperties(jMeterConfigArtifact);
            this.loadCustomProperties();
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)("Error loading properties: " + ex));
        }
    }

    private void loadDefaultProperties(Artifact jMeterConfigArtifact) throws IOException {
        for (JMeterPropertiesFiles propertyFile : JMeterPropertiesFiles.values()) {
            if (propertyFile.createFileIfItDoesntExist()) {
                JarFile propertyJar = new JarFile(jMeterConfigArtifact.getFile());
                InputStream sourceFile = propertyJar.getInputStream(propertyJar.getEntry("bin/" + propertyFile.getPropertiesFileName()));
                Properties defaultPropertySet = new Properties();
                defaultPropertySet.load(sourceFile);
                sourceFile.close();
                this.getPropertyObject(propertyFile).setDefaultPropertyObject(defaultPropertySet);
                continue;
            }
            this.getPropertyObject(propertyFile).setDefaultPropertyObject(new Properties());
        }
    }

    private void loadCustomProperties() throws IOException {
        for (JMeterPropertiesFiles propertyFile : JMeterPropertiesFiles.values()) {
            File sourceFile = new File(this.propertySourceDirectory.getCanonicalFile() + File.separator + propertyFile.getPropertiesFileName());
            if (!sourceFile.exists()) continue;
            FileInputStream sourceInputStream = new FileInputStream(sourceFile);
            Properties sourcePropertySet = new Properties();
            sourcePropertySet.load(sourceInputStream);
            ((InputStream)sourceInputStream).close();
            this.getPropertyObject(propertyFile).setCustomPropertyObject(sourcePropertySet);
        }
    }

    private void setSourceDirectory(File value) throws MojoExecutionException {
        if (!value.exists()) {
            throw new MojoExecutionException("Property source directory '" + value.getAbsolutePath() + "' does not exist!");
        }
        this.propertySourceDirectory = value;
    }

    private void setOutputDirectory(File value) throws MojoExecutionException {
        if (!value.exists() && !value.mkdirs()) {
            throw new MojoExecutionException("Property output directory '" + value.getAbsolutePath() + "' cannot be created!");
        }
        this.propertyOutputDirectory = value;
    }

    public void setJMeterProperties(Map<String, String> value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.getPropertyObject(JMeterPropertiesFiles.JMETER_PROPERTIES).setCustomPropertyMap(value);
    }

    public void setJMeterSaveServiceProperties(Map<String, String> value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.getPropertyObject(JMeterPropertiesFiles.SAVE_SERVICE_PROPERTIES).setCustomPropertyMap(value);
    }

    public void setJMeterSystemProperties(Map<String, String> value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.getPropertyObject(JMeterPropertiesFiles.SYSTEM_PROPERTIES).setCustomPropertyMap(value);
    }

    public void setJMeterUpgradeProperties(Map<String, String> value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.getPropertyObject(JMeterPropertiesFiles.UPGRADE_PROPERTIES).setCustomPropertyMap(value);
    }

    public void setJmeterUserProperties(Map<String, String> value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.getPropertyObject(JMeterPropertiesFiles.USER_PROPERTIES).setCustomPropertyMap(value);
    }

    public void setJMeterGlobalProperties(Map<String, String> value) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return;
        }
        this.getPropertyObject(JMeterPropertiesFiles.GLOBAL_PROPERTIES).setCustomPropertyMap(value);
    }

    public PropertyContainer getPropertyObject(JMeterPropertiesFiles value) {
        return masterPropertiesMap.get((Object)value);
    }

    public void configureJMeterPropertiesFiles() throws MojoExecutionException {
        for (JMeterPropertiesFiles propertyFile : JMeterPropertiesFiles.values()) {
            if (this.replaceDefaultProperties) {
                this.getPropertyObject(propertyFile).setFinalPropertyObject(new PropertyFileMerger().mergeProperties(this.getPropertyObject(propertyFile).getCustomPropertyMap(), this.getPropertyObject(propertyFile).getBasePropertiesObject()));
            } else {
                this.getPropertyObject(propertyFile).setFinalPropertyObject(new PropertyFileMerger().mergeProperties(this.getPropertyObject(propertyFile).getCustomPropertyMap(), new PropertyFileMerger().mergePropertiesFiles(this.getPropertyObject(propertyFile).getDefaultPropertyObject(), this.getPropertyObject(propertyFile).getCustomPropertyObject())));
            }
            try {
                FileOutputStream writeOutFinalPropertiesFile = new FileOutputStream(new File(this.propertyOutputDirectory.getCanonicalFile() + File.separator + propertyFile.getPropertiesFileName()));
                this.getPropertyObject(propertyFile).getFinalPropertyObject().store(writeOutFinalPropertiesFile, null);
                writeOutFinalPropertiesFile.flush();
                writeOutFinalPropertiesFile.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating consolidated properties file " + propertyFile.getPropertiesFileName() + ": " + e);
            }
        }
    }
}

