/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.reporting;

import com.lazerycode.jmeter.JMeterMojo;
import com.lazerycode.jmeter.configuration.ReportConfig;
import com.lazerycode.jmeter.reporting.ReportTransformer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class ReportGenerator
extends JMeterMojo {
    private ReportConfig reportConfig;

    public ReportGenerator(ReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    public void makeReport(List<String> resultFiles) throws MojoExecutionException {
        if (this.reportConfig.isEnable()) {
            try {
                ReportTransformer transformer = new ReportTransformer(this.getXslt());
                this.getLog().info((CharSequence)" ");
                this.getLog().info((CharSequence)"Building JMeter Report(s)...");
                for (String resultFile : resultFiles) {
                    String outputFile = this.toOutputFileName(resultFile);
                    transformer.transform(resultFile, outputFile);
                    this.getLog().info((CharSequence)" ");
                    this.getLog().info((CharSequence)("Raw results: " + resultFile));
                    this.getLog().info((CharSequence)("Test report: " + outputFile));
                }
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException("Error writing report file jmeter file.", (Exception)e);
            }
            catch (TransformerException e) {
                throw new MojoExecutionException("Error transforming jmeter results", (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying resources to jmeter results", (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)"Report generation disabled.");
        }
    }

    private InputStream getXslt() throws IOException {
        if (this.reportConfig.getXsltFile() == null) {
            IOUtils.copy((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("reports/collapse.jpg"), (OutputStream)new FileOutputStream(this.reportConfig.getOutputDirectory().getPath() + File.separator + "collapse.jpg"));
            IOUtils.copy((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("reports/expand.jpg"), (OutputStream)new FileOutputStream(this.reportConfig.getOutputDirectory().getPath() + File.separator + "expand.jpg"));
            return Thread.currentThread().getContextClassLoader().getResourceAsStream("reports/jmeter-results-detail-report_21.xsl");
        }
        return new FileInputStream(this.reportConfig.getXsltFile());
    }

    private String toOutputFileName(String fileName) {
        if (fileName.endsWith(".xml")) {
            return fileName.replace(".xml", this.reportConfig.getPostfix());
        }
        return fileName + this.reportConfig.getPostfix();
    }
}

