/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.testrunner;

import com.lazerycode.jmeter.IncludesComparator;
import com.lazerycode.jmeter.JMeterMojo;
import com.lazerycode.jmeter.UtilityFunctions;
import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.configuration.RemoteConfig;
import com.lazerycode.jmeter.testrunner.ExitException;
import com.lazerycode.jmeter.testrunner.JMeterTestListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.jmeter.JMeter;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.testelement.TestListener;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.DirectoryScanner;

public class TestManager
extends JMeterMojo {
    private JMeterArgumentsArray testArgs;
    private File jmeterLog;
    private File logsDir;
    private File testFilesDirectory;
    private List<String> testFilesIncluded;
    private List<String> testFilesExcluded;
    private boolean suppressJMeterOutput;
    private boolean remoteStop = false;
    private boolean remoteStartAll = false;
    private boolean remoteStartAndStopOnce = true;
    private String remoteStart = null;
    private int exitCheckPause = 7500;
    private boolean useOldTestEndDetection = false;
    private JMeterTestListener testListener = new JMeterTestListener();

    public TestManager(JMeterArgumentsArray testArgs, File logsDir, File testFilesDirectory, List<String> testFiles, List<String> excludeTestFiles, boolean suppressJMeterOutput) {
        this.testArgs = testArgs;
        this.logsDir = logsDir;
        this.testFilesDirectory = testFilesDirectory;
        this.testFilesIncluded = testFiles;
        this.testFilesExcluded = excludeTestFiles;
        this.suppressJMeterOutput = suppressJMeterOutput;
    }

    public void setExitCheckPause(int value) {
        this.exitCheckPause = value + 5000;
    }

    public void setTestEndDetection(boolean value) {
        this.useOldTestEndDetection = value;
    }

    public void setRemoteConfig(RemoteConfig remoteConfig) {
        this.remoteStop = remoteConfig.isStop();
        this.remoteStartAll = remoteConfig.isStartAll();
        this.remoteStartAndStopOnce = remoteConfig.isStartAndStopOnce();
        if (!UtilityFunctions.isNotSet(remoteConfig.getStart()).booleanValue()) {
            this.remoteStart = remoteConfig.getStart();
        }
    }

    public List<String> executeTests() throws MojoExecutionException {
        List<String> tests = this.generateTestList();
        ArrayList<String> results = new ArrayList<String>();
        for (String file : tests) {
            if (!this.remoteStartAndStopOnce || tests.get(tests.size() - 1).equals(file)) {
                this.testArgs.setRemoteStop(this.remoteStop);
            }
            if (!this.remoteStartAndStopOnce || tests.get(0).equals(file)) {
                this.testArgs.setRemoteStartAll(this.remoteStartAll);
                this.testArgs.setRemoteStart(this.remoteStart);
            }
            results.add(this.executeSingleTest(new File(this.testFilesDirectory, file)));
        }
        return results;
    }

    private SecurityManager overrideSecurityManager() {
        SecurityManager oldManager = System.getSecurityManager();
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkExit(int status) {
                throw new ExitException(status);
            }

            @Override
            public void checkPermission(Permission perm, Object context) {
            }

            @Override
            public void checkPermission(Permission perm) {
            }
        });
        return oldManager;
    }

    private Thread.UncaughtExceptionHandler overrideUncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e instanceof ExitException && ((ExitException)e).getCode() == 0) {
                    return;
                }
                TestManager.this.getLog().error((CharSequence)("Error in thread " + t.getName()));
            }
        });
        return oldHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeSingleTest(File test) throws MojoExecutionException {
        try {
            block19: {
                this.getLog().info((CharSequence)" ");
                this.testArgs.setTestFile(test);
                new File(this.testArgs.getResultsFileName()).delete();
                this.getLog().debug((CharSequence)("JMeter is called with the following command line arguments: " + UtilityFunctions.humanReadableCommandLineOutput(this.testArgs.buildArgumentsArray())));
                SecurityManager oldSecurityManager = this.overrideSecurityManager();
                Thread.UncaughtExceptionHandler oldExceptionHandler = this.overrideUncaughtExceptionHandler();
                PrintStream originalOut = System.out;
                this.setJMeterLogFile(test.getName() + ".log");
                this.getLog().info((CharSequence)("Executing test: " + test.getName()));
                try {
                    if (this.suppressJMeterOutput) {
                        System.setOut(new PrintStream((OutputStream)new NullOutputStream()));
                    }
                    new StandardJMeterEngine();
                    StandardJMeterEngine.register((TestListener)this.testListener);
                    new JMeter().start(this.testArgs.buildArgumentsArray());
                    if (this.useOldTestEndDetection) {
                        while (!this.checkForEndOfTest(new BufferedReader(new FileReader(this.jmeterLog)))) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                break block19;
                            }
                        }
                        break block19;
                    }
                    this.waitForTestToFinish();
                }
                catch (ExitException e) {
                    if (e.getCode() != 0) {
                        throw new MojoExecutionException("Test failed", (Exception)e);
                    }
                }
                finally {
                    try {
                        Thread.sleep(this.exitCheckPause);
                    }
                    catch (InterruptedException e) {
                        this.getLog().warn((CharSequence)"Something went wrong during Thread cleanup, we may be leaving something running...");
                    }
                    System.setSecurityManager(oldSecurityManager);
                    Thread.setDefaultUncaughtExceptionHandler(oldExceptionHandler);
                    System.setOut(originalOut);
                    this.getLog().info((CharSequence)("Completed Test: " + test.getName()));
                }
            }
            return this.testArgs.getResultsFileName();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't execute test", (Exception)e);
        }
    }

    private void waitForTestToFinish() {
        while (this.testListener.isTestStillRunning()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    @Deprecated
    private boolean checkForEndOfTest(BufferedReader in) throws MojoExecutionException {
        boolean testEnded = false;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (!line.contains("Test has ended") && !line.contains("Interrupting RMI Reaper")) continue;
                testEnded = true;
                break;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't read log file", (Exception)e);
        }
        return testEnded;
    }

    private void setJMeterLogFile(String value) {
        this.jmeterLog = new File(this.logsDir + File.separator + value);
        System.setProperty("log_file", this.jmeterLog.getAbsolutePath());
    }

    private List<String> generateTestList() {
        String[] stringArray;
        ArrayList<String> jmeterTestFiles = new ArrayList<String>();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.testFilesDirectory);
        if (this.testFilesIncluded == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "**/*.jmx";
        } else {
            stringArray = this.testFilesIncluded.toArray(new String[jmeterTestFiles.size()]);
        }
        scanner.setIncludes(stringArray);
        if (this.testFilesExcluded != null) {
            scanner.setExcludes(this.testFilesExcluded.toArray(new String[this.testFilesExcluded.size()]));
        }
        scanner.scan();
        List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
        Collections.sort(includedFiles, new IncludesComparator(this.testFilesIncluded));
        jmeterTestFiles.addAll(includedFiles);
        return jmeterTestFiles;
    }
}

