/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.json.TestConfig;
import com.lazerycode.jmeter.mojo.AbstractJMeterMojo;
import com.lazerycode.jmeter.testrunner.ResultScanner;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="results", defaultPhase=LifecyclePhase.VERIFY)
public class CheckResultsMojo
extends AbstractJMeterMojo {
    @Parameter(defaultValue="false")
    protected boolean ignoreResultFailures;
    @Parameter(defaultValue="false")
    protected boolean scanResultsForFailedRequests;
    @Parameter(defaultValue="false")
    protected boolean scanResultsForSuccessfulRequests;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.scanResultsForSuccessfulRequests || this.scanResultsForFailedRequests) {
            ResultScanner resultScanner = new ResultScanner(this.scanResultsForSuccessfulRequests, this.scanResultsForFailedRequests);
            TestConfig testConfig = new TestConfig(new File(this.testConfigFile));
            for (String resultFileLocation : testConfig.getResultsFileLocations()) {
                resultScanner.parseResultFile(new File(resultFileLocation));
            }
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)"Performance Test Results");
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)("Result (.jtl) files scanned:\t" + testConfig.getResultsFileLocations().size()));
            this.getLog().info((CharSequence)("Successful requests: \t\t" + resultScanner.getSuccessCount()));
            this.getLog().info((CharSequence)("Failed requests: \t\t\t" + resultScanner.getFailureCount()));
            this.getLog().info((CharSequence)" ");
            if (!this.ignoreResultFailures && resultScanner.getFailureCount() > 0) {
                throw new MojoFailureException("Failing build because failed requests have been detected.  JMeter logs are available at: '" + this.logsDirectory.getAbsolutePath() + "'");
            }
        } else {
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)"Results of Performance Test(s) have not been scanned.");
            this.getLog().info((CharSequence)" ");
        }
    }
}

