/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.exceptions.DependencyResolutionException;
import com.lazerycode.jmeter.json.TestConfig;
import com.lazerycode.jmeter.mojo.AbstractJMeterMojo;
import com.lazerycode.jmeter.properties.ConfigurationFiles;
import com.lazerycode.jmeter.properties.PropertiesFile;
import com.lazerycode.jmeter.properties.PropertiesMapping;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

@Mojo(name="configure", defaultPhase=LifecyclePhase.COMPILE)
public class ConfigureJMeterMojo
extends AbstractJMeterMojo {
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> repositoryList;
    private final String baseConfigFile = "/config.json";
    @Parameter(defaultValue="3.2")
    private String jmeterVersion;
    @Parameter
    private List<String> jmeterArtifacts = new ArrayList<String>();
    @Parameter
    private List<String> ignoredArtifacts = new ArrayList<String>();
    @Parameter(defaultValue="true")
    protected boolean downloadExtensionDependencies;
    @Parameter
    protected List<String> jmeterExtensions = new ArrayList<String>();
    @Parameter(defaultValue="false")
    protected boolean downloadJMeterDependencies;
    @Parameter(defaultValue="false")
    protected boolean downloadOptionalDependencies;
    @Parameter(defaultValue="true")
    protected boolean downloadLibraryDependencies;
    @Parameter
    protected List<String> junitLibraries = new ArrayList<String>();
    @Parameter
    protected Map<String, String> propertiesJMeter = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesSaveService = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesReportGenerator = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesUpgrade = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesUser = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesGlobal = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesSystem = new HashMap<String, String>();
    @Parameter(defaultValue="${basedir}/src/test/jmeter")
    protected File propertiesFilesDirectory;
    @Parameter(defaultValue="true")
    protected boolean propertiesReplacedByCustomFiles;
    @Parameter(defaultValue="xml")
    protected String resultsFileFormat;
    protected boolean resultsOutputIsCSVFormat = false;
    public static final String JMETER_CONFIG_ARTIFACT_NAME = "ApacheJMeter_config";
    private static final String JMETER_GROUP_ID = "org.apache.jmeter";
    protected static Artifact jmeterConfigArtifact;
    protected static File customPropertiesDirectory;
    protected static File libDirectory;
    protected static File libExtDirectory;
    protected static File libJUnitDirectory;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" Configuring JMeter...");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.generateJMeterDirectoryTree();
        this.configureJMeterArtifacts();
        this.populateJMeterDirectoryTree();
        this.copyExplicitLibraries(this.jmeterExtensions, libExtDirectory, this.downloadExtensionDependencies);
        this.copyExplicitLibraries(this.junitLibraries, libJUnitDirectory, this.downloadLibraryDependencies);
        this.configurePropertiesFiles();
        this.generateTestConfig();
    }

    protected void generateJMeterDirectoryTree() {
        workingDirectory = new File(this.jmeterDirectory, "bin");
        workingDirectory.mkdirs();
        customPropertiesDirectory = new File(this.jmeterDirectory, "custom_properties");
        customPropertiesDirectory.mkdirs();
        libDirectory = new File(this.jmeterDirectory, "lib");
        libExtDirectory = new File(libDirectory, "ext");
        libExtDirectory.mkdirs();
        libJUnitDirectory = new File(libDirectory, "junit");
        libJUnitDirectory.mkdirs();
        this.testFilesBuildDirectory.mkdirs();
        this.resultsDirectory.mkdirs();
        if (this.generateReports) {
            this.reportDirectory.mkdirs();
        }
        this.logsDirectory.mkdirs();
    }

    protected void configurePropertiesFiles() throws MojoExecutionException, MojoFailureException {
        propertiesMap.put(ConfigurationFiles.JMETER_PROPERTIES, new PropertiesMapping(this.propertiesJMeter));
        propertiesMap.put(ConfigurationFiles.SAVE_SERVICE_PROPERTIES, new PropertiesMapping(this.propertiesSaveService));
        propertiesMap.put(ConfigurationFiles.UPGRADE_PROPERTIES, new PropertiesMapping(this.propertiesUpgrade));
        propertiesMap.put(ConfigurationFiles.SYSTEM_PROPERTIES, new PropertiesMapping(this.propertiesSystem));
        propertiesMap.put(ConfigurationFiles.REPORT_GENERATOR_PROPERTIES, new PropertiesMapping(this.propertiesReportGenerator));
        propertiesMap.put(ConfigurationFiles.USER_PROPERTIES, new PropertiesMapping(this.propertiesUser));
        propertiesMap.put(ConfigurationFiles.GLOBAL_PROPERTIES, new PropertiesMapping(this.propertiesGlobal));
        this.setJMeterResultFileFormat();
        for (ConfigurationFiles configurationFile : ConfigurationFiles.values()) {
            File suppliedPropertiesFile = new File(this.propertiesFilesDirectory, configurationFile.getFilename());
            File propertiesFileToWrite = new File(workingDirectory, configurationFile.getFilename());
            PropertiesFile somePropertiesFile = new PropertiesFile(jmeterConfigArtifact, configurationFile);
            somePropertiesFile.loadProvidedPropertiesIfAvailable(suppliedPropertiesFile, this.propertiesReplacedByCustomFiles);
            somePropertiesFile.addAndOverwriteProperties(((PropertiesMapping)propertiesMap.get((Object)configurationFile)).getAdditionalProperties());
            somePropertiesFile.writePropertiesToFile(propertiesFileToWrite);
            ((PropertiesMapping)propertiesMap.get((Object)configurationFile)).setPropertiesFile(somePropertiesFile);
        }
        for (File customPropertiesFile : this.customPropertiesFiles) {
            PropertiesFile customProperties = new PropertiesFile(customPropertiesFile);
            String customPropertiesFilename = FilenameUtils.getBaseName((String)customPropertiesFile.getName()) + "-" + UUID.randomUUID().toString() + FilenameUtils.getExtension((String)customPropertiesFile.getName());
            customProperties.writePropertiesToFile(new File(customPropertiesDirectory, customPropertiesFilename));
        }
        this.setDefaultPluginProperties(workingDirectory.getAbsolutePath());
    }

    protected void generateTestConfig() throws MojoExecutionException {
        InputStream configFile = ((Object)((Object)this)).getClass().getResourceAsStream("/config.json");
        TestConfig testConfig = new TestConfig(configFile);
        testConfig.setResultsOutputIsCSVFormat(this.resultsOutputIsCSVFormat);
        testConfig.writeResultFilesConfigTo(this.testConfigFile);
    }

    protected void setJMeterResultFileFormat() {
        if (this.generateReports || this.resultsFileFormat.toLowerCase().equals("csv")) {
            this.propertiesJMeter.put("jmeter.save.saveservice.output_format", "csv");
            this.resultsOutputIsCSVFormat = true;
        } else {
            this.propertiesJMeter.put("jmeter.save.saveservice.output_format", "xml");
            this.resultsOutputIsCSVFormat = false;
        }
    }

    public void setDefaultPluginProperties(String userDirectory) {
        System.setProperty("user.dir", userDirectory);
        System.setProperty("jmeterengine.remote.system.exit", "false");
        System.setProperty("jmeterengine.stopfail.system.exit", "false");
    }

    private void configureJMeterArtifacts() {
        if (this.jmeterArtifacts.isEmpty()) {
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_components:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_config:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_core:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_ftp:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_functions:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_http:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_java:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_jdbc:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_jms:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_junit:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_ldap:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_mail:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_mongodb:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_native:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_tcp:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:jorphan:" + this.jmeterVersion);
        }
    }

    private void populateJMeterDirectoryTree() throws DependencyResolutionException, com.lazerycode.jmeter.exceptions.IOException {
        if (this.jmeterArtifacts.isEmpty()) {
            throw new DependencyResolutionException("No JMeter dependencies specified!, check jmeterArtifacts and jmeterVersion elements");
        }
        block8: for (String desiredArtifact : this.jmeterArtifacts) {
            Artifact returnedArtifact = this.getArtifactResult((Artifact)new DefaultArtifact(desiredArtifact));
            switch (returnedArtifact.getArtifactId()) {
                case "ApacheJMeter_config": {
                    jmeterConfigArtifact = returnedArtifact;
                    this.extractConfigSettings(jmeterConfigArtifact);
                    continue block8;
                }
                case "ApacheJMeter": {
                    runtimeJarName = returnedArtifact.getFile().getName();
                    this.copyArtifact(returnedArtifact, workingDirectory);
                    this.copyTransitiveRuntimeDependenciesToLibDirectory(returnedArtifact, this.downloadJMeterDependencies);
                    continue block8;
                }
            }
            this.copyArtifact(returnedArtifact, libExtDirectory);
            this.copyTransitiveRuntimeDependenciesToLibDirectory(returnedArtifact, this.downloadJMeterDependencies);
        }
        if (this.confFilesDirectory.exists()) {
            ConfigureJMeterMojo.CopyFilesInTestDirectory(this.confFilesDirectory, new File(this.jmeterDirectory, "bin"));
        }
    }

    private void copyExplicitLibraries(List<String> desiredArtifacts, File destination, boolean downloadDependencies) throws DependencyResolutionException, com.lazerycode.jmeter.exceptions.IOException {
        for (String desiredArtifact : desiredArtifacts) {
            Artifact returnedArtifact = this.getArtifactResult((Artifact)new DefaultArtifact(desiredArtifact));
            this.copyArtifact(returnedArtifact, destination);
            if (!downloadDependencies) continue;
            this.copyTransitiveRuntimeDependenciesToLibDirectory(returnedArtifact, true);
        }
    }

    private Artifact getArtifactResult(Artifact desiredArtifact) throws DependencyResolutionException {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(desiredArtifact);
        artifactRequest.setRepositories(this.repositoryList);
        try {
            return this.repositorySystem.resolveArtifact(this.repositorySystemSession, artifactRequest).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new DependencyResolutionException(e.getMessage(), e);
        }
    }

    private void copyTransitiveRuntimeDependenciesToLibDirectory(Artifact artifact, boolean getDependenciesOfDependency) throws DependencyResolutionException, com.lazerycode.jmeter.exceptions.IOException {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, "runtime"));
        collectRequest.setRepositories(this.repositoryList);
        DependencyFilter dependencyFilter = DependencyFilterUtils.classpathFilter((String[])new String[0]);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, dependencyFilter);
        try {
            List artifactDependencyNodes = this.repositorySystem.resolveDependencies(this.repositorySystemSession, dependencyRequest).getRoot().getChildren();
            for (DependencyNode dependencyNode : artifactDependencyNodes) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Dependency name: " + dependencyNode.toString()));
                    this.getLog().debug((CharSequence)("Dependency request trace: " + dependencyRequest.getCollectRequest().getTrace().toString()));
                    this.getLog().debug((CharSequence)"-------------------------------------------------------");
                }
                if (!this.downloadOptionalDependencies && dependencyNode.getDependency().isOptional()) continue;
                Artifact returnedArtifact = this.getArtifactResult(dependencyNode.getArtifact());
                if (!returnedArtifact.getArtifactId().startsWith("ApacheJMeter_")) {
                    this.copyArtifact(returnedArtifact, libDirectory);
                }
                if (!getDependenciesOfDependency) continue;
                this.copyTransitiveRuntimeDependenciesToLibDirectory(returnedArtifact, true);
            }
        }
        catch (org.eclipse.aether.resolution.DependencyResolutionException e) {
            throw new DependencyResolutionException(e.getMessage(), e);
        }
    }

    private void copyArtifact(Artifact artifact, File destinationDirectory) throws com.lazerycode.jmeter.exceptions.IOException, DependencyResolutionException {
        for (String ignoredArtifact : this.ignoredArtifacts) {
            Artifact artifactToIgnore = this.getArtifactResult((Artifact)new DefaultArtifact(ignoredArtifact));
            if (!artifact.getFile().getName().equals(artifactToIgnore.getFile().getName())) continue;
            this.getLog().debug((CharSequence)(artifact.getFile().getName() + " has not been copied over because it is in the ignore list."));
            return;
        }
        try {
            File artifactToCopy = new File(destinationDirectory + File.separator + artifact.getFile().getName());
            this.getLog().debug((CharSequence)("Checking: " + artifactToCopy.getAbsolutePath() + "..."));
            if (!artifactToCopy.exists()) {
                this.getLog().debug((CharSequence)("Copying: " + artifactToCopy.getAbsolutePath() + "..."));
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)destinationDirectory);
            }
        }
        catch (IOException e) {
            throw new com.lazerycode.jmeter.exceptions.IOException(e.getMessage(), e);
        }
    }

    private void extractConfigSettings(Artifact artifact) throws com.lazerycode.jmeter.exceptions.IOException {
        try {
            JarFile configSettings = new JarFile(artifact.getFile());
            Enumeration<JarEntry> entries = configSettings.entries();
            while (entries.hasMoreElements()) {
                File fileToCreate;
                JarEntry jarFileEntry = entries.nextElement();
                if (!jarFileEntry.isDirectory() && jarFileEntry.getName().startsWith("bin") && !jarFileEntry.getName().endsWith(".properties")) {
                    fileToCreate = new File(this.jmeterDirectory, jarFileEntry.getName());
                    FileUtils.copyInputStreamToFile((InputStream)configSettings.getInputStream(jarFileEntry), (File)fileToCreate);
                    continue;
                }
                if (jarFileEntry.isDirectory() || !jarFileEntry.getName().startsWith("bin/report-template")) continue;
                fileToCreate = new File(this.jmeterDirectory, jarFileEntry.getName());
                FileUtils.copyInputStreamToFile((InputStream)configSettings.getInputStream(jarFileEntry), (File)fileToCreate);
            }
            configSettings.close();
        }
        catch (IOException e) {
            throw new com.lazerycode.jmeter.exceptions.IOException(e.getMessage(), e);
        }
    }
}

