/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.json.TestConfig;
import com.lazerycode.jmeter.mojo.AbstractJMeterMojo;
import com.lazerycode.jmeter.testrunner.ResultScanner;
import com.lazerycode.jmeter.testrunner.TestFailureDecider;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="results", defaultPhase=LifecyclePhase.VERIFY)
public class CheckResultsMojo
extends AbstractJMeterMojo {
    @Parameter(defaultValue="false")
    protected boolean ignoreResultFailures;
    @Parameter(defaultValue="true")
    protected boolean scanResultsForFailedRequests;
    @Parameter(defaultValue="0")
    protected float errorRateThresholdInPercent;
    @Parameter(defaultValue="true")
    protected boolean scanResultsForSuccessfulRequests;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.ignoreResultFailures && !this.scanResultsForFailedRequests) {
            this.getLog().warn((CharSequence)("current value of scanResultsForFailedRequests(" + this.scanResultsForFailedRequests + ") is incompatible with ignoreResultFailures(" + this.ignoreResultFailures + ", setting scanResultsForFailedRequests to true"));
            this.scanResultsForFailedRequests = true;
        }
        if (this.scanResultsForSuccessfulRequests || this.scanResultsForFailedRequests) {
            TestConfig testConfig = new TestConfig(new File(this.testConfigFile));
            this.getLog().info((CharSequence)("Will scan results using format:" + testConfig.getFullConfig()));
            ResultScanner resultScanner = new ResultScanner(this.scanResultsForSuccessfulRequests, this.scanResultsForFailedRequests, testConfig.getResultsOutputIsCSVFormat());
            for (String resultFileLocation : testConfig.getResultsFileLocations()) {
                resultScanner.parseResultFile(new File(resultFileLocation));
            }
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)"Performance Test Results");
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)("Result (.jtl) files scanned: " + testConfig.getResultsFileLocations().size()));
            this.getLog().info((CharSequence)("Successful requests:         " + resultScanner.getSuccessCount()));
            this.getLog().info((CharSequence)("Failed requests:             " + resultScanner.getFailureCount()));
            TestFailureDecider decider = new TestFailureDecider(this.ignoreResultFailures, this.errorRateThresholdInPercent, resultScanner);
            decider.runChecks();
            this.getLog().info((CharSequence)("Failures:                    " + decider.getErrorPercentage() + "% (" + decider.getErrorPercentageThreshold() + "% accepted)"));
            if (decider.failBuild()) {
                throw new MojoFailureException("Failing build because error percentage " + decider.getErrorPercentage() + " is above accepted threshold " + decider.getErrorPercentageThreshold() + ". JMeter logs are available at: '" + this.logsDirectory.getAbsolutePath() + "'");
            }
        } else {
            this.getLog().info((CharSequence)"Results of Performance Test(s) have not been scanned.");
        }
    }
}

