/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.exceptions.DependencyResolutionException;
import com.lazerycode.jmeter.exceptions.IOException;
import com.lazerycode.jmeter.json.TestConfig;
import com.lazerycode.jmeter.mojo.AbstractJMeterMojo;
import com.lazerycode.jmeter.mojo.JMeterConfigurationHolder;
import com.lazerycode.jmeter.properties.ConfigurationFiles;
import com.lazerycode.jmeter.properties.PropertiesFile;
import com.lazerycode.jmeter.properties.PropertiesMapping;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;

@Mojo(name="configure", defaultPhase=LifecyclePhase.COMPILE)
public class ConfigureJMeterMojo
extends AbstractJMeterMojo {
    private static final String DEPENDENCIES_DEFAULT_SEARCH_SCOPE = "runtime";
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> repositoryList;
    private static final String ARTIFACT_STAR = "*";
    private static final String BASE_CONFIG_FILE = "/config.json";
    @Parameter(defaultValue="5.0")
    private String jmeterVersion;
    @Parameter
    private List<String> jmeterArtifacts = new ArrayList<String>();
    @Parameter
    private List<String> excludedArtifacts = new ArrayList<String>();
    @Parameter
    private List<String> ignoredArtifacts = new ArrayList<String>();
    @Parameter(defaultValue="true")
    protected boolean downloadExtensionDependencies;
    @Parameter
    protected List<String> jmeterExtensions = new ArrayList<String>();
    @Parameter(defaultValue="false")
    protected boolean downloadJMeterDependencies;
    @Parameter(defaultValue="false")
    protected boolean downloadOptionalDependencies;
    @Parameter(defaultValue="true")
    protected boolean downloadLibraryDependencies;
    @Parameter
    protected List<String> junitLibraries = new ArrayList<String>();
    @Parameter
    protected List<String> testPlanLibraries = new ArrayList<String>();
    @Parameter
    protected Map<String, String> propertiesJMeter = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesSaveService = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesReportGenerator = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesUpgrade = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesUser = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesGlobal = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesSystem = new HashMap<String, String>();
    @Parameter(defaultValue="${basedir}/src/test/jmeter")
    protected File propertiesFilesDirectory;
    @Parameter(defaultValue="true")
    protected boolean propertiesReplacedByCustomFiles;
    private Set<Exclusion> parsedExcludedArtifacts = new HashSet<Exclusion>();
    private Set<Exclusion> processedArtifacts = new HashSet<Exclusion>();
    private Set<Artifact> copiedArtifacts = new HashSet<Artifact>();
    @Parameter(defaultValue="csv")
    protected String resultsFileFormat;
    protected boolean resultsOutputIsCSVFormat = false;
    protected Artifact jmeterConfigArtifact;
    protected File customPropertiesDirectory;
    protected File libDirectory;
    protected File libExtDirectory;
    protected File libJUnitDirectory;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.processedArtifacts.clear();
        this.parsedExcludedArtifacts.clear();
        JMeterConfigurationHolder.getInstance().resetConfiguration();
        this.setupExcludedArtifacts(this.excludedArtifacts);
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" Configuring JMeter...");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" Building JMeter directory structure...");
        this.generateJMeterDirectoryTree();
        this.getLog().info((CharSequence)(" Configuring JMeter artifacts :" + this.jmeterArtifacts));
        this.configureJMeterArtifacts();
        this.getLog().info((CharSequence)" Populating JMeter directory ...");
        this.populateJMeterDirectoryTree();
        this.getLog().info((CharSequence)(" Copying extensions " + this.jmeterExtensions + " to JMeter lib/ext directory " + this.libExtDirectory + " with downloadExtensionDependencies set to " + this.downloadExtensionDependencies + " ..."));
        this.copyExplicitLibraries(this.jmeterExtensions, this.libExtDirectory, this.downloadExtensionDependencies);
        this.getLog().info((CharSequence)(" Copying  JUnit libraries " + this.junitLibraries + " to JMeter junit lib directory " + this.libJUnitDirectory + " with downloadLibraryDependencies set to " + this.downloadLibraryDependencies + " ..."));
        this.copyExplicitLibraries(this.junitLibraries, this.libJUnitDirectory, this.downloadLibraryDependencies);
        this.getLog().info((CharSequence)(" Copying test libraries " + this.testPlanLibraries + " to JMeter lib directory " + this.libDirectory + " with downloadLibraryDependencies set to " + this.downloadLibraryDependencies + " ..."));
        this.copyExplicitLibraries(this.testPlanLibraries, this.libDirectory, this.downloadLibraryDependencies);
        this.getLog().info((CharSequence)" Configuring jmeter properties ...");
        this.configurePropertiesFiles();
        this.getLog().info((CharSequence)" Generating JSON Test config ...");
        this.generateTestConfig();
        JMeterConfigurationHolder.getInstance().freezeConfiguration();
    }

    private void setupExcludedArtifacts(List<String> excludedArtifactsAsString) {
        this.parsedExcludedArtifacts.add(new Exclusion("d-haven-managed-pool", "d-haven-managed-pool", null, null));
        this.parsedExcludedArtifacts.add(new Exclusion("event", "event", null, null));
        this.parsedExcludedArtifacts.add(new Exclusion("commons-pool2", "commons-pool2", null, null));
        this.parsedExcludedArtifacts.add(new Exclusion("commons-math3", "commons-math3", null, null));
        this.parsedExcludedArtifacts.add(new Exclusion("logkit", "logkit", null, null));
        this.parsedExcludedArtifacts.add(new Exclusion("avalon-logkit", "avalon-logkit", null, null));
        for (String exclusion : excludedArtifactsAsString) {
            String[] exclusionParts = exclusion.split(":");
            this.parsedExcludedArtifacts.add(new Exclusion(exclusionParts[0], exclusionParts[1], exclusionParts.length > 2 ? exclusionParts[2] : null, exclusionParts.length > 3 ? exclusionParts[3] : null));
        }
    }

    private void generateJMeterDirectoryTree() {
        File workingDirectory = new File(this.jmeterDirectory, "bin");
        workingDirectory.mkdirs();
        JMeterConfigurationHolder.getInstance().setWorkingDirectory(workingDirectory);
        this.customPropertiesDirectory = new File(this.jmeterDirectory, "custom_properties");
        this.customPropertiesDirectory.mkdirs();
        this.libDirectory = new File(this.jmeterDirectory, "lib");
        this.libExtDirectory = new File(this.libDirectory, "ext");
        this.libExtDirectory.mkdirs();
        this.libJUnitDirectory = new File(this.libDirectory, "junit");
        this.libJUnitDirectory.mkdirs();
        this.testFilesBuildDirectory.mkdirs();
        this.resultsDirectory.mkdirs();
        if (this.generateReports) {
            this.reportDirectory.mkdirs();
        }
        this.logsDirectory.mkdirs();
    }

    private void configurePropertiesFiles() throws MojoExecutionException {
        EnumMap<ConfigurationFiles, PropertiesMapping> propertiesMap = new EnumMap<ConfigurationFiles, PropertiesMapping>(ConfigurationFiles.class);
        JMeterConfigurationHolder.getInstance().setPropertiesMap(propertiesMap);
        propertiesMap.put(ConfigurationFiles.JMETER_PROPERTIES, new PropertiesMapping(this.propertiesJMeter));
        propertiesMap.put(ConfigurationFiles.SAVE_SERVICE_PROPERTIES, new PropertiesMapping(this.propertiesSaveService));
        propertiesMap.put(ConfigurationFiles.UPGRADE_PROPERTIES, new PropertiesMapping(this.propertiesUpgrade));
        propertiesMap.put(ConfigurationFiles.SYSTEM_PROPERTIES, new PropertiesMapping(this.propertiesSystem));
        propertiesMap.put(ConfigurationFiles.REPORT_GENERATOR_PROPERTIES, new PropertiesMapping(this.propertiesReportGenerator));
        propertiesMap.put(ConfigurationFiles.USER_PROPERTIES, new PropertiesMapping(this.propertiesUser));
        propertiesMap.put(ConfigurationFiles.GLOBAL_PROPERTIES, new PropertiesMapping(this.propertiesGlobal));
        this.setJMeterResultFileFormat();
        for (ConfigurationFiles configurationFile : ConfigurationFiles.values()) {
            File suppliedPropertiesFile = new File(this.propertiesFilesDirectory, configurationFile.getFilename());
            File propertiesFileToWrite = new File(JMeterConfigurationHolder.getInstance().getWorkingDirectory(), configurationFile.getFilename());
            PropertiesFile somePropertiesFile = new PropertiesFile(this.jmeterConfigArtifact, configurationFile);
            somePropertiesFile.loadProvidedPropertiesIfAvailable(suppliedPropertiesFile, this.propertiesReplacedByCustomFiles);
            somePropertiesFile.addAndOverwriteProperties(((PropertiesMapping)propertiesMap.get((Object)configurationFile)).getAdditionalProperties());
            somePropertiesFile.writePropertiesToFile(propertiesFileToWrite);
            ((PropertiesMapping)propertiesMap.get((Object)configurationFile)).setPropertiesFile(somePropertiesFile);
        }
        for (File customPropertiesFile : this.customPropertiesFiles) {
            PropertiesFile customProperties = new PropertiesFile(customPropertiesFile);
            String customPropertiesFilename = FilenameUtils.getBaseName((String)customPropertiesFile.getName()) + "-" + UUID.randomUUID().toString() + "." + FilenameUtils.getExtension((String)customPropertiesFile.getName());
            customProperties.writePropertiesToFile(new File(this.customPropertiesDirectory, customPropertiesFilename));
        }
        this.setDefaultPluginProperties(JMeterConfigurationHolder.getInstance().getWorkingDirectory().getAbsolutePath());
    }

    protected void generateTestConfig() throws MojoExecutionException {
        try (InputStream configFile = ((Object)((Object)this)).getClass().getResourceAsStream(BASE_CONFIG_FILE);){
            TestConfig testConfig = new TestConfig(configFile);
            testConfig.setResultsOutputIsCSVFormat(this.resultsOutputIsCSVFormat);
            testConfig.setGenerateReports(this.generateReports);
            testConfig.writeResultFilesConfigTo(this.testConfigFile);
        }
        catch (java.io.IOException ex) {
            throw new MojoExecutionException("Exception creating TestConfig", (Exception)ex);
        }
    }

    protected void setJMeterResultFileFormat() {
        if (this.generateReports || "csv".equalsIgnoreCase(this.resultsFileFormat)) {
            this.propertiesJMeter.put("jmeter.save.saveservice.output_format", "csv");
            this.resultsOutputIsCSVFormat = true;
        } else {
            this.propertiesJMeter.put("jmeter.save.saveservice.output_format", "xml");
            this.resultsOutputIsCSVFormat = false;
        }
    }

    public void setDefaultPluginProperties(String userDirectory) {
        System.setProperty("user.dir", userDirectory);
        System.setProperty("jmeterengine.remote.system.exit", "false");
        System.setProperty("jmeterengine.stopfail.system.exit", "false");
    }

    private void configureJMeterArtifacts() {
        if (this.jmeterArtifacts.isEmpty()) {
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_components:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_config:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_core:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_ftp:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_functions:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_http:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_java:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_jdbc:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_jms:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_junit:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_ldap:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_mail:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_mongodb:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_native:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:ApacheJMeter_tcp:" + this.jmeterVersion);
            this.jmeterArtifacts.add("org.apache.jmeter:jorphan:" + this.jmeterVersion);
        }
    }

    private void populateJMeterDirectoryTree() throws DependencyResolutionException, IOException {
        if (this.jmeterArtifacts.isEmpty()) {
            throw new DependencyResolutionException("No JMeter dependencies specified!, check jmeterArtifacts and jmeterVersion elements");
        }
        block10: for (String desiredArtifact : this.jmeterArtifacts) {
            Artifact returnedArtifact = this.getArtifactResult((Artifact)new DefaultArtifact(desiredArtifact));
            switch (returnedArtifact.getArtifactId()) {
                case "ApacheJMeter_config": {
                    this.jmeterConfigArtifact = returnedArtifact;
                    this.extractConfigSettings(this.jmeterConfigArtifact);
                    continue block10;
                }
                case "jorphan": {
                    this.copyArtifact(returnedArtifact, this.libDirectory);
                    this.copyTransitiveRuntimeDependenciesToLibDirectory(returnedArtifact, this.downloadJMeterDependencies);
                    continue block10;
                }
                case "ApacheJMeter": {
                    JMeterConfigurationHolder.getInstance().setRuntimeJarName(returnedArtifact.getFile().getName());
                    this.copyArtifact(returnedArtifact, JMeterConfigurationHolder.getInstance().getWorkingDirectory());
                    this.copyTransitiveRuntimeDependenciesToLibDirectory(returnedArtifact, this.downloadJMeterDependencies);
                    continue block10;
                }
            }
            this.copyArtifact(returnedArtifact, this.libExtDirectory);
            this.copyTransitiveRuntimeDependenciesToLibDirectory(returnedArtifact, this.downloadJMeterDependencies);
        }
        if (this.confFilesDirectory.exists()) {
            ConfigureJMeterMojo.copyFilesInTestDirectory(this.confFilesDirectory, new File(this.jmeterDirectory, "bin"));
        }
    }

    private void copyExplicitLibraries(List<String> desiredArtifacts, File destination, boolean downloadDependencies) throws DependencyResolutionException, IOException {
        for (String desiredArtifact : desiredArtifacts) {
            this.copyExplicitLibraries(desiredArtifact, destination, downloadDependencies);
        }
    }

    private void copyExplicitLibraries(String desiredArtifact, File destination, boolean downloadDependencies) throws DependencyResolutionException, IOException {
        Artifact returnedArtifact = this.getArtifactResult((Artifact)new DefaultArtifact(desiredArtifact));
        this.copyArtifact(returnedArtifact, destination);
        if (downloadDependencies) {
            this.resolveTestDependenciesAndCopyWithTransitivity(returnedArtifact, true);
        }
    }

    private Artifact getArtifactResult(Artifact desiredArtifact) throws DependencyResolutionException {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(desiredArtifact);
        artifactRequest.setRepositories(this.repositoryList);
        try {
            return this.repositorySystem.resolveArtifact(this.repositorySystemSession, artifactRequest).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new DependencyResolutionException(e.getMessage(), e);
        }
    }

    private void resolveTestDependenciesAndCopyWithTransitivity(Artifact artifact, boolean getDependenciesOfDependency) throws DependencyResolutionException, IOException {
        ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(artifact, this.repositoryList, null);
        try {
            ArtifactDescriptorResult result = this.repositorySystem.readArtifactDescriptor(this.repositorySystemSession, request);
            for (Dependency dep : result.getDependencies()) {
                ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(this.repositorySystemSession, new ArtifactRequest(dep.getArtifact(), this.repositoryList, null));
                if (this.isLibraryArtifact(artifactResult.getArtifact())) {
                    this.copyArtifact(artifactResult.getArtifact(), this.libDirectory);
                } else {
                    this.getLog().debug((CharSequence)("Artifact " + artifactResult.getArtifact() + " is not a library, ignoring"));
                }
                this.copyTransitiveRuntimeDependenciesToLibDirectory(dep, getDependenciesOfDependency);
            }
        }
        catch (ArtifactDescriptorException | ArtifactResolutionException e) {
            throw new DependencyResolutionException(e.getMessage(), e);
        }
    }

    private void copyTransitiveRuntimeDependenciesToLibDirectory(Artifact artifact, boolean getDependenciesOfDependency) throws DependencyResolutionException, IOException {
        this.copyTransitiveRuntimeDependenciesToLibDirectory(new Dependency(artifact, DEPENDENCIES_DEFAULT_SEARCH_SCOPE), getDependenciesOfDependency);
    }

    private void copyTransitiveRuntimeDependenciesToLibDirectory(Dependency rootDependency, boolean getDependenciesOfDependency) throws DependencyResolutionException, IOException {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(rootDependency);
        collectRequest.setRepositories(this.repositoryList);
        DependencyFilter dependencyFilter = DependencyFilterUtils.andFilter((DependencyFilter[])new DependencyFilter[]{DependencyFilterUtils.classpathFilter((String[])new String[]{DEPENDENCIES_DEFAULT_SEARCH_SCOPE}), (dependencyNode, arg1) -> {
            Artifact artifact = dependencyNode.getArtifact();
            if (dependencyNode.getDependency().isOptional()) {
                this.getLog().debug((CharSequence)("Filtering dependency " + dependencyNode.getDependency()));
                return false;
            }
            for (Exclusion currentExclusion : this.parsedExcludedArtifacts) {
                if ((!currentExclusion.getGroupId().equals(artifact.getGroupId()) || !currentExclusion.getArtifactId().equals(artifact.getArtifactId())) && !currentExclusion.getArtifactId().equals(ARTIFACT_STAR)) continue;
                this.getLog().debug((CharSequence)("Filtering excluded dependency " + dependencyNode.getDependency()));
                return false;
            }
            return true;
        }});
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, dependencyFilter);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Root dependency name: " + rootDependency.toString()));
            if (dependencyRequest.getCollectRequest() != null && dependencyRequest.getCollectRequest().getTrace() != null) {
                this.getLog().debug((CharSequence)("Root dependency request trace: " + dependencyRequest.getCollectRequest().getTrace().toString()));
            }
            this.getLog().debug((CharSequence)("Root dependency exclusions: " + rootDependency.getExclusions()));
            this.getLog().debug((CharSequence)"-------------------------------------------------------");
        }
        try {
            List artifactDependencyNodes = this.repositorySystem.collectDependencies(this.repositorySystemSession, collectRequest).getRoot().getChildren();
            for (DependencyNode dependencyNode2 : artifactDependencyNodes) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Dependency name: " + dependencyNode2.toString()));
                    if (dependencyRequest.getCollectRequest() != null && dependencyRequest.getCollectRequest().getTrace() != null) {
                        this.getLog().debug((CharSequence)("Dependency request trace: " + dependencyRequest.getCollectRequest().getTrace().toString()));
                    }
                    this.getLog().debug((CharSequence)"-------------------------------------------------------");
                }
                Exclusion dummyExclusion = new Exclusion(dependencyNode2.getArtifact().getGroupId(), dependencyNode2.getArtifact().getArtifactId(), dependencyNode2.getArtifact().getClassifier(), dependencyNode2.getArtifact().getExtension());
                if (!this.downloadOptionalDependencies && dependencyNode2.getDependency().isOptional() || this.containsEx(this.parsedExcludedArtifacts, dummyExclusion) || rootDependency.getExclusions() != null && this.containsEx(rootDependency.getExclusions(), dummyExclusion)) continue;
                Artifact returnedArtifact = this.repositorySystem.resolveArtifact(this.repositorySystemSession, new ArtifactRequest(dependencyNode2)).getArtifact();
                if (!returnedArtifact.getArtifactId().startsWith("ApacheJMeter_") && this.isLibraryArtifact(returnedArtifact)) {
                    this.copyArtifact(returnedArtifact, this.libDirectory);
                }
                if (!getDependenciesOfDependency || this.processedArtifacts.contains(dummyExclusion)) continue;
                this.processedArtifacts.add(dummyExclusion);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Added to processed list: " + dummyExclusion));
                    this.getLog().debug((CharSequence)("total processed: " + this.processedArtifacts.size()));
                    this.getLog().debug((CharSequence)"-------------------------------------------------------");
                }
                this.copyTransitiveRuntimeDependenciesToLibDirectory(dependencyNode2.getDependency(), true);
            }
        }
        catch (DependencyCollectionException | ArtifactResolutionException e) {
            throw new DependencyResolutionException(e.getMessage(), e);
        }
    }

    private boolean containsEx(Collection<Exclusion> exclusions, Exclusion exclusion) {
        if (exclusion != null && exclusions != null) {
            for (Exclusion currentExclusion : exclusions) {
                if (!currentExclusion.getGroupId().equals(exclusion.getGroupId()) || !currentExclusion.getArtifactId().equals(exclusion.getArtifactId()) && !currentExclusion.getArtifactId().equals(ARTIFACT_STAR)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLibraryArtifact(Artifact artifact) {
        return artifact.getExtension().equals("jar") || artifact.getExtension().equals("war") || artifact.getExtension().equals("zip") || artifact.getExtension().equals("ear");
    }

    private void copyArtifact(Artifact artifact, File destinationDirectory) throws IOException, DependencyResolutionException {
        for (String ignoredArtifact : this.ignoredArtifacts) {
            Artifact artifactToIgnore = this.getArtifactResult((Artifact)new DefaultArtifact(ignoredArtifact));
            if (!artifact.getFile().getName().equals(artifactToIgnore.getFile().getName())) continue;
            this.getLog().debug((CharSequence)(artifact.getFile().getName() + " has not been copied over because it is in the ignore list."));
            return;
        }
        try {
            Iterator<Artifact> iterator = this.copiedArtifacts.iterator();
            while (iterator.hasNext()) {
                Version artifactVersion;
                Artifact currentArtifact = iterator.next();
                if (!currentArtifact.getGroupId().equals(artifact.getGroupId()) || !currentArtifact.getArtifactId().equals(artifact.getArtifactId()) || !currentArtifact.getExtension().equals(artifact.getExtension()) || !currentArtifact.getClassifier().equals(artifact.getClassifier())) continue;
                GenericVersionScheme genericVersionScheme = new GenericVersionScheme();
                Version currentArtifactVersion = genericVersionScheme.parseVersion(currentArtifact.getVersion());
                if (currentArtifactVersion.compareTo((Object)(artifactVersion = genericVersionScheme.parseVersion(artifact.getVersion()))) >= 0) {
                    return;
                }
                File artifactToDelete = new File(destinationDirectory, currentArtifact.getFile().getName());
                this.getLog().debug((CharSequence)("Deleting file:'" + artifactToDelete.getAbsolutePath() + "'"));
                FileUtils.forceDelete((File)artifactToDelete);
                iterator.remove();
                break;
            }
            this.copiedArtifacts.add(artifact);
            File artifactToCopy = new File(destinationDirectory, artifact.getFile().getName());
            this.getLog().debug((CharSequence)("Checking: " + artifactToCopy.getAbsolutePath() + "..."));
            if (!artifactToCopy.exists()) {
                this.getLog().debug((CharSequence)("Copying: " + artifactToCopy.getAbsolutePath() + " to " + destinationDirectory.getAbsolutePath()));
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)destinationDirectory);
            }
        }
        catch (java.io.IOException | InvalidVersionSpecificationException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void extractConfigSettings(Artifact artifact) throws IOException {
        try (JarFile configSettings = new JarFile(artifact.getFile());){
            Enumeration<JarEntry> entries = configSettings.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarFileEntry = entries.nextElement();
                if (jarFileEntry.isDirectory() || !jarFileEntry.getName().startsWith("bin") || jarFileEntry.getName().endsWith(".properties")) continue;
                File fileToCreate = new File(this.jmeterDirectory, jarFileEntry.getName());
                FileUtils.copyInputStreamToFile((InputStream)configSettings.getInputStream(jarFileEntry), (File)fileToCreate);
            }
        }
        catch (java.io.IOException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

