/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.configuration.JMeterProcessJVMSettings;
import com.lazerycode.jmeter.mojo.AbstractJMeterMojo;
import com.lazerycode.jmeter.mojo.JMeterConfigurationHolder;
import com.lazerycode.jmeter.testrunner.JMeterProcessBuilder;
import com.lazerycode.jmeter.utility.UtilityFunctions;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="remote-server", defaultPhase=LifecyclePhase.TEST)
@Execute(goal="configure")
public class RunJMeterServer
extends AbstractJMeterMojo {
    @Parameter(defaultValue="false")
    private boolean runInBackground;
    @Parameter
    private Integer serverPort;
    @Parameter
    private String exportedRmiHostname;
    private JMeterArgumentsArray testArgs;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)(" STARTING JMETER SERVER ON PORT:" + this.serverPort + " WITH EXPORTED HOSTNAME:" + this.exportedRmiHostname));
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.testArgs = this.initializeJMeterArgumentsArray();
        this.getLog().debug((CharSequence)("JMeter is called with the following command line arguments: " + UtilityFunctions.humanReadableCommandLineOutput(this.testArgs.buildArgumentsArray())));
        this.startJMeterServer();
    }

    private JMeterArgumentsArray initializeJMeterArgumentsArray() throws MojoExecutionException {
        JMeterArgumentsArray currentTestArgs = new JMeterArgumentsArray(true, this.jmeterDirectory.getAbsolutePath());
        currentTestArgs.setProxyConfig(this.proxyConfig);
        for (File customPropertiesFile : this.customPropertiesFiles) {
            currentTestArgs.setACustomPropertiesFile(customPropertiesFile);
        }
        currentTestArgs.setLogRootOverride(this.overrideRootLogLevel);
        currentTestArgs.setLogsDirectory(this.logsDirectory.getAbsolutePath());
        currentTestArgs.setServerMode(this.exportedRmiHostname, this.serverPort);
        return currentTestArgs;
    }

    private void startJMeterServer() throws MojoExecutionException {
        JMeterProcessJVMSettings jMeterProcessJVMSettings = null;
        jMeterProcessJVMSettings = this.jMeterProcessJVMSettings == null ? new JMeterProcessJVMSettings() : new JMeterProcessJVMSettings(this.jMeterProcessJVMSettings);
        if (this.exportedRmiHostname != null && !this.exportedRmiHostname.isEmpty()) {
            jMeterProcessJVMSettings.getArguments().add("-Djava.rmi.server.hostname=" + this.exportedRmiHostname);
        }
        if (!RunJMeterServer.containsHeadless(jMeterProcessJVMSettings)) {
            jMeterProcessJVMSettings.getArguments().add("-Djava.awt.headless=true");
        }
        if (this.serverPort == null) {
            throw new MojoExecutionException("serverPort is null, cannot start jmeter server");
        }
        jMeterProcessJVMSettings.getArguments().add("-Dserver_port=" + this.serverPort);
        JMeterProcessBuilder jmeterProcessBuilder = new JMeterProcessBuilder(jMeterProcessJVMSettings, JMeterConfigurationHolder.getInstance().getRuntimeJarName());
        jmeterProcessBuilder.setWorkingDirectory(JMeterConfigurationHolder.getInstance().getWorkingDirectory());
        jmeterProcessBuilder.addArguments(this.testArgs.buildArgumentsArray());
        try {
            Process process = jmeterProcessBuilder.startProcess();
            if (!this.runInBackground) {
                process.waitFor();
            }
        }
        catch (InterruptedException ex) {
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)"System Exit Detected!  Stopping GUI...");
            this.getLog().info((CharSequence)" ");
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Error starting JMeter with args " + this.testArgs.buildArgumentsArray() + ", in working directory:" + JMeterConfigurationHolder.getInstance().getWorkingDirectory()), (Throwable)e);
        }
    }
}

