/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.json.TestConfigurationWrapper;
import com.lazerycode.jmeter.mojo.AbstractJMeterMojo;
import com.lazerycode.jmeter.mojo.JMeterConfigurationHolder;
import com.lazerycode.jmeter.testrunner.JMeterProcessBuilder;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="remote-server", defaultPhase=LifecyclePhase.INTEGRATION_TEST)
public class RunJMeterServerMojo
extends AbstractJMeterMojo {
    @Parameter(defaultValue="false")
    private boolean runInBackground;
    @Parameter(defaultValue="1099")
    private Integer serverPort;
    @Parameter(defaultValue="localhost")
    private String exportedRmiHostname;

    @Override
    public void doExecute() throws MojoExecutionException {
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" S T A R T I N G    J M E T E R    S E R V E R ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)String.format(" Host: %s", this.exportedRmiHostname));
        this.getLog().info((CharSequence)String.format(" Port: %s", this.serverPort));
        this.testConfig = new TestConfigurationWrapper(new File(this.testConfigFile), this.selectedConfiguration);
        this.startJMeterServer(this.initializeJMeterArgumentsArray());
    }

    private JMeterArgumentsArray initializeJMeterArgumentsArray() throws MojoExecutionException {
        return new JMeterArgumentsArray(false, this.testConfig.getCurrentTestConfiguration().getJmeterDirectoryPath()).setProxyConfig(this.proxyConfig).addACustomPropertiesFiles(this.customPropertiesFiles).setLogRootOverride(this.overrideRootLogLevel).setLogsDirectory(this.logsDirectory.getAbsolutePath()).setServerMode(this.exportedRmiHostname, this.serverPort);
    }

    private void startJMeterServer(JMeterArgumentsArray testArgs) throws MojoExecutionException {
        this.jMeterProcessJVMSettings.setHeadlessDefaultIfRequired().addArgument(String.format("-Djava.rmi.server.hostname=%s", this.exportedRmiHostname)).addArgument(String.format("-Dserver_port=%s", this.serverPort));
        JMeterProcessBuilder jmeterProcessBuilder = new JMeterProcessBuilder(this.jMeterProcessJVMSettings, this.testConfig.getCurrentTestConfiguration().getRuntimeJarName()).setWorkingDirectory(JMeterConfigurationHolder.getInstance().getWorkingDirectory()).addArguments(testArgs.buildArgumentsArray());
        try {
            Process process = jmeterProcessBuilder.build().start();
            if (this.runInBackground) {
                this.getLog().info((CharSequence)" ");
                this.getLog().info((CharSequence)" Starting JMeter server process in the background...");
            } else {
                this.waitForEndAndCheckExitCode(process);
            }
        }
        catch (IOException ioException) {
            this.getLog().error((CharSequence)String.format("Error starting JMeter with args %s, in working directory: %s", testArgs.buildArgumentsArray(), JMeterConfigurationHolder.getInstance().getWorkingDirectory()), (Throwable)ioException);
        }
    }

    private void waitForEndAndCheckExitCode(Process process) throws MojoExecutionException {
        try {
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new MojoExecutionException("Starting jmeter server in background failed with exit code:" + exitCode + ", check jmeter logs for more details");
            }
        }
        catch (InterruptedException ex) {
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)"System Exit detected!  Stopping server process...");
            this.getLog().info((CharSequence)" ");
            Thread.currentThread().interrupt();
        }
    }
}

