/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.json.TestConfigurationWrapper;
import com.lazerycode.jmeter.mojo.AbstractJMeterMojo;
import com.lazerycode.jmeter.testrunner.JMeterProcessBuilder;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="gui", defaultPhase=LifecyclePhase.INTEGRATION_TEST)
public class RunJMeterGUIMojo
extends AbstractJMeterMojo {
    @Parameter(defaultValue="false")
    private boolean runInBackground;
    @Parameter
    private File guiTestFile;

    @Override
    public void doExecute() throws MojoExecutionException {
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" S T A R T I N G    J M E T E R    G U I ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.testConfig = new TestConfigurationWrapper(new File(this.testConfigFile), this.mojoExecution.getExecutionId());
        this.startJMeterGUI(this.initialiseJMeterArgumentsArray());
    }

    private JMeterArgumentsArray initialiseJMeterArgumentsArray() throws MojoExecutionException {
        return this.computeJMeterArgumentsArray(false, this.testConfig.getCurrentTestConfiguration().getResultsOutputIsCSVFormat(), this.testConfig.getCurrentTestConfiguration().getJmeterDirectoryPath()).setTestFile(this.guiTestFile, this.testFilesDirectory);
    }

    private void startJMeterGUI(JMeterArgumentsArray testArgs) throws MojoExecutionException {
        JMeterProcessBuilder jmeterProcessBuilder = new JMeterProcessBuilder(this.jMeterProcessJVMSettings, this.testConfig.getCurrentTestConfiguration().getRuntimeJarName()).setWorkingDirectory(new File(this.testConfig.getCurrentTestConfiguration().getJmeterWorkingDirectoryPath())).addArguments(testArgs.buildArgumentsArray());
        try {
            Process process = jmeterProcessBuilder.build().start();
            if (this.runInBackground) {
                this.getLog().info((CharSequence)" ");
                this.getLog().info((CharSequence)" Starting JMeter GUI process in the background...");
            } else {
                process.waitFor();
            }
        }
        catch (InterruptedException ex) {
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)"System Exit detected!  Stopping GUI process...");
            this.getLog().info((CharSequence)" ");
            Thread.currentThread().interrupt();
        }
        catch (IOException ioException) {
            this.getLog().error((CharSequence)String.format("Error starting JMeter with args %s, in working directory: %s", testArgs.buildArgumentsArray(), this.testConfig.getCurrentTestConfiguration().getJmeterDirectoryPath()), (Throwable)ioException);
        }
    }
}

