/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.testrunner;

import com.lazerycode.jmeter.testrunner.IResultScanner;

public class TestFailureDecider {
    private IResultScanner resultScanner;
    private boolean ignoreResultFailures;
    private float errorPercentageThreshold;
    private float errorPercentage;
    private boolean checkRan;

    public TestFailureDecider(boolean ignoreResultFailures, float errorPercentageThreshold, IResultScanner resultScanner) {
        this.ignoreResultFailures = ignoreResultFailures;
        this.errorPercentageThreshold = errorPercentageThreshold;
        this.resultScanner = resultScanner;
    }

    public boolean failBuild() {
        if (!this.checkRan) {
            throw new IllegalStateException("You need to call runChecks");
        }
        return !this.ignoreResultFailures && this.errorPercentage > this.errorPercentageThreshold;
    }

    public void runChecks() {
        this.errorPercentage = (float)this.resultScanner.getFailureCount() / (float)(this.resultScanner.getSuccessCount() + this.resultScanner.getFailureCount()) * 100.0f;
        this.checkRan = true;
    }

    public boolean isIgnoreResultFailures() {
        return this.ignoreResultFailures;
    }

    public float getErrorPercentageThreshold() {
        return this.errorPercentageThreshold;
    }

    public float getErrorPercentage() {
        return this.errorPercentage;
    }
}

