/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.properties;

import com.lazerycode.jmeter.properties.ConfigurationFiles;
import com.lazerycode.jmeter.properties.ReservedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.aether.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFile.class);
    private Properties properties;

    public PropertiesFile() {
        this.properties = new Properties();
    }

    public PropertiesFile(File propertiesFile) throws MojoExecutionException {
        this.properties = this.loadPropertiesFile(propertiesFile);
    }

    public PropertiesFile(Artifact jmeterConfigArtifact, ConfigurationFiles jMeterPropertiesFile) throws MojoExecutionException {
        Properties defaultPropertySet = new Properties();
        if (null != jmeterConfigArtifact && jMeterPropertiesFile.createFileIfItDoesNotExist()) {
            try (JarFile propertyJar = new JarFile(jmeterConfigArtifact.getFile());
                 InputStream sourceFile = propertyJar.getInputStream(propertyJar.getEntry("bin/" + jMeterPropertiesFile.getFilename()));){
                defaultPropertySet.load(sourceFile);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
        }
        this.properties = defaultPropertySet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadPropertiesFile(File propertiesFile) throws MojoExecutionException {
        try (FileInputStream propertiesFileInputStream = new FileInputStream(propertiesFile);){
            Properties loadedProperties = new Properties();
            loadedProperties.load(propertiesFileInputStream);
            Properties properties = loadedProperties;
            return properties;
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public void loadProvidedPropertiesIfAvailable(File providedPropertiesFile, boolean replaceAllProperties) throws MojoExecutionException {
        if (providedPropertiesFile.exists()) {
            Properties providedPropertySet = this.loadPropertiesFile(providedPropertiesFile);
            if (replaceAllProperties) {
                this.properties = providedPropertySet;
            } else {
                this.properties.putAll((Map<?, ?>)providedPropertySet);
            }
        }
    }

    public void addAndOverwriteProperties(Map<String, String> additionalProperties) {
        additionalProperties.values().removeAll(Collections.singleton(null));
        for (Map.Entry<String, String> additionalPropertiesMap : additionalProperties.entrySet()) {
            if (additionalPropertiesMap.getValue().trim().isEmpty()) continue;
            this.properties.setProperty(additionalPropertiesMap.getKey(), additionalPropertiesMap.getValue());
            this.warnUserOfPossibleErrors(additionalPropertiesMap.getKey(), this.properties);
        }
    }

    public void writePropertiesToFile(File outputFile) throws MojoExecutionException {
        this.stripOutReservedProperties();
        if (this.properties.isEmpty()) {
            return;
        }
        try (FileOutputStream writeOutFinalPropertiesFile = new FileOutputStream(outputFile);){
            this.properties.store(writeOutFinalPropertiesFile, null);
            writeOutFinalPropertiesFile.flush();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void warnUserOfPossibleErrors(String newKey, Properties baseProperties) {
        for (String key : baseProperties.stringPropertyNames()) {
            if (key.equals(newKey) || !key.equalsIgnoreCase(newKey)) continue;
            LOGGER.warn("You have set a property called '{}' which is very similar to '{}'!", (Object)newKey, (Object)key);
        }
    }

    protected void stripOutReservedProperties() {
        for (ReservedProperties reservedProperty : ReservedProperties.values()) {
            if (!this.properties.containsKey(reservedProperty.getPropertyKey())) continue;
            this.properties.remove(reservedProperty.getPropertyKey());
            LOGGER.warn("Unable to set '" + reservedProperty.getPropertyKey() + "', it is a reserved property in the jmeter-maven-plugin");
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

