/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.testrunner;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.lazerycode.jmeter.testrunner.IResultScanner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultScanner
implements IResultScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultScanner.class);
    private static final String CSV_REQUEST_FAILURE = "false";
    private static final String CSV_REQUEST_SUCCESS = "true";
    private static final String XML_REQUEST_FAILURE_PATTERN = "s=\"false\"";
    private static final String XML_REQUEST_SUCCESS_PATTERN = "s=\"true\"";
    private static final String ROW_NAME_SUCCESS = "success";
    private static final String ROW_NAME_FAILURE_MESSAGE = "failureMessage";
    private static final CsvMapper CSV_MAPPER = new CsvMapper();
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final boolean countFailures;
    private final boolean countSuccesses;
    private final boolean onlyFailWhenMatchingFailureMessage;
    private final List<String> failureMessages;
    private int failureCount = 0;
    private int successCount = 0;
    private boolean csv;
    private String format;

    public ResultScanner(boolean countSuccesses, boolean countFailures, boolean isCsv, boolean onlyFailWhenMatchingFailureMessage, List<String> failureMessages) {
        this.countFailures = countFailures;
        this.countSuccesses = countSuccesses;
        this.csv = isCsv;
        this.format = this.csv ? "CSV" : "XML";
        this.onlyFailWhenMatchingFailureMessage = onlyFailWhenMatchingFailureMessage;
        this.failureMessages = failureMessages;
    }

    private static char lookForDelimiter(String line) {
        for (char ch : line.toCharArray()) {
            if (Character.isLetter(ch)) continue;
            return ch;
        }
        throw new IllegalStateException("Cannot find delimiter in header " + line);
    }

    public void parseResultFile(File file) throws MojoExecutionException {
        if (!file.exists()) {
            throw new MojoExecutionException("Unable to find " + file.getAbsolutePath());
        }
        LOGGER.info(" ");
        LOGGER.info("Parsing results file '{}' as type: {}", (Object)file, (Object)this.format);
        if (this.countFailures) {
            if (this.csv) {
                if (this.onlyFailWhenMatchingFailureMessage) {
                    for (String failureMessage : this.failureMessages) {
                        this.failureCount += this.scanCsvForValue(file, failureMessage.toLowerCase(), ROW_NAME_FAILURE_MESSAGE);
                    }
                } else {
                    this.failureCount += this.scanCsvForValue(file, CSV_REQUEST_FAILURE, ROW_NAME_SUCCESS);
                }
            } else {
                this.failureCount += this.scanXmlForPattern(file, XML_REQUEST_FAILURE_PATTERN);
            }
            LOGGER.info("Number of failures in '{}': {}", (Object)file.getName(), (Object)this.failureCount);
        }
        if (this.countSuccesses) {
            this.successCount = this.csv ? (this.successCount += this.scanCsvForValue(file, CSV_REQUEST_SUCCESS, ROW_NAME_SUCCESS)) : (this.successCount += this.scanXmlForPattern(file, XML_REQUEST_SUCCESS_PATTERN));
            LOGGER.info("Number of successes in '{}': {}", (Object)file.getName(), (Object)this.successCount);
        }
    }

    private int scanCsvForValue(File file, String searchedForValue, String rowName) throws MojoExecutionException {
        int numberOfMatches = 0;
        try {
            char separator = this.computeSeparator(file);
            CsvSchema schema = CsvSchema.emptySchema().withHeader().withColumnSeparator(separator);
            try (FileReader fr = new FileReader(file);
                 BufferedReader reader = new BufferedReader(fr, 8192);){
                MappingIterator it = CSV_MAPPER.readerFor(Map.class).with((FormatSchema)schema).readValues((Reader)reader);
                while (it.hasNext()) {
                    Map row = (Map)it.next();
                    String successValue = (String)row.get(rowName);
                    if (!searchedForValue.equals(successValue.toLowerCase())) continue;
                    ++numberOfMatches;
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("An unexpected error occurred while reading file " + file.getAbsolutePath(), (Exception)e);
        }
        return numberOfMatches;
    }

    private char computeSeparator(File file) throws IOException {
        Throwable throwable = null;
        try (FileReader fr = new FileReader(file);){
            Throwable throwable2;
            BufferedReader reader;
            block25: {
                char c;
                block26: {
                    block27: {
                        reader = new BufferedReader(fr, 8192);
                        throwable2 = null;
                        String line = reader.readLine();
                        if (line == null) break block25;
                        c = ResultScanner.lookForDelimiter(line);
                        if (reader == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    reader.close();
                }
                return c;
            }
            try {
                try {
                    try {
                        throw new IllegalArgumentException("No line read from file " + file.getAbsolutePath());
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (reader != null) {
                        if (throwable2 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            reader.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    private int scanXmlForPattern(File file, String patternAsString) throws MojoExecutionException {
        int patternCount = 0;
        Pattern pattern = Pattern.compile(patternAsString, 2);
        try (Scanner resultFileScanner = new Scanner(file);){
            while (resultFileScanner.findWithinHorizon(pattern, 0) != null) {
                ++patternCount;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("An unexpected error occured while reading file " + file.getAbsolutePath(), (Exception)e);
        }
        return patternCount;
    }

    @Override
    public int getFailureCount() {
        return this.failureCount;
    }

    @Override
    public int getSuccessCount() {
        return this.successCount;
    }
}

