/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.json.TestConfigurationWrapper;
import com.lazerycode.jmeter.mojo.AbstractJMeterMojo;
import com.lazerycode.jmeter.results.ResultScanner;
import com.lazerycode.jmeter.testrunner.TestFailureDecider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="results", defaultPhase=LifecyclePhase.VERIFY)
public class CheckResultsMojo
extends AbstractJMeterMojo {
    @Parameter(defaultValue="false")
    protected boolean ignoreResultFailures;
    @Parameter(defaultValue="true")
    protected boolean scanResultsForFailedRequests;
    @Parameter(defaultValue="0")
    protected float errorRateThresholdInPercent;
    @Parameter(defaultValue="true")
    protected boolean scanResultsForSuccessfulRequests;
    @Parameter(defaultValue="false")
    protected boolean onlyFailWhenMatchingFailureMessage;
    @Parameter(defaultValue="false")
    protected boolean failBuildIfResultFileIsEmpty;
    @Parameter
    protected List<String> failureMessages = new ArrayList<String>();

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.ignoreResultFailures && !this.scanResultsForFailedRequests) {
            this.getLog().warn((CharSequence)String.format("current value of scanResultsForFailedRequests(%s) is incompatible with ignoreResultFailures(%s), setting scanResultsForFailedRequests to true", this.scanResultsForFailedRequests, this.ignoreResultFailures));
            this.scanResultsForFailedRequests = true;
        }
        if (this.scanResultsForSuccessfulRequests || this.scanResultsForFailedRequests) {
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)"-------------------------------------------------------");
            this.getLog().info((CharSequence)"S C A N N I N G    F O R    R E S U L T S");
            this.getLog().info((CharSequence)"-------------------------------------------------------");
            this.getLog().info((CharSequence)" ");
            TestConfigurationWrapper testConfig = new TestConfigurationWrapper(new File(this.testConfigFile), this.selectedConfiguration);
            String resultFormat = testConfig.getCurrentTestConfiguration().getResultsOutputIsCSVFormat() != false ? "CSV" : "JTL";
            this.getLog().info((CharSequence)String.format("Will scan results using format: %s", resultFormat));
            ResultScanner resultScanner = new ResultScanner(this.scanResultsForSuccessfulRequests, this.scanResultsForFailedRequests, testConfig.getCurrentTestConfiguration().getResultsOutputIsCSVFormat(), this.onlyFailWhenMatchingFailureMessage, this.failureMessages);
            for (String resultFileLocation : testConfig.getCurrentTestConfiguration().getResultFilesLocations()) {
                resultScanner.parseResultFile(new File(resultFileLocation));
            }
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)"-------------------------------------------------------");
            this.getLog().info((CharSequence)"P E R F O R M A N C E    T E S T    R E S U L T S");
            this.getLog().info((CharSequence)"-------------------------------------------------------");
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)String.format("Result (.%s) files scanned: %s", resultFormat.toLowerCase(), testConfig.getCurrentTestConfiguration().getResultFilesLocations().size()));
            this.getLog().info((CharSequence)String.format("Successful requests:         %s", resultScanner.getSuccessCount()));
            this.getLog().info((CharSequence)String.format("Failed requests:             %s", resultScanner.getFailureCount()));
            TestFailureDecider decider = new TestFailureDecider(this.ignoreResultFailures, this.errorRateThresholdInPercent, resultScanner);
            decider.runChecks();
            this.getLog().info((CharSequence)String.format("Failures:                    %s%% (%s%% accepted)", decider.getErrorPercentage(), decider.getErrorPercentageThreshold()));
            this.getLog().info((CharSequence)" ");
            if (decider.failBuild()) {
                throw new MojoFailureException(String.format("Failing build because error percentage %s is above accepted threshold %s. JMeter logs are available at: '%s'", this.logsDirectory.getAbsolutePath(), decider.getErrorPercentage(), decider.getErrorPercentageThreshold()));
            }
            if (resultScanner.getTotalCount() == 0 && this.failBuildIfResultFileIsEmpty) {
                throw new MojoFailureException("Failing build because no requests were found in the results file!");
            }
        } else {
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)"Results of Performance Test(s) have not been scanned.");
            this.getLog().info((CharSequence)" ");
        }
    }
}

