/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.download;

import com.lazerycode.selenium.download.DetectProxyConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.MojoFailureException;

public class FileDownloader {
    private static final Logger LOG = Logger.getLogger(FileDownloader.class);
    private int fileDownloadReadTimeout;
    private int fileDownloadConnectTimeout;
    private boolean useSystemProxy = true;
    String downloadDirectory;
    DetectProxyConfig proxyConfig;

    FileDownloader(File downloadedZipFileDirectory, boolean useSystemProxy) throws MojoFailureException {
        this.useSystemProxy = useSystemProxy;
        if (this.useSystemProxy) {
            this.proxyConfig = new DetectProxyConfig();
        }
        this.downloadDirectory = this.localFilePath(downloadedZipFileDirectory);
    }

    public void setReadTimeout(int fileDownloadReadTimeout) {
        this.fileDownloadReadTimeout = fileDownloadReadTimeout;
    }

    public void setConnectTimeout(int fileDownloadConnectTimeout) {
        this.fileDownloadConnectTimeout = fileDownloadConnectTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File attemptToDownload(URL fileLocation) throws URISyntaxException, IOException {
        String filename = FilenameUtils.getName((String)fileLocation.getFile());
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(this.fileDownloadReadTimeout).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.fileDownloadConnectTimeout).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultSocketConfig(socketConfig).setDefaultRequestConfig(requestConfig).disableContentCompression();
        if (this.useSystemProxy && this.proxyConfig.isProxyAvailable()) {
            LOG.info((Object)("Using http proxy: " + this.proxyConfig.getHost() + ":" + this.proxyConfig.getPort()));
            httpClientBuilder.setProxy(new HttpHost(this.proxyConfig.getHost(), this.proxyConfig.getPort()));
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        LOG.info((Object)("Downloading  '" + filename + "'..."));
        CloseableHttpResponse fileDownloadResponse = httpClient.execute((HttpUriRequest)new HttpGet(fileLocation.toURI()));
        HttpEntity remoteFileStream = fileDownloadResponse.getEntity();
        File fileToDownload = new File(this.downloadDirectory + File.separator + filename);
        try {
            FileUtils.copyInputStreamToFile((InputStream)remoteFileStream.getContent(), (File)fileToDownload);
        }
        catch (IOException ex) {
            LOG.error((Object)("Problem downloading '" + filename + "'... " + ex.getCause().getLocalizedMessage()));
            fileToDownload = null;
        }
        finally {
            fileDownloadResponse.close();
        }
        return fileToDownload;
    }

    private String localFilePath(File downloadDirectory) throws MojoFailureException {
        if (downloadDirectory.exists()) {
            if (downloadDirectory.isDirectory()) {
                return downloadDirectory.getAbsolutePath();
            }
            throw new MojoFailureException("'" + downloadDirectory.getAbsolutePath() + "' is not a directory!");
        }
        if (downloadDirectory.mkdirs()) {
            return downloadDirectory.getAbsolutePath();
        }
        throw new MojoFailureException("Unable to create download directory!");
    }
}

