/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium;

import com.lazerycode.selenium.MavenLoggerLog4jBridge;
import com.lazerycode.selenium.download.DownloadHandler;
import com.lazerycode.selenium.repository.DriverContext;
import com.lazerycode.selenium.repository.DriverDetails;
import com.lazerycode.selenium.repository.DriverMap;
import com.lazerycode.selenium.repository.FileRepository;
import com.lazerycode.selenium.repository.OperatingSystem;
import com.lazerycode.selenium.repository.SystemArchitecture;
import com.lazerycode.selenium.repository.XMLParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.xml.sax.SAXException;

@Mojo(name="selenium", defaultPhase=LifecyclePhase.TEST_COMPILE)
public class SeleniumServerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}/selenium_standalone")
    protected File rootStandaloneServerDirectory;
    @Parameter(defaultValue="${project.basedir}/selenium_standalone_zips")
    protected File downloadedZipFileDirectory;
    @Parameter
    protected String customRepositoryMap;
    @Parameter(defaultValue="true")
    protected boolean onlyGetDriversForHostOperatingSystem;
    @Parameter
    protected Map<String, String> operatingSystems;
    @Parameter(defaultValue="false")
    protected boolean thirtyTwoBitBinaries;
    @Parameter(defaultValue="false")
    protected boolean sixtyFourBitBinaries;
    @Parameter(defaultValue="false")
    protected boolean armBinaries;
    @Parameter(defaultValue="true")
    protected boolean onlyGetLatestVersions;
    @Parameter
    protected Map<String, String> getSpecificExecutableVersions;
    @Parameter(defaultValue="false")
    protected boolean throwExceptionIfSpecifiedVersionIsNotFound;
    @Parameter(defaultValue="1")
    protected int fileDownloadRetryAttempts;
    @Parameter(defaultValue="15000")
    protected int fileDownloadConnectTimeout;
    @Parameter(defaultValue="15000")
    protected int fileDownloadReadTimeout;
    @Parameter(defaultValue="true")
    protected boolean useSystemProxy;
    @Parameter(defaultValue="false")
    protected boolean overwriteFilesThatExist;
    @Parameter(defaultValue="true")
    protected boolean checkFileHashes;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Component
    private ResourceManager locator;
    protected InputStream xmlRepositoryMap = null;
    private static final Logger LOG = Logger.getLogger(SeleniumServerMojo.class);

    public void execute() throws MojoExecutionException, MojoFailureException {
        DriverMap driverRepository;
        BasicConfigurator.configure((Appender)new MavenLoggerLog4jBridge(this.getLog()));
        LOG.info((Object)" ");
        LOG.info((Object)"--------------------------------------------------------");
        LOG.info((Object)" DOWNLOADING SELENIUM STAND-ALONE EXECUTABLE BINARIES...");
        LOG.info((Object)"--------------------------------------------------------");
        LOG.info((Object)" ");
        this.setRepositoryMapFile();
        if (this.fileDownloadRetryAttempts < 1) {
            LOG.warn((Object)"Invalid number of retry attempts specified, defaulting to '1'...");
            this.fileDownloadRetryAttempts = 1;
        }
        HashMap selectedOperatingSystems = new HashMap();
        LOG.info((Object)("Only get drivers for current Operating System: " + this.onlyGetDriversForHostOperatingSystem));
        HashSet<OperatingSystem> osTypeList = new HashSet();
        if (this.onlyGetDriversForHostOperatingSystem || null == this.operatingSystems || this.operatingSystems.size() < 1) {
            LOG.info((Object)"Getting drivers for current operating system only.");
            osTypeList = OperatingSystem.getCurrentOperatingSystemAsAHashSet();
        } else {
            for (Map.Entry<String, String> os : this.operatingSystems.entrySet()) {
                if (!os.getValue().toLowerCase().equals("true")) continue;
                osTypeList.add(OperatingSystem.getOperatingSystem(os.getKey()));
            }
        }
        if (!(this.thirtyTwoBitBinaries || this.sixtyFourBitBinaries || this.armBinaries)) {
            if (SystemArchitecture.getCurrentSystemArcitecture().equals((Object)SystemArchitecture.ARCHITECTURE_64_BIT)) {
                this.sixtyFourBitBinaries = true;
            } else if (SystemArchitecture.getCurrentSystemArcitecture().equals((Object)SystemArchitecture.ARCHITECTURE_ARM)) {
                this.armBinaries = true;
            } else {
                this.thirtyTwoBitBinaries = true;
            }
        }
        XMLParser parser = new XMLParser(this.xmlRepositoryMap, osTypeList, this.getSpecificExecutableVersions, this.thirtyTwoBitBinaries, this.sixtyFourBitBinaries);
        try {
            DownloadHandler standaloneExecutableDownloader = new DownloadHandler(this.rootStandaloneServerDirectory, this.downloadedZipFileDirectory, this.fileDownloadRetryAttempts, this.fileDownloadConnectTimeout, this.fileDownloadReadTimeout, FileRepository.buildDownloadableFileRepository(parser.getAllNodesInScope(), this.thirtyTwoBitBinaries, this.sixtyFourBitBinaries, this.armBinaries), this.overwriteFilesThatExist, this.checkFileHashes, this.useSystemProxy, this.onlyGetLatestVersions);
            driverRepository = standaloneExecutableDownloader.ensureStandaloneExecutableFilesExist();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to download all of the standalone executables: " + e.getLocalizedMessage());
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Invalid URI detected: " + e.getLocalizedMessage());
        }
        catch (JAXBException | XPathExpressionException rethrow) {
            throw new MojoExecutionException(rethrow.getMessage());
        }
        this.setSystemProperties(driverRepository);
        LOG.info((Object)" ");
        LOG.info((Object)"--------------------------------------------------------");
        LOG.info((Object)"SELENIUM STAND-ALONE EXECUTABLE DOWNLOADS COMPLETE");
        LOG.info((Object)"--------------------------------------------------------");
        LOG.info((Object)" ");
    }

    protected void setSystemProperties(DriverMap driverRepository) {
        ArrayList<DriverContext> driverContextsForCurrentOperatingSystem = driverRepository.getDriverContextsForCurrentOperatingSystem();
        if (driverContextsForCurrentOperatingSystem.size() == 0) {
            LOG.warn((Object)"No driver contexts detected for the current operating system, no maven properties set!");
        }
        for (DriverContext driverContext : driverContextsForCurrentOperatingSystem) {
            DriverDetails driverDetails = driverRepository.getDetailsForLatestVersionOfDriverContext(driverContext);
            LOG.info((Object)("Setting maven property - ${" + driverContext.getBinaryTypeForContext().getDriverSystemProperty() + "} = " + driverDetails.extractedLocation));
            this.project.getProperties().setProperty(driverContext.getBinaryTypeForContext().getDriverSystemProperty(), driverDetails.extractedLocation);
        }
    }

    private File getRepositoryMapFile(String customRepositoryMap) {
        File repositoryMap;
        try {
            repositoryMap = this.locator.getResourceAsFile(customRepositoryMap);
        }
        catch (FileResourceCreationException | ResourceNotFoundException e) {
            LOG.info((Object)"Unable to find the specified custom repository map in dependencies, attempting to use value as a file path...");
            LOG.info((Object)" ");
            repositoryMap = new File(customRepositoryMap);
        }
        return repositoryMap;
    }

    private void setRepositoryMapFile() throws MojoExecutionException {
        if (this.customRepositoryMap != null && !this.customRepositoryMap.isEmpty()) {
            File repositoryMap = this.getRepositoryMapFile(this.customRepositoryMap);
            if (repositoryMap.exists()) {
                this.checkRepositoryMapIsValid(repositoryMap);
                try {
                    this.xmlRepositoryMap = repositoryMap.toURI().toURL().openStream();
                }
                catch (IOException ioe) {
                    throw new MojoExecutionException(ioe.getLocalizedMessage());
                }
            } else {
                throw new MojoExecutionException("Repository map '" + repositoryMap.getAbsolutePath() + "' does not exist");
            }
        }
        if (this.xmlRepositoryMap == null) {
            this.xmlRepositoryMap = ((Object)((Object)this)).getClass().getResourceAsStream("/RepositoryMap.xml");
        }
    }

    protected void checkRepositoryMapIsValid(File repositoryMap) throws MojoExecutionException {
        URL schemaFile = ((Object)((Object)this)).getClass().getResource("/RepositoryMap.xsd");
        StreamSource xmlFile = new StreamSource(repositoryMap);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = schemaFactory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            validator.validate(xmlFile);
            LOG.info((Object)("Repository map '" + xmlFile.getSystemId() + "' is valid"));
            LOG.info((Object)" ");
        }
        catch (IOException | SAXException ex) {
            throw new MojoExecutionException(repositoryMap.getName() + " is not valid: " + ex.getLocalizedMessage());
        }
    }
}

