/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.extract;

import com.lazerycode.selenium.exceptions.ExpectedFileNotFoundException;
import com.lazerycode.selenium.extract.CompressedFile;
import com.lazerycode.selenium.extract.DownloadableFileType;
import com.lazerycode.selenium.repository.BinaryType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.MojoFailureException;

public class FileExtractor {
    private static final Logger LOG = Logger.getLogger(FileExtractor.class);
    private final boolean overwriteFilesThatExist;

    public FileExtractor(boolean overwriteFilesThatExist) {
        this.overwriteFilesThatExist = overwriteFilesThatExist;
    }

    public String extractFileFromArchive(File downloadedCompressedFile, String extractedToFilePath, BinaryType possibleFilenames) throws IOException, IllegalArgumentException, MojoFailureException {
        DownloadableFileType fileType = DownloadableFileType.valueOf(FilenameUtils.getExtension((String)downloadedCompressedFile.getName()).toUpperCase());
        LOG.debug((Object)("Determined archive type: " + (Object)((Object)fileType)));
        LOG.debug((Object)("Overwrite files that exist: " + this.overwriteFilesThatExist));
        switch (fileType) {
            case GZ: 
            case BZ2: {
                CompressedFile compressedFile = new CompressedFile(downloadedCompressedFile);
                if (null != compressedFile.getArchiveType() && compressedFile.getArchiveType().equals((Object)DownloadableFileType.TAR)) {
                    return this.untarFile(compressedFile.getInputStream(), extractedToFilePath, possibleFilenames);
                }
                return this.copyFileToDisk(compressedFile.getInputStream(), extractedToFilePath, compressedFile.getDecompressedFilename());
            }
            case ZIP: {
                return this.unzipFile(downloadedCompressedFile, extractedToFilePath, possibleFilenames);
            }
            case EXE: {
                if (!possibleFilenames.getBinaryFilenames().contains(downloadedCompressedFile.getName())) break;
                return this.copyFileToDisk(new FileInputStream(downloadedCompressedFile), extractedToFilePath, downloadedCompressedFile.getName());
            }
        }
        throw new IllegalArgumentException("." + (Object)((Object)fileType) + " is an unsupported archive type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String unzipFile(File downloadedCompressedFile, String extractedToFilePath, BinaryType possibleFilenames) throws IOException, ExpectedFileNotFoundException {
        LOG.debug((Object)"Attempting to extract binary from .zip file...");
        ArrayList<String> filenamesWeAreSearchingFor = possibleFilenames.getBinaryFilenames();
        try (ZipFile zip = new ZipFile(downloadedCompressedFile);){
            Enumeration zipFile = zip.getEntries();
            while (zipFile.hasMoreElements()) {
                ZipArchiveEntry zipFileEntry = (ZipArchiveEntry)zipFile.nextElement();
                for (String aFilenameWeAreSearchingFor : filenamesWeAreSearchingFor) {
                    if (!zipFileEntry.getName().endsWith(aFilenameWeAreSearchingFor)) continue;
                    LOG.debug((Object)("Found: " + zipFileEntry.getName()));
                    String string = this.copyFileToDisk(zip.getInputStream(zipFileEntry), extractedToFilePath, aFilenameWeAreSearchingFor);
                    return string;
                }
            }
        }
        throw new ExpectedFileNotFoundException("Unable to find any expected files for " + possibleFilenames.getBinaryTypeAsString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String untarFile(InputStream compressedFileInputStream, String extractedToFilePath, BinaryType possibleFilenames) throws IOException, ExpectedFileNotFoundException {
        block7: {
            LOG.debug((Object)"Attempting to extract binary from a .tar file...");
            ArrayList<String> filenamesWeAreSearchingFor = possibleFilenames.getBinaryFilenames();
            TarArchiveInputStream archiveInputStream = new TarArchiveInputStream(compressedFileInputStream);
            block4: while (true) {
                ArchiveEntry currentFile = archiveInputStream.getNextEntry();
                if (currentFile != null) {
                    Iterator<String> iterator = filenamesWeAreSearchingFor.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block4;
                        String aFilenameWeAreSearchingFor = iterator.next();
                        if (!currentFile.getName().endsWith(aFilenameWeAreSearchingFor)) continue;
                        LOG.debug((Object)("Found: " + currentFile.getName()));
                        String string = this.copyFileToDisk((InputStream)archiveInputStream, extractedToFilePath, aFilenameWeAreSearchingFor);
                        return string;
                    }
                }
                break block7;
                break;
            }
            finally {
                compressedFileInputStream.close();
            }
        }
        throw new ExpectedFileNotFoundException("Unable to find any expected filed for " + possibleFilenames.getBinaryTypeAsString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyFileToDisk(InputStream inputStream, String pathToExtractTo, String filename) throws IOException {
        File[] existingFiles;
        if (!this.overwriteFilesThatExist && null != (existingFiles = new File(pathToExtractTo).listFiles()) && existingFiles.length > 0) {
            for (File existingFile : existingFiles) {
                String existingFilename = existingFile.getName();
                if (!existingFilename.equals(filename)) continue;
                LOG.info((Object)("Binary '" + existingFilename + "' exists: true"));
                LOG.info((Object)("Using existing '" + existingFilename + " 'binary."));
                return existingFile.getAbsolutePath();
            }
        }
        File outputFile = new File(pathToExtractTo, filename);
        try {
            if (!(outputFile.exists() || outputFile.getParentFile().mkdirs() || outputFile.createNewFile())) {
                throw new IOException("Unable to create " + outputFile.getAbsolutePath());
            }
            LOG.info((Object)("Extracting binary '" + filename + "'..."));
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)outputFile);
            LOG.info((Object)("Binary copied to " + outputFile.getAbsolutePath()));
            if (!outputFile.setExecutable(true) && !outputFile.canExecute()) {
                LOG.warn((Object)("Unable to set executable flag (+x) on " + filename));
            }
        }
        finally {
            inputStream.close();
        }
        return outputFile.getAbsolutePath();
    }
}

