/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.repository;

import com.lazerycode.selenium.repository.DriverContext;
import com.lazerycode.selenium.repository.DriverDetails;
import com.lazerycode.selenium.repository.OperatingSystem;
import com.lazerycode.selenium.repository.SystemArchitecture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

public class DriverMap {
    protected HashMap<DriverContext, TreeMap<String, DriverDetails>> repository = new HashMap();

    public TreeMap<String, DriverDetails> getMapForDriverContext(DriverContext driverContext) {
        if (!this.repository.containsKey(driverContext)) {
            this.repository.put(driverContext, new TreeMap());
        }
        return this.repository.get(driverContext);
    }

    public DriverDetails getDetailsForVersionOfDriverContext(DriverContext driverContext, String version) throws IllegalArgumentException {
        if (!this.repository.containsKey(driverContext)) {
            throw new IllegalArgumentException("Driver context not found in driver repository");
        }
        TreeMap<String, DriverDetails> driverVersions = this.repository.get(driverContext);
        DriverDetails detailsToReturn = driverVersions.get(driverVersions.lastKey());
        if (detailsToReturn.hashCode() == 0) {
            throw new NoSuchElementException("No driver version " + version + " exists for the context " + driverContext.toString());
        }
        return detailsToReturn;
    }

    public DriverDetails getDetailsForLatestVersionOfDriverContext(DriverContext driverContext) {
        if (!this.repository.containsKey(driverContext)) {
            throw new IllegalArgumentException("Driver context not found in driver repository");
        }
        TreeMap<String, DriverDetails> driverVersions = this.repository.get(driverContext);
        return driverVersions.get(driverVersions.lastKey());
    }

    public Set<DriverContext> getKeys() {
        return this.repository.keySet();
    }

    public Set<String> getAvailableVersionsForDriverContext(DriverContext driverContext) {
        return this.repository.get(driverContext).keySet();
    }

    public ArrayList<DriverContext> getDriverContextsForOperatingSystem(OperatingSystem operatingSystem, SystemArchitecture systemArchitecture) {
        ArrayList<DriverContext> matchingContexts = new ArrayList<DriverContext>();
        for (DriverContext driverContext : this.repository.keySet()) {
            if (!driverContext.getOperatingSystem().equals((Object)operatingSystem) || !driverContext.getSystemArchitecture().equals((Object)systemArchitecture)) continue;
            matchingContexts.add(driverContext);
        }
        return matchingContexts;
    }

    public ArrayList<DriverContext> getDriverContextsForCurrentOperatingSystem() {
        OperatingSystem operatingSystem = OperatingSystem.getCurrentOperatingSystem();
        SystemArchitecture systemArchitecture = SystemArchitecture.getCurrentSystemArcitecture();
        return this.getDriverContextsForOperatingSystem(operatingSystem, systemArchitecture);
    }
}

