/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.download;

import com.lazerycode.selenium.download.FileDownloader;
import com.lazerycode.selenium.download.FileHashChecker;
import com.lazerycode.selenium.extract.FileExtractor;
import com.lazerycode.selenium.hash.HashType;
import com.lazerycode.selenium.repository.DriverContext;
import com.lazerycode.selenium.repository.DriverDetails;
import com.lazerycode.selenium.repository.DriverMap;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class DownloadHandler {
    private static final Logger LOG = Logger.getLogger(DownloadHandler.class);
    private final DriverMap filesToDownload;
    private final File rootStandaloneServerDirectory;
    private final File downloadedZipFileDirectory;
    protected final int fileDownloadRetryAttempts;
    private boolean overwriteFilesThatExist = false;
    private boolean checkFileHash = true;
    private boolean onlyGetLatestVersions = true;
    private FileDownloader fileDownloader;

    public DownloadHandler(File rootStandaloneServerDirectory, File downloadedZipFileDirectory, int fileDownloadRetryAttempts, int fileDownloadConnectTimeout, int fileDownloadReadTimeout, DriverMap filesToDownload, boolean overwriteFilesThatExist, boolean checkFileHash, boolean useSystemProxy, boolean onlyGetLatestVersions) throws MojoFailureException {
        this.rootStandaloneServerDirectory = rootStandaloneServerDirectory;
        this.downloadedZipFileDirectory = downloadedZipFileDirectory;
        this.filesToDownload = filesToDownload;
        this.fileDownloadRetryAttempts = fileDownloadRetryAttempts;
        this.overwriteFilesThatExist = overwriteFilesThatExist;
        this.checkFileHash = checkFileHash;
        this.onlyGetLatestVersions = onlyGetLatestVersions;
        this.fileDownloader = new FileDownloader(downloadedZipFileDirectory, useSystemProxy);
        this.fileDownloader.setReadTimeout(fileDownloadReadTimeout);
        this.fileDownloader.setConnectTimeout(fileDownloadConnectTimeout);
    }

    private boolean checkFileHash(File fileToCheck, String hash, HashType hashType) throws IOException, MojoExecutionException {
        FileHashChecker fileHashChecker = new FileHashChecker(fileToCheck);
        fileHashChecker.setExpectedHash(hash, hashType);
        return fileHashChecker.fileIsValid();
    }

    protected File downloadFile(DriverDetails driverDetails, boolean shouldWeCheckFileHash) throws MojoExecutionException, IOException, URISyntaxException {
        URL remoteFileLocation = driverDetails.fileLocation;
        String filename = FilenameUtils.getName((String)remoteFileLocation.getFile());
        for (int retryAttempts = 1; retryAttempts <= this.fileDownloadRetryAttempts; ++retryAttempts) {
            File downloadedFile = this.fileDownloader.attemptToDownload(remoteFileLocation);
            if (null != downloadedFile) {
                if (!shouldWeCheckFileHash || this.checkFileHash(downloadedFile, driverDetails.hash, driverDetails.hashType)) {
                    LOG.info((Object)("Archive file '" + downloadedFile.getName() + "' is valid : true"));
                    return downloadedFile;
                }
                LOG.info((Object)("Archive file '" + downloadedFile.getName() + "' is valid : false"));
            }
            LOG.info((Object)("Problem downloading '" + filename + "'... "));
            if (retryAttempts >= this.fileDownloadRetryAttempts) continue;
            LOG.info((Object)("Retry attempt " + retryAttempts + " for '" + filename + "'"));
        }
        throw new MojoExecutionException("Unable to successfully download '" + filename + "'!");
    }

    public DriverMap ensureStandaloneExecutableFilesExist() throws MojoFailureException, MojoExecutionException, IOException, URISyntaxException {
        LOG.info((Object)("Archives will be downloaded to '" + this.downloadedZipFileDirectory.getAbsolutePath() + "'"));
        LOG.info((Object)("Standalone executable files will be extracted to '" + this.rootStandaloneServerDirectory + "'"));
        LOG.info((Object)" ");
        LOG.info((Object)"Preparing to download Selenium Standalone Executable Binaries...");
        for (DriverContext driverContext : this.filesToDownload.getKeys()) {
            if (this.onlyGetLatestVersions) {
                DriverDetails driverDetails = this.filesToDownload.getDetailsForLatestVersionOfDriverContext(driverContext);
                this.downloadAndExtractExecutableFiles(driverContext, driverDetails);
                continue;
            }
            for (String version : this.filesToDownload.getAvailableVersionsForDriverContext(driverContext)) {
                DriverDetails driverDetails = this.filesToDownload.getDetailsForVersionOfDriverContext(driverContext, version);
                this.downloadAndExtractExecutableFiles(driverContext, driverDetails);
            }
        }
        return this.filesToDownload;
    }

    private void downloadAndExtractExecutableFiles(DriverContext driverContext, DriverDetails driverDetails) throws IOException, MojoExecutionException, URISyntaxException, MojoFailureException {
        String localZipFileAbsolutePath = this.downloadedZipFileDirectory + File.separator + FilenameUtils.getName((String)driverDetails.fileLocation.getFile());
        File localZipFile = new File(localZipFileAbsolutePath);
        boolean fileNeedsToBeDownloaded = true;
        if (localZipFile.exists() && this.checkFileHash) {
            fileNeedsToBeDownloaded = !this.checkFileHash(localZipFile, driverDetails.hash, driverDetails.hashType);
        }
        if (fileNeedsToBeDownloaded) {
            localZipFile = this.downloadFile(driverDetails, this.checkFileHash);
        }
        String extractedFileLocation = this.rootStandaloneServerDirectory.getAbsolutePath() + File.separator + driverContext.buildExtractionPathFromDriverContext();
        FileExtractor fileExtractor = new FileExtractor(this.overwriteFilesThatExist);
        driverDetails.extractedLocation = fileExtractor.extractFileFromArchive(localZipFile, extractedFileLocation, driverContext.getBinaryTypeForContext());
    }
}

