/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.extract;

import com.lazerycode.selenium.exceptions.InvalidFileTypeException;
import com.lazerycode.selenium.extract.DownloadableFileType;
import com.lazerycode.selenium.extract.FileExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

class CompressedFile {
    private static final Logger LOG = Logger.getLogger(FileExtractor.class);
    private File compressedFile;
    private String decompressedFilename;
    private DownloadableFileType filetype = null;

    CompressedFile(File compressedFile) throws InvalidFileTypeException {
        this.filetype = DownloadableFileType.valueOf(FilenameUtils.getExtension((String)compressedFile.getName()).toUpperCase());
        if (this.filetype != DownloadableFileType.GZ && this.filetype != DownloadableFileType.BZ2) {
            throw new InvalidFileTypeException(compressedFile.getName() + " is an archive, not a known compressed file type");
        }
        this.compressedFile = compressedFile;
        this.decompressedFilename = FilenameUtils.getBaseName((String)compressedFile.getName());
    }

    String getDecompressedFilename() {
        return this.decompressedFilename;
    }

    InputStream getInputStream() throws IOException {
        switch (this.filetype) {
            case GZ: {
                LOG.debug((Object)"Decompressing .gz file");
                return new GzipCompressorInputStream((InputStream)new FileInputStream(this.compressedFile));
            }
            case BZ2: {
                LOG.debug((Object)"Decompressing .bz2 file");
                return new BZip2CompressorInputStream((InputStream)new FileInputStream(this.compressedFile));
            }
        }
        return null;
    }

    DownloadableFileType getArchiveType() {
        try {
            return DownloadableFileType.valueOf(FilenameUtils.getExtension((String)this.decompressedFilename).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.debug((Object)"Not a recognised Archive type");
            return null;
        }
    }
}

