/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.repository;

import com.lazerycode.selenium.repository.OperatingSystem;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLParser {
    private static XPathFactory factory = XPathFactory.newInstance();
    private static XPath xpath = factory.newXPath();
    final InputSource repositoryMap;
    final Set<OperatingSystem> operatingSystems;
    final Map<String, String> driverVersions;
    final boolean thirtyTwoBit;
    final boolean sixtyFourBit;

    public XMLParser(InputStream repositoryMap, Set<OperatingSystem> operatingSystems, Map<String, String> driverVersions, boolean thirtyTwoBit, boolean sixtyFourBit) {
        this.repositoryMap = new InputSource(repositoryMap);
        this.operatingSystems = operatingSystems;
        this.driverVersions = driverVersions;
        this.thirtyTwoBit = thirtyTwoBit;
        this.sixtyFourBit = sixtyFourBit;
    }

    protected String operatingSystemSelector() {
        if (this.operatingSystems.size() == 0) {
            return "";
        }
        StringBuilder operatingSystemsSelector = new StringBuilder();
        operatingSystemsSelector.append("[");
        Iterator<OperatingSystem> iterator = this.operatingSystems.iterator();
        while (iterator.hasNext()) {
            String operatingSystem = iterator.next().toString().toLowerCase();
            operatingSystemsSelector.append("parent::").append(operatingSystem);
            if (!iterator.hasNext()) continue;
            operatingSystemsSelector.append("|");
        }
        operatingSystemsSelector.append("]");
        return operatingSystemsSelector.toString();
    }

    protected String driverVersionSelector() {
        if (null == this.driverVersions || this.driverVersions.size() == 0) {
            return "";
        }
        StringBuilder versionSelector = new StringBuilder();
        versionSelector.append("[");
        Iterator<Map.Entry<String, String>> it = this.driverVersions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> specificDriver = it.next();
            versionSelector.append("(parent::*[@id='");
            versionSelector.append((Object)specificDriver.getKey());
            versionSelector.append("'] and @id='");
            versionSelector.append((Object)specificDriver.getValue());
            versionSelector.append("')");
            if (!it.hasNext()) continue;
            versionSelector.append(" or ");
        }
        versionSelector.append("]");
        return versionSelector.toString();
    }

    protected String calculateBitrate() {
        if (this.thirtyTwoBit && this.sixtyFourBit) {
            return "[@thirtytwobit='true' or @sixtyfourbit='true']";
        }
        if (this.thirtyTwoBit) {
            return "[@thirtytwobit='true']";
        }
        if (this.sixtyFourBit) {
            return "[@sixtyfourbit='true']";
        }
        return "";
    }

    public NodeList getAllNodesInScope() throws XPathExpressionException {
        String nodeLocator = "//driver" + this.operatingSystemSelector() + "/version" + this.driverVersionSelector() + "/bitrate" + this.calculateBitrate();
        XPathExpression expression = xpath.compile(nodeLocator);
        return (NodeList)expression.evaluate(this.repositoryMap, XPathConstants.NODESET);
    }
}

