/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.download;

import com.lazerycode.selenium.hash.HashType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.MojoExecutionException;

public class FileHashChecker {
    private static final Logger LOG = Logger.getLogger(FileHashChecker.class);
    private File fileToCheck;
    private HashType hashType;
    private String expectedHash;

    FileHashChecker(File fileToCheck) {
        this.fileToCheck = fileToCheck;
    }

    public void setExpectedHash(String expectedHash, HashType hashType) {
        this.expectedHash = expectedHash;
        this.hashType = hashType;
    }

    public boolean fileIsValid() throws IOException, MojoExecutionException {
        String actualFileHash;
        if (!this.fileToCheck.exists()) {
            return false;
        }
        FileInputStream fileToHashCheck = new FileInputStream(this.fileToCheck);
        switch (this.hashType) {
            case MD5: {
                actualFileHash = DigestUtils.md5Hex((InputStream)fileToHashCheck);
                break;
            }
            case SHA256: {
                actualFileHash = DigestUtils.sha256Hex((InputStream)fileToHashCheck);
                break;
            }
            case SHA512: {
                actualFileHash = DigestUtils.sha512Hex((InputStream)fileToHashCheck);
                break;
            }
            default: {
                actualFileHash = DigestUtils.shaHex((InputStream)fileToHashCheck);
            }
        }
        fileToHashCheck.close();
        if (actualFileHash.equals(this.expectedHash)) {
            return true;
        }
        LOG.error((Object)("File : '" + this.fileToCheck.getName() + "'."));
        LOG.error((Object)("Expected file hash : '" + this.expectedHash + "'."));
        LOG.error((Object)("Actual file hash   : '" + actualFileHash + "'."));
        return false;
    }
}

