/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.repository;

import com.lazerycode.selenium.repository.BinaryType;
import com.lazerycode.selenium.repository.OperatingSystem;
import com.lazerycode.selenium.repository.SystemArchitecture;
import java.io.File;

public class DriverContext {
    private final BinaryType driverType;
    private final SystemArchitecture systemArchitecture;
    private final OperatingSystem operatingSystem;

    public SystemArchitecture getSystemArchitecture() {
        return this.systemArchitecture;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    private DriverContext(BinaryType driverType, OperatingSystem operatingSystem, SystemArchitecture systemArchitecture) {
        this.operatingSystem = operatingSystem;
        this.driverType = driverType;
        this.systemArchitecture = systemArchitecture;
    }

    private DriverContext(String driverType, String operatingSystem, SystemArchitecture systemArchitecture) {
        this.operatingSystem = OperatingSystem.valueOf(operatingSystem.toUpperCase());
        this.driverType = BinaryType.valueOf(driverType.toUpperCase());
        this.systemArchitecture = systemArchitecture;
    }

    public static DriverContext binaryDataFor(OperatingSystem osName, BinaryType browserType, SystemArchitecture architecture) {
        return new DriverContext(browserType, osName, architecture);
    }

    public static DriverContext binaryDataFor(String osName, String browserType, SystemArchitecture architecture) {
        return new DriverContext(browserType, osName, architecture);
    }

    public String buildExtractionPathFromDriverContext() {
        return this.operatingSystem.toString().toLowerCase() + File.separator + this.driverType.getBinaryTypeAsString() + File.separator + this.systemArchitecture.getSystemArchitectureType() + File.separator;
    }

    public BinaryType getBinaryTypeForContext() {
        return this.driverType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriverContext that = (DriverContext)o;
        if (this.driverType != that.driverType) {
            return false;
        }
        if (this.operatingSystem != that.operatingSystem) {
            return false;
        }
        return this.systemArchitecture == that.systemArchitecture;
    }

    public int hashCode() {
        int result = this.driverType.hashCode();
        result = 31 * result + this.systemArchitecture.hashCode();
        result = 31 * result + this.operatingSystem.hashCode();
        return result;
    }

    public String toString() {
        return this.operatingSystem.getOperatingSystemType() + " - " + this.driverType.toString().toLowerCase() + " - " + this.systemArchitecture.getSystemArchitectureType();
    }
}

