/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.repository;

import com.lazerycode.selenium.repository.DriverContext;
import com.lazerycode.selenium.repository.DriverDetails;
import com.lazerycode.selenium.repository.DriverMap;
import com.lazerycode.selenium.repository.SystemArchitecture;
import com.lazerycode.selenium.repository.unmarshallingEventHandler;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileRepository {
    public static DriverMap buildDownloadableFileRepository(NodeList nodesFound, boolean useThirtyTwoBitBinaries, boolean useSixtyFourBitBinaries, boolean useArmBinaries) throws JAXBException {
        DriverMap driverMap = new DriverMap();
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{DriverDetails.class}).createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)new unmarshallingEventHandler());
        for (int nodeNumber = 0; nodeNumber < nodesFound.getLength(); ++nodeNumber) {
            Node node = nodesFound.item(nodeNumber);
            String operatingSystem = node.getParentNode().getParentNode().getParentNode().getNodeName();
            String driver = node.getParentNode().getParentNode().getAttributes().getNamedItem("id").getNodeValue();
            String version = node.getParentNode().getAttributes().getNamedItem("id").getNodeValue();
            boolean thisIs64Bit = false;
            boolean thisIs32Bit = false;
            boolean thisIsArm = false;
            if (useThirtyTwoBitBinaries && node.getAttributes().getNamedItem("thirtytwobit") != null && Boolean.valueOf(node.getAttributes().getNamedItem("thirtytwobit").getNodeValue()).booleanValue()) {
                thisIs32Bit = true;
            }
            if (useSixtyFourBitBinaries && node.getAttributes().getNamedItem("sixtyfourbit") != null && Boolean.valueOf(node.getAttributes().getNamedItem("sixtyfourbit").getNodeValue()).booleanValue()) {
                thisIs64Bit = true;
            }
            if (useArmBinaries && node.getAttributes().getNamedItem("arm") != null && Boolean.valueOf(node.getAttributes().getNamedItem("arm").getNodeValue()).booleanValue()) {
                thisIsArm = true;
            }
            DriverDetails driverDetails = (DriverDetails)unmarshaller.unmarshal(node, DriverDetails.class).getValue();
            if (thisIs32Bit) {
                driverMap.getMapForDriverContext(DriverContext.binaryDataFor(operatingSystem, driver, SystemArchitecture.ARCHITECTURE_32_BIT)).put(version, driverDetails);
            }
            if (thisIs64Bit) {
                driverMap.getMapForDriverContext(DriverContext.binaryDataFor(operatingSystem, driver, SystemArchitecture.ARCHITECTURE_64_BIT)).put(version, driverDetails);
            }
            if (!thisIsArm) continue;
            driverMap.getMapForDriverContext(DriverContext.binaryDataFor(operatingSystem, driver, SystemArchitecture.ARCHITECTURE_ARM)).put(version, driverDetails);
        }
        return driverMap;
    }
}

