/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.repository;

import java.util.Arrays;
import java.util.List;

public enum SystemArchitecture {
    ARCHITECTURE_64_BIT("64bit"),
    ARCHITECTURE_32_BIT("32bit"),
    ARCHITECTURE_ARM("arm");

    private String systemArchitectureName;
    public static final SystemArchitecture defaultSystemArchitecture;
    private static List<String> architecture64bitNames;
    private static List<String> architectureArmNames;

    private SystemArchitecture(String systemArchitectureName) {
        this.systemArchitectureName = systemArchitectureName;
    }

    public String getSystemArchitectureType() {
        return this.systemArchitectureName;
    }

    public static SystemArchitecture getSystemArchitecture(String currentArchitecture) {
        SystemArchitecture result = defaultSystemArchitecture;
        if (architecture64bitNames.contains(currentArchitecture)) {
            result = ARCHITECTURE_64_BIT;
        }
        if (architectureArmNames.contains(currentArchitecture)) {
            result = ARCHITECTURE_ARM;
        }
        return result;
    }

    public static SystemArchitecture getCurrentSystemArcitecture() {
        String currentArchitecture = System.getProperties().getProperty("os.arch");
        return SystemArchitecture.getSystemArchitecture(currentArchitecture);
    }

    static {
        defaultSystemArchitecture = ARCHITECTURE_32_BIT;
        architecture64bitNames = Arrays.asList("amd64", "x86_64");
        architectureArmNames = Arrays.asList("arm", "armv41");
    }
}

