/*
 * Decompiled with CFR 0.152.
 */
package com.leakyabstractions.result.api;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface Result<S, F> {
    public boolean hasSuccess();

    public boolean hasFailure();

    public Optional<S> getSuccess();

    public Optional<F> getFailure();

    public S orElse(S var1);

    public S orElseMap(Function<? super F, ? extends S> var1);

    public Stream<S> streamSuccess();

    public Stream<F> streamFailure();

    public Result<S, F> ifSuccess(Consumer<? super S> var1);

    public Result<S, F> ifFailure(Consumer<? super F> var1);

    public Result<S, F> ifSuccessOrElse(Consumer<? super S> var1, Consumer<? super F> var2);

    public Result<S, F> filter(Predicate<? super S> var1, Function<? super S, ? extends F> var2);

    public Result<S, F> recover(Predicate<? super F> var1, Function<? super F, ? extends S> var2);

    public <S2> Result<S2, F> mapSuccess(Function<? super S, ? extends S2> var1);

    public <F2> Result<S, F2> mapFailure(Function<? super F, ? extends F2> var1);

    public <S2, F2> Result<S2, F2> map(Function<? super S, ? extends S2> var1, Function<? super F, ? extends F2> var2);

    public <S2> Result<S2, F> flatMapSuccess(Function<? super S, ? extends Result<? extends S2, ? extends F>> var1);

    public <F2> Result<S, F2> flatMapFailure(Function<? super F, ? extends Result<? extends S, ? extends F2>> var1);

    public <S2, F2> Result<S2, F2> flatMap(Function<? super S, ? extends Result<? extends S2, ? extends F2>> var1, Function<? super F, ? extends Result<? extends S2, ? extends F2>> var2);

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();
}

