/*
 * Decompiled with CFR 0.152.
 */
package com.leakyabstractions.result.lazy;

import com.leakyabstractions.result.api.Result;
import com.leakyabstractions.result.lazy.LazyConsumer;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

final class LazyResult<S, F>
implements Result<S, F> {
    private final Supplier<Result<S, F>> supplier;
    private final AtomicReference<Result<S, F>> supplied = new AtomicReference();
    private volatile boolean isNotSupplied = true;

    LazyResult(Supplier<Result<S, F>> supplier) {
        this.supplier = supplier;
    }

    public Optional<S> getSuccess() {
        return this.getSupplied().getSuccess();
    }

    public Optional<F> getFailure() {
        return this.getSupplied().getFailure();
    }

    public boolean hasSuccess() {
        return this.getSupplied().hasSuccess();
    }

    public boolean hasFailure() {
        return this.getSupplied().hasFailure();
    }

    public S orElse(S other) {
        return (S)this.getSupplied().orElse(other);
    }

    public S orElseMap(Function<? super F, ? extends S> mapper) {
        return (S)this.getSupplied().orElseMap(mapper);
    }

    public Stream<S> streamSuccess() {
        return this.getSupplied().streamSuccess();
    }

    public Stream<F> streamFailure() {
        return this.getSupplied().streamFailure();
    }

    public Result<S, F> ifSuccess(Consumer<? super S> action) {
        return LazyResult.lazily(this.isNotSupplied && action instanceof LazyConsumer, () -> this.getSupplied().ifSuccess(action));
    }

    public Result<S, F> ifSuccessOrElse(Consumer<? super S> s, Consumer<? super F> f) {
        return LazyResult.lazily(this.isNotSupplied && s instanceof LazyConsumer && f instanceof LazyConsumer, () -> this.getSupplied().ifSuccessOrElse(s, f));
    }

    public Result<S, F> ifFailure(Consumer<? super F> action) {
        return LazyResult.lazily(this.isNotSupplied && action instanceof LazyConsumer, () -> this.getSupplied().ifFailure(action));
    }

    public Result<S, F> filter(Predicate<? super S> isAcceptable, Function<? super S, ? extends F> mapper) {
        return LazyResult.lazily(this.isNotSupplied, () -> this.getSupplied().filter(isAcceptable, mapper));
    }

    public Result<S, F> recover(Predicate<? super F> isRecoverable, Function<? super F, ? extends S> mapper) {
        return LazyResult.lazily(this.isNotSupplied, () -> this.getSupplied().recover(isRecoverable, mapper));
    }

    public <S2, F2> Result<S2, F2> map(Function<? super S, ? extends S2> successMapper, Function<? super F, ? extends F2> failureMapper) {
        return LazyResult.lazily(this.isNotSupplied, () -> this.getSupplied().map(successMapper, failureMapper));
    }

    public <S2> Result<S2, F> mapSuccess(Function<? super S, ? extends S2> mapper) {
        return LazyResult.lazily(this.isNotSupplied, () -> this.getSupplied().mapSuccess(mapper));
    }

    public <F2> Result<S, F2> mapFailure(Function<? super F, ? extends F2> mapper) {
        return LazyResult.lazily(this.isNotSupplied, () -> this.getSupplied().mapFailure(mapper));
    }

    public <S2, F2> Result<S2, F2> flatMap(Function<? super S, ? extends Result<? extends S2, ? extends F2>> successMapper, Function<? super F, ? extends Result<? extends S2, ? extends F2>> failureMapper) {
        return LazyResult.lazily(this.isNotSupplied, () -> this.getSupplied().flatMap(successMapper, failureMapper));
    }

    public <S2> Result<S2, F> flatMapSuccess(Function<? super S, ? extends Result<? extends S2, ? extends F>> mapper) {
        return LazyResult.lazily(this.isNotSupplied, () -> this.getSupplied().flatMapSuccess(mapper));
    }

    public <F2> Result<S, F2> flatMapFailure(Function<? super F, ? extends Result<? extends S, ? extends F2>> mapper) {
        return LazyResult.lazily(this.isNotSupplied, () -> this.getSupplied().flatMapFailure(mapper));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LazyResult)) {
            return false;
        }
        return this.supplier.equals(((LazyResult)obj).supplier);
    }

    public int hashCode() {
        return this.supplier.hashCode();
    }

    public String toString() {
        if (this.isNotSupplied) {
            return "LazyResult[Not supplied]";
        }
        return "LazyResult[" + this.supplied.get() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result<S, F> getSupplied() {
        Result<S, F> result;
        if (this.isNotSupplied) {
            LazyResult lazyResult = this;
            synchronized (lazyResult) {
                Optional.of(this.isNotSupplied).filter(Boolean::booleanValue).ifPresent(this::supply);
            }
        }
        if ((result = this.supplied.get()) == null) {
            throw new NoSuchElementException("The supplied result was null");
        }
        return result;
    }

    private void supply(Boolean ignore) {
        this.isNotSupplied = false;
        this.supplied.set(this.supplier.get());
    }

    private static <S2, F2> Result<S2, F2> lazily(boolean lazily, Supplier<Result<S2, F2>> supplier) {
        return lazily ? new Result<S2, F2>(supplier) : supplier.get();
    }
}

