/*
 * Decompiled with CFR 0.152.
 */
package com.leakyabstractions.result.core;

import com.leakyabstractions.result.api.Result;
import com.leakyabstractions.result.core.Success;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

final class Failure<S, F>
implements Result<S, F> {
    private final F value;

    Failure(F value) {
        this.value = value;
    }

    public Optional<S> getSuccess() {
        return Optional.empty();
    }

    public Optional<F> getFailure() {
        return Optional.of(this.value);
    }

    public boolean hasSuccess() {
        return false;
    }

    public boolean hasFailure() {
        return true;
    }

    public S orElse(S other) {
        return other;
    }

    public S orElseMap(Function<? super F, ? extends S> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        return mapper.apply(this.value);
    }

    public Stream<S> streamSuccess() {
        return Stream.empty();
    }

    public Stream<F> streamFailure() {
        return Stream.of(this.value);
    }

    public Result<S, F> ifSuccess(Consumer<? super S> action) {
        return this;
    }

    public Result<S, F> ifSuccessOrElse(Consumer<? super S> successAction, Consumer<? super F> failureAction) {
        Objects.requireNonNull(failureAction, "failure action");
        failureAction.accept(this.value);
        return this;
    }

    public Result<S, F> ifFailure(Consumer<? super F> action) {
        Objects.requireNonNull(action, "action");
        action.accept(this.value);
        return this;
    }

    public Result<S, F> filter(Predicate<? super S> isAcceptable, Function<? super S, ? extends F> mapper) {
        return this;
    }

    public Result<S, F> recover(Predicate<? super F> isRecoverable, Function<? super F, ? extends S> mapper) {
        Objects.requireNonNull(isRecoverable, "isRecoverable");
        if (!isRecoverable.test(this.value)) {
            return this;
        }
        Objects.requireNonNull(mapper, "mapper");
        S success = Objects.requireNonNull(mapper.apply(this.value), "success value returned by mapper");
        return new Success(success);
    }

    public <S2, F2> Result<S2, F2> map(Function<? super S, ? extends S2> successMapper, Function<? super F, ? extends F2> failureMapper) {
        Objects.requireNonNull(failureMapper, "failure mapper");
        F2 failure = Objects.requireNonNull(failureMapper.apply(this.value), "failure value returned by failure mapper");
        return new Failure<S, F2>(failure);
    }

    public <S2> Result<S2, F> mapSuccess(Function<? super S, ? extends S2> mapper) {
        return this;
    }

    public <F2> Result<S, F2> mapFailure(Function<? super F, ? extends F2> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        F2 failure = Objects.requireNonNull(mapper.apply(this.value), "failure value returned by mapper");
        return new Failure<S, F2>(failure);
    }

    public <S2, F2> Result<S2, F2> flatMap(Function<? super S, ? extends Result<? extends S2, ? extends F2>> successMapper, Function<? super F, ? extends Result<? extends S2, ? extends F2>> failureMapper) {
        Objects.requireNonNull(failureMapper, "failure mapper");
        Result<? extends S2, ? extends F2> result = failureMapper.apply(this.value);
        return Objects.requireNonNull(result, "result object returned by failure mapper");
    }

    public <S2> Result<S2, F> flatMapSuccess(Function<? super S, ? extends Result<? extends S2, ? extends F>> mapper) {
        return this;
    }

    public <F2> Result<S, F2> flatMapFailure(Function<? super F, ? extends Result<? extends S, ? extends F2>> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        Result<? extends S, ? extends F2> result = Objects.requireNonNull(mapper.apply(this.value), "result object returned by mapper");
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Failure)) {
            return false;
        }
        return Objects.equals(this.value, ((Failure)obj).value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return "Failure[" + this.value + "]";
    }
}

