/*
 * Decompiled with CFR 0.152.
 */
package com.leakyabstractions.result.core;

import com.leakyabstractions.result.api.Result;
import com.leakyabstractions.result.core.Failure;
import com.leakyabstractions.result.core.Success;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public class Results {
    private Results() {
    }

    public static <S, F> Result<S, F> success(S success) {
        Objects.requireNonNull(success, "success value");
        return new Success(success);
    }

    public static <S, F> Result<S, F> failure(F failure) {
        Objects.requireNonNull(failure, "failure value");
        return new Failure(failure);
    }

    public static <S, F> Result<S, F> ofNullable(S success, F failure) {
        return success != null ? new Result<S, F>(success) : Results.failure(failure);
    }

    public static <S, F> Result<S, F> ofNullable(S success, Supplier<? extends F> failureSupplier) {
        if (success != null) {
            return new Success(success);
        }
        Objects.requireNonNull(failureSupplier, "failure supplier");
        F failure = failureSupplier.get();
        Objects.requireNonNull(failure, "failure value returned by supplier");
        return new Failure(failure);
    }

    public static <S, F> Result<S, F> ofOptional(Optional<S> success, F failure) {
        Objects.requireNonNull(success, "optional");
        return success.map(Success::new).orElseGet(() -> Results.failure(failure));
    }

    public static <S, F> Result<S, F> ofOptional(Optional<S> success, Supplier<? extends F> failureSupplier) {
        Objects.requireNonNull(success, "optional");
        return success.map(Success::new).orElseGet(() -> {
            Objects.requireNonNull(failureSupplier, "failure supplier");
            Object failure = failureSupplier.get();
            Objects.requireNonNull(failure, "failure value returned by supplier");
            return new Failure(failure);
        });
    }

    public static <S> Result<S, Exception> ofCallable(Callable<? extends S> task) {
        S success;
        Objects.requireNonNull(task, "callable");
        try {
            success = task.call();
        }
        catch (Exception exception) {
            return new Failure(exception);
        }
        Objects.requireNonNull(success, "success value returned by callable");
        return new Success(success);
    }
}

