/*
 * Decompiled with CFR 0.152.
 */
package com.leakyabstractions.result.core;

import com.leakyabstractions.result.api.Result;
import com.leakyabstractions.result.core.Failure;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

final class Success<S, F>
implements Result<S, F> {
    private final S value;

    Success(S value) {
        this.value = value;
    }

    public Optional<S> getSuccess() {
        return Optional.of(this.value);
    }

    public Optional<F> getFailure() {
        return Optional.empty();
    }

    public boolean hasSuccess() {
        return true;
    }

    public boolean hasFailure() {
        return false;
    }

    public S orElse(S other) {
        return this.value;
    }

    public S orElseMap(Function<? super F, ? extends S> mapper) {
        return this.value;
    }

    public Stream<S> streamSuccess() {
        return Stream.of(this.value);
    }

    public Stream<F> streamFailure() {
        return Stream.empty();
    }

    public Result<S, F> ifSuccess(Consumer<? super S> action) {
        Objects.requireNonNull(action, "action");
        action.accept(this.value);
        return this;
    }

    public Result<S, F> ifSuccessOrElse(Consumer<? super S> successAction, Consumer<? super F> failureAction) {
        Objects.requireNonNull(successAction, "success action");
        successAction.accept(this.value);
        return this;
    }

    public Result<S, F> ifFailure(Consumer<? super F> action) {
        return this;
    }

    public Result<S, F> filter(Predicate<? super S> isAcceptable, Function<? super S, ? extends F> mapper) {
        Objects.requireNonNull(isAcceptable, "isAcceptable");
        if (isAcceptable.test(this.value)) {
            return this;
        }
        Objects.requireNonNull(mapper, "mapper");
        F failure = Objects.requireNonNull(mapper.apply(this.value), "failure value returned by mapper");
        return new Failure(failure);
    }

    public Result<S, F> recover(Predicate<? super F> isRecoverable, Function<? super F, ? extends S> mapper) {
        return this;
    }

    public <S2, F2> Result<S2, F2> map(Function<? super S, ? extends S2> successMapper, Function<? super F, ? extends F2> failureMapper) {
        Objects.requireNonNull(successMapper, "success mapper");
        S2 success = Objects.requireNonNull(successMapper.apply(this.value), "success value returned by success mapper");
        return new Success<S2, F>(success);
    }

    public <S2> Result<S2, F> mapSuccess(Function<? super S, ? extends S2> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        S2 success = Objects.requireNonNull(mapper.apply(this.value), "success value returned by mapper");
        return new Success<S2, F>(success);
    }

    public <F2> Result<S, F2> mapFailure(Function<? super F, ? extends F2> mapper) {
        return this;
    }

    public <S2, F2> Result<S2, F2> flatMap(Function<? super S, ? extends Result<? extends S2, ? extends F2>> successMapper, Function<? super F, ? extends Result<? extends S2, ? extends F2>> failureMapper) {
        Objects.requireNonNull(successMapper, "success mapper");
        Result<? extends S2, ? extends F2> result = successMapper.apply(this.value);
        return Objects.requireNonNull(result, "result object returned by success mapper");
    }

    public <S2> Result<S2, F> flatMapSuccess(Function<? super S, ? extends Result<? extends S2, ? extends F>> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        Result<? extends S2, ? extends F> result = Objects.requireNonNull(mapper.apply(this.value), "result object returned by mapper");
        return result;
    }

    public <F2> Result<S, F2> flatMapFailure(Function<? super F, ? extends Result<? extends S, ? extends F2>> mapper) {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Success)) {
            return false;
        }
        return Objects.equals(this.value, ((Success)obj).value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return "Success[" + this.value + "]";
    }
}

