/*
 * Decompiled with CFR 0.152.
 */
package com.leanplum;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.leanplum.IPushProvider;
import com.leanplum.Leanplum;
import com.leanplum.PushProviderType;
import com.leanplum.internal.Log;
import com.leanplum.utils.SharedPreferencesUtil;

abstract class LeanplumCloudMessagingProvider
implements IPushProvider {
    LeanplumCloudMessagingProvider() {
    }

    protected abstract String getSharedPrefsPropertyName();

    @Override
    public void setRegistrationId(String registrationId) {
        if (TextUtils.isEmpty((CharSequence)registrationId)) {
            Log.d((String)"Registration ID for %s is undefined.", (Object[])new Object[]{this.getType()});
            return;
        }
        Log.i((String)"Registering for %s push notifications with ID %s", (Object[])new Object[]{this.getType(), registrationId});
        if (!registrationId.equals(this.getRegistrationId())) {
            this.storeRegistrationId(registrationId);
            Log.d((String)"Sending registration ID to backend.", (Object[])new Object[0]);
            Leanplum.setRegistrationId((PushProviderType)this.getType(), (String)registrationId);
        }
    }

    @VisibleForTesting
    void storeRegistrationId(@NonNull String registrationId) {
        Context context = Leanplum.getContext();
        if (context == null) {
            return;
        }
        Log.d((String)"Saving the registration ID %s in the shared preferences.", (Object[])new Object[]{registrationId});
        SharedPreferencesUtil.setString((Context)context, (String)"__leanplum_push__", (String)this.getSharedPrefsPropertyName(), (String)registrationId);
    }

    @Override
    public String getRegistrationId() {
        Context context = Leanplum.getContext();
        if (context == null) {
            return null;
        }
        return SharedPreferencesUtil.getString((Context)context, (String)"__leanplum_push__", (String)this.getSharedPrefsPropertyName());
    }
}

