/*
 * Decompiled with CFR 0.152.
 */
package com.leanplum;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import androidx.core.app.JobIntentService;
import com.leanplum.internal.Log;

public class LeanplumJobStartReceiver
extends BroadcastReceiver {
    public static final String LP_EXTRA_SERVICE_CLASS = "com.leanplum.service_class";
    public static final String LP_EXTRA_JOB_ID = "com.leanplum.service_job_id";

    public void onReceive(Context context, Intent intent) {
        try {
            if (intent.getExtras() == null) {
                Log.d((String)"Cannot enqueue work on JobIntentService, no extras in intent.", (Object[])new Object[0]);
                return;
            }
            String serviceName = intent.getStringExtra(LP_EXTRA_SERVICE_CLASS);
            int jobId = intent.getIntExtra(LP_EXTRA_JOB_ID, 0);
            Class<?> service = Class.forName(serviceName);
            if (!JobIntentService.class.isAssignableFrom(service)) {
                Log.d((String)"The service provided is not a type of JobIntentService.", (Object[])new Object[0]);
                return;
            }
            intent.setClass(context, service);
            JobIntentService.enqueueWork((Context)context, service, (int)jobId, (Intent)intent);
        }
        catch (Exception e) {
            Log.exception((Throwable)e);
        }
    }
}

