/*
 * Decompiled with CFR 0.152.
 */
package com.leanplum;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.leanplum.internal.CollectionUtil;
import com.leanplum.internal.JsonConverter;
import com.leanplum.internal.Log;
import com.leanplum.utils.BuildUtil;
import com.leanplum.utils.SharedPreferencesUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;

@TargetApi(value=26)
class LeanplumNotificationChannel {
    LeanplumNotificationChannel() {
    }

    static void configureNotificationChannels(Context context, JSONArray channels) {
        try {
            if (context == null || channels == null) {
                return;
            }
            List<HashMap<String, Object>> definedChannels = LeanplumNotificationChannel.retrieveNotificationChannels(context);
            List notificationChannels = JsonConverter.listFromJson((JSONArray)channels);
            if (definedChannels != null && notificationChannels != null) {
                definedChannels.removeAll(notificationChannels);
                for (HashMap hashMap : definedChannels) {
                    if (hashMap == null) continue;
                    String id = (String)hashMap.get("id");
                    LeanplumNotificationChannel.deleteNotificationChannel(context, id);
                }
            }
            LeanplumNotificationChannel.storeNotificationChannels(context, notificationChannels);
            if (notificationChannels != null) {
                for (HashMap hashMap : notificationChannels) {
                    if (hashMap == null) continue;
                    LeanplumNotificationChannel.createNotificationChannel(context, hashMap);
                }
            }
        }
        catch (Throwable t) {
            Log.exception((Throwable)t);
        }
    }

    static void configureDefaultNotificationChannel(Context context, String channel) {
        try {
            if (context == null || TextUtils.isEmpty((CharSequence)channel)) {
                return;
            }
            LeanplumNotificationChannel.storeDefaultNotificationChannel(context, channel);
        }
        catch (Throwable t) {
            Log.exception((Throwable)t);
        }
    }

    static void configureNotificationGroups(Context context, JSONArray groups) {
        try {
            if (context == null || groups == null) {
                return;
            }
            List<HashMap<String, Object>> definedGroups = LeanplumNotificationChannel.retrieveNotificationGroups(context);
            List notificationGroups = JsonConverter.listFromJson((JSONArray)groups);
            if (definedGroups != null && notificationGroups != null) {
                definedGroups.removeAll(notificationGroups);
                for (HashMap hashMap : definedGroups) {
                    if (hashMap == null) continue;
                    String id = (String)hashMap.get("id");
                    LeanplumNotificationChannel.deleteNotificationGroup(context, id);
                }
            }
            LeanplumNotificationChannel.storeNotificationGroups(context, notificationGroups);
            if (notificationGroups != null) {
                for (HashMap hashMap : notificationGroups) {
                    if (hashMap == null) continue;
                    LeanplumNotificationChannel.createNotificationGroup(context, hashMap);
                }
            }
        }
        catch (Throwable t) {
            Log.exception((Throwable)t);
        }
    }

    private static List<HashMap<String, Object>> retrieveNotificationChannels(Context context) {
        if (context == null) {
            return null;
        }
        try {
            SharedPreferences preferences = context.getSharedPreferences("__leanplum__", 0);
            String jsonChannels = preferences.getString("__leanplum_notification_channels", null);
            if (jsonChannels == null) {
                return null;
            }
            JSONArray json = new JSONArray(jsonChannels);
            return JsonConverter.listFromJson((JSONArray)json);
        }
        catch (Exception e) {
            Log.e((String)"Failed to convert notification channels json.", (Object[])new Object[0]);
            return null;
        }
    }

    private static String retrieveDefaultNotificationChannel(Context context) {
        if (context == null) {
            return null;
        }
        try {
            SharedPreferences preferences = context.getSharedPreferences("__leanplum__", 0);
            return preferences.getString("__leanplum_default_notification_channels", null);
        }
        catch (Exception e) {
            Log.e((String)"Failed to convert default notification channels json.", (Object[])new Object[0]);
            return null;
        }
    }

    private static List<HashMap<String, Object>> retrieveNotificationGroups(Context context) {
        if (context == null) {
            return null;
        }
        try {
            SharedPreferences preferences = context.getSharedPreferences("__leanplum__", 0);
            String jsonChannels = preferences.getString("__leanplum_notification_groups", null);
            if (jsonChannels == null) {
                return null;
            }
            JSONArray json = new JSONArray(jsonChannels);
            return JsonConverter.listFromJson((JSONArray)json);
        }
        catch (Exception e) {
            Log.e((String)"Failed to convert notification channels json.", (Object[])new Object[0]);
            return null;
        }
    }

    private static void storeNotificationChannels(Context context, List<HashMap<String, Object>> channels) {
        if (context == null || channels == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("__leanplum__", 0);
        SharedPreferences.Editor editor = preferences.edit();
        String jsonChannels = new JSONArray(channels).toString();
        editor.putString("__leanplum_notification_channels", jsonChannels);
        SharedPreferencesUtil.commitChanges((SharedPreferences.Editor)editor);
    }

    private static void storeDefaultNotificationChannel(Context context, String channelId) {
        if (context == null || channelId == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("__leanplum__", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("__leanplum_default_notification_channels", channelId);
        SharedPreferencesUtil.commitChanges((SharedPreferences.Editor)editor);
    }

    private static void storeNotificationGroups(Context context, List<HashMap<String, Object>> groups) {
        if (context == null || groups == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("__leanplum__", 0);
        SharedPreferences.Editor editor = preferences.edit();
        String jsonGroups = new JSONArray(groups).toString();
        editor.putString("__leanplum_notification_groups", jsonGroups);
        SharedPreferencesUtil.commitChanges((SharedPreferences.Editor)editor);
    }

    static String createNotificationChannel(Context context, Map<String, Object> channel) {
        try {
            if (context == null || channel == null) {
                return null;
            }
            NotificationChannelData data = new NotificationChannelData(channel);
            LeanplumNotificationChannel.createNotificationChannel(context, data.id, data.name, data.importance, data.description, data.groupId, data.enableLights, data.lightColor, data.enableVibration, data.vibrationPattern, data.lockscreenVisibility, data.bypassDnd, data.showBadge);
            return data.id;
        }
        catch (Exception e) {
            Log.e((String)"Failed to create notification channel.", (Object[])new Object[0]);
            return null;
        }
    }

    private static void createNotificationChannel(Context context, String channelId, String channelName, int channelImportance, String channelDescription, String groupId, boolean enableLights, int lightColor, boolean enableVibration, long[] vibrationPattern, int lockscreenVisibility, boolean bypassDnd, boolean showBadge) {
        if (context == null || TextUtils.isEmpty((CharSequence)channelId)) {
            return;
        }
        if (BuildUtil.isNotificationChannelSupported((Context)context)) {
            try {
                NotificationManager notificationManager = (NotificationManager)context.getSystemService(NotificationManager.class);
                if (notificationManager == null) {
                    Log.e((String)"Notification manager is null", (Object[])new Object[0]);
                    return;
                }
                NotificationChannel notificationChannel = new NotificationChannel(channelId, (CharSequence)channelName, channelImportance);
                if (!TextUtils.isEmpty((CharSequence)channelDescription)) {
                    notificationChannel.setDescription(channelDescription);
                }
                if (enableLights) {
                    notificationChannel.enableLights(true);
                    notificationChannel.setLightColor(lightColor);
                }
                if (enableVibration) {
                    notificationChannel.enableVibration(true);
                    if (vibrationPattern != null && vibrationPattern.length != 0) {
                        notificationChannel.setVibrationPattern(vibrationPattern);
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)groupId)) {
                    notificationChannel.setGroup(groupId);
                }
                notificationChannel.setLockscreenVisibility(lockscreenVisibility);
                notificationChannel.setBypassDnd(bypassDnd);
                notificationChannel.setShowBadge(showBadge);
                notificationManager.createNotificationChannel(notificationChannel);
            }
            catch (Throwable t) {
                Log.exception((Throwable)t);
            }
        }
    }

    private static void deleteNotificationChannel(Context context, String channelId) {
        if (context == null) {
            return;
        }
        if (BuildUtil.isNotificationChannelSupported((Context)context)) {
            try {
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                if (notificationManager == null) {
                    Log.e((String)"Notification manager is null", (Object[])new Object[0]);
                    return;
                }
                notificationManager.deleteNotificationChannel(channelId);
            }
            catch (Throwable t) {
                Log.exception((Throwable)t);
            }
        }
    }

    private static String createNotificationGroup(Context context, Map<String, Object> group) {
        if (context == null || group == null) {
            return null;
        }
        NotificationGroupData data = new NotificationGroupData(group);
        LeanplumNotificationChannel.createNotificationGroup(context, data.id, data.name);
        return data.id;
    }

    private static void createNotificationGroup(Context context, String groupId, String groupName) {
        if (context == null || TextUtils.isEmpty((CharSequence)groupId)) {
            return;
        }
        if (BuildUtil.isNotificationChannelSupported((Context)context)) {
            try {
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                if (notificationManager == null) {
                    Log.e((String)"Notification manager is null", (Object[])new Object[0]);
                    return;
                }
                notificationManager.createNotificationChannelGroup(new NotificationChannelGroup(groupId, (CharSequence)groupName));
            }
            catch (Throwable t) {
                Log.exception((Throwable)t);
            }
        }
    }

    private static void deleteNotificationGroup(Context context, String groupId) {
        if (context == null || TextUtils.isEmpty((CharSequence)groupId)) {
            return;
        }
        if (BuildUtil.isNotificationChannelSupported((Context)context)) {
            try {
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                if (notificationManager == null) {
                    Log.e((String)"Notification manager is null", (Object[])new Object[0]);
                    return;
                }
                notificationManager.deleteNotificationChannelGroup(groupId);
            }
            catch (Throwable t) {
                Log.exception((Throwable)t);
            }
        }
    }

    static List<NotificationChannel> getNotificationChannels(Context context) {
        if (BuildUtil.isNotificationChannelSupported((Context)context)) {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (notificationManager == null) {
                Log.e((String)"Notification manager is null", (Object[])new Object[0]);
                return null;
            }
            return notificationManager.getNotificationChannels();
        }
        return null;
    }

    static String getDefaultNotificationChannelId(Context context) {
        if (BuildUtil.isNotificationChannelSupported((Context)context)) {
            return LeanplumNotificationChannel.retrieveDefaultNotificationChannel(context);
        }
        return null;
    }

    static List<NotificationChannelGroup> getNotificationGroups(Context context) {
        if (BuildUtil.isNotificationChannelSupported((Context)context)) {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (notificationManager == null) {
                Log.e((String)"Cannot get Notification Channel Groups, notificationManager is null.", (Object[])new Object[0]);
                return null;
            }
            return notificationManager.getNotificationChannelGroups();
        }
        return null;
    }

    static void configureChannels(Context context, JSONArray notificationGroups, JSONArray notificationChannels, String defaultNotificationChannel) {
        LeanplumNotificationChannel.configureNotificationGroups(context, notificationGroups);
        LeanplumNotificationChannel.configureNotificationChannels(context, notificationChannels);
        LeanplumNotificationChannel.configureDefaultNotificationChannel(context, defaultNotificationChannel);
    }

    @TargetApi(value=26)
    private static class NotificationGroupData {
        String id;
        String name;

        NotificationGroupData(Map<String, Object> group) {
            this.id = (String)group.get("id");
            this.name = (String)group.get("name");
        }
    }

    @TargetApi(value=26)
    private static class NotificationChannelData {
        String id;
        String name;
        String description;
        String groupId;
        int importance = 3;
        boolean enableLights = false;
        int lightColor = 0;
        boolean enableVibration = false;
        long[] vibrationPattern = null;
        int lockscreenVisibility = 1;
        boolean bypassDnd = false;
        boolean showBadge = false;

        NotificationChannelData(Map<String, Object> channel) {
            this.id = (String)channel.get("id");
            this.name = (String)channel.get("name");
            this.description = (String)channel.get("description");
            this.groupId = (String)channel.get("groupId");
            this.importance = (Integer)CollectionUtil.getOrDefault(channel, (Object)"importance", (Object)this.importance);
            this.enableLights = (Boolean)CollectionUtil.getOrDefault(channel, (Object)"enable_lights", (Object)this.enableLights);
            this.lightColor = (Integer)CollectionUtil.getOrDefault(channel, (Object)"light_color", (Object)this.lightColor);
            this.enableVibration = (Boolean)CollectionUtil.getOrDefault(channel, (Object)"enable_vibration", (Object)this.enableVibration);
            this.lockscreenVisibility = (Integer)CollectionUtil.getOrDefault(channel, (Object)"lockscreen_visibility", (Object)this.lockscreenVisibility);
            this.bypassDnd = (Boolean)CollectionUtil.getOrDefault(channel, (Object)"bypass_dnd", (Object)this.bypassDnd);
            this.showBadge = (Boolean)CollectionUtil.getOrDefault(channel, (Object)"show_badge", (Object)this.showBadge);
            try {
                List pattern = (List)CollectionUtil.uncheckedCast((Object)CollectionUtil.getOrDefault(channel, (Object)"vibration_pattern", null));
                if (pattern != null) {
                    this.vibrationPattern = new long[pattern.size()];
                    Iterator iterator = pattern.iterator();
                    for (int i = 0; i < this.vibrationPattern.length; ++i) {
                        Number next = (Number)iterator.next();
                        if (next == null) continue;
                        this.vibrationPattern[i] = next.longValue();
                    }
                }
            }
            catch (Exception e) {
                Log.d((String)"Failed to parse vibration pattern.", (Object[])new Object[0]);
            }
            if (this.importance < 0 && this.importance > 5) {
                this.importance = 3;
            }
            if (this.lockscreenVisibility < -1 && this.lockscreenVisibility > 1) {
                this.lockscreenVisibility = 1;
            }
        }
    }
}

