/*
 * Decompiled with CFR 0.152.
 */
package com.leanplum;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.leanplum.LeanplumNotificationChannel;
import com.leanplum.internal.JsonConverter;
import com.leanplum.internal.Log;
import com.leanplum.utils.BitmapUtil;
import com.leanplum.utils.BuildUtil;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;

class LeanplumNotificationHelper {
    private static final String LEANPLUM_DEFAULT_PUSH_ICON = "leanplum_default_push_icon";

    LeanplumNotificationHelper() {
    }

    static NotificationCompat.Builder getDefaultCompatNotificationBuilder(Context context, boolean isNotificationChannelSupported) {
        if (!isNotificationChannelSupported) {
            return new NotificationCompat.Builder(context);
        }
        String channelId = LeanplumNotificationChannel.getDefaultNotificationChannelId(context);
        if (!TextUtils.isEmpty((CharSequence)channelId)) {
            return new NotificationCompat.Builder(context, channelId);
        }
        Log.e((String)"Failed to post notification, there are no notification channels configured.", (Object[])new Object[0]);
        return null;
    }

    @TargetApi(value=26)
    private static Notification.Builder getDefaultNotificationBuilder(Context context, boolean isNotificationChannelSupported) {
        if (!isNotificationChannelSupported) {
            return new Notification.Builder(context);
        }
        String channelId = LeanplumNotificationChannel.getDefaultNotificationChannelId(context);
        if (!TextUtils.isEmpty((CharSequence)channelId)) {
            return new Notification.Builder(context, channelId);
        }
        Log.e((String)"Failed to post notification, there are no notification channels configured.", (Object[])new Object[0]);
        return null;
    }

    static NotificationCompat.Builder getNotificationCompatBuilder(Context context, Bundle message) {
        NotificationCompat.Builder builder;
        block7: {
            builder = null;
            if (BuildUtil.isNotificationChannelSupported((Context)context)) {
                try {
                    String channel = message.getString("lp_channel");
                    if (!TextUtils.isEmpty((CharSequence)channel)) {
                        Map channelDetails = JsonConverter.fromJson((String)channel);
                        String channelId = LeanplumNotificationChannel.createNotificationChannel(context, channelDetails);
                        if (!TextUtils.isEmpty((CharSequence)channelId)) {
                            builder = new NotificationCompat.Builder(context, channelId);
                        } else {
                            Log.e((String)"Failed to post notification to specified channel.", (Object[])new Object[0]);
                        }
                        break block7;
                    }
                    builder = LeanplumNotificationHelper.getDefaultCompatNotificationBuilder(context, true);
                }
                catch (Exception e) {
                    Log.e((String)"Failed to post notification to specified channel.", (Object[])new Object[0]);
                }
            } else {
                builder = new NotificationCompat.Builder(context);
            }
        }
        return builder;
    }

    private static Notification.Builder getNotificationBuilder(Context context, Bundle message) {
        Notification.Builder builder;
        block7: {
            builder = null;
            if (BuildUtil.isNotificationChannelSupported((Context)context)) {
                try {
                    String channel = message.getString("lp_channel");
                    if (!TextUtils.isEmpty((CharSequence)channel)) {
                        Map channelDetails = JsonConverter.fromJson((String)channel);
                        String channelId = LeanplumNotificationChannel.createNotificationChannel(context, channelDetails);
                        if (!TextUtils.isEmpty((CharSequence)channelId)) {
                            builder = new Notification.Builder(context, channelId);
                        } else {
                            Log.e((String)"Failed to post notification to specified channel.", (Object[])new Object[0]);
                        }
                        break block7;
                    }
                    builder = LeanplumNotificationHelper.getDefaultNotificationBuilder(context, true);
                }
                catch (Exception e) {
                    Log.e((String)"Failed to post notification to specified channel.", (Object[])new Object[0]);
                }
            } else {
                builder = new Notification.Builder(context);
            }
        }
        return builder;
    }

    public static boolean areNotificationsEnabled(Context context, Bundle message) {
        if (!NotificationManagerCompat.from((Context)context).areNotificationsEnabled()) {
            return false;
        }
        if (BuildUtil.isNotificationChannelSupported((Context)context)) {
            String channelId = LeanplumNotificationHelper.resolveChannelId(context, message);
            return !TextUtils.isEmpty((CharSequence)channelId) && LeanplumNotificationHelper.isChannelEnabled(context, channelId);
        }
        return true;
    }

    private static String resolveChannelId(Context context, Bundle message) {
        Map channelDetails;
        String channelId;
        String channelJson = message.getString("lp_channel");
        if (!TextUtils.isEmpty((CharSequence)channelJson) && !TextUtils.isEmpty((CharSequence)(channelId = (String)(channelDetails = JsonConverter.fromJson((String)channelJson)).get("id")))) {
            return channelId;
        }
        String defaultChannelId = LeanplumNotificationChannel.getDefaultNotificationChannelId(context);
        if (!TextUtils.isEmpty((CharSequence)defaultChannelId)) {
            return defaultChannelId;
        }
        return null;
    }

    @RequiresApi(api=26)
    private static boolean isChannelEnabled(Context context, String channelId) {
        NotificationChannel channel = NotificationManagerCompat.from((Context)context).getNotificationChannel(channelId);
        return channel != null && channel.getImportance() > 0;
    }

    static NotificationCompat.Builder getNotificationCompatBuilder(Context context, Bundle message, PendingIntent contentIntent, String title, String messageText, Bitmap bigPicture, int defaultNotificationIconResourceId) {
        if (message == null) {
            return null;
        }
        NotificationCompat.Builder notificationCompatBuilder = LeanplumNotificationHelper.getNotificationCompatBuilder(context, message);
        if (notificationCompatBuilder == null) {
            return null;
        }
        if (defaultNotificationIconResourceId == 0) {
            notificationCompatBuilder.setSmallIcon(context.getApplicationInfo().icon);
        } else {
            notificationCompatBuilder.setSmallIcon(defaultNotificationIconResourceId);
        }
        notificationCompatBuilder.setContentTitle((CharSequence)title).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)messageText)).setContentText((CharSequence)messageText);
        if (bigPicture != null) {
            notificationCompatBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bigPicture).setBigContentTitle((CharSequence)title).setSummaryText((CharSequence)messageText));
        }
        if (Build.VERSION.SDK_INT >= 16 && !BuildUtil.isNotificationChannelSupported((Context)context)) {
            notificationCompatBuilder.setPriority(2);
        }
        notificationCompatBuilder.setAutoCancel(true);
        notificationCompatBuilder.setContentIntent(contentIntent);
        return notificationCompatBuilder;
    }

    static void setModifiedBigPictureStyle(Notification.Builder notificationBuilder, Notification.Style bigPictureStyle) {
        if (Build.VERSION.SDK_INT < 16 || notificationBuilder == null || bigPictureStyle == null) {
            return;
        }
        notificationBuilder.setStyle(bigPictureStyle);
    }

    @TargetApi(value=16)
    static Notification.BigPictureStyle getBigPictureStyle(Bundle message, Bitmap bigPicture, String title, String messageText) {
        if (Build.VERSION.SDK_INT < 16 || message == null || bigPicture == null) {
            return null;
        }
        return new Notification.BigPictureStyle().bigPicture(bigPicture).setBigContentTitle((CharSequence)title).setSummaryText((CharSequence)messageText);
    }

    static Notification.Builder getNotificationBuilder(Context context, Bundle message, PendingIntent contentIntent, String title, String messageText, int defaultNotificationIconResourceId) {
        Notification.Builder notificationBuilder = LeanplumNotificationHelper.getNotificationBuilder(context, message);
        if (notificationBuilder == null) {
            return null;
        }
        if (defaultNotificationIconResourceId == 0) {
            notificationBuilder.setSmallIcon(context.getApplicationInfo().icon);
        } else {
            notificationBuilder.setSmallIcon(defaultNotificationIconResourceId);
        }
        notificationBuilder.setContentTitle((CharSequence)title).setContentText((CharSequence)messageText);
        if (Build.VERSION.SDK_INT > 16) {
            notificationBuilder.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)messageText));
            if (!BuildUtil.isNotificationChannelSupported((Context)context)) {
                notificationBuilder.setPriority(2);
            }
        }
        notificationBuilder.setAutoCancel(true);
        notificationBuilder.setContentIntent(contentIntent);
        return notificationBuilder;
    }

    @TargetApi(value=16)
    private static boolean canCreateIconDrawable(Context context) {
        try {
            Drawable drawable2 = AdaptiveIconDrawable.createFromStream((InputStream)context.getResources().openRawResource(context.getApplicationInfo().icon), (String)"applicationInfo.icon");
            if (drawable2 != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    static boolean isApplicationIconValid(Context context) {
        if (context == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 26) {
            return true;
        }
        return LeanplumNotificationHelper.canCreateIconDrawable(context);
    }

    static int getDefaultPushNotificationIconResourceId(Context context) {
        try {
            Resources resources = context.getResources();
            return resources.getIdentifier(LEANPLUM_DEFAULT_PUSH_ICON, "drawable", context.getPackageName());
        }
        catch (Throwable ignored) {
            return 0;
        }
    }

    @TargetApi(value=21)
    static void scheduleJobService(Context context, Class clazz, int jobId) {
        if (context == null) {
            return;
        }
        ComponentName serviceName = new ComponentName(context, clazz);
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobId = LeanplumNotificationHelper.verifyJobId(jobScheduler.getAllPendingJobs(), jobId);
            JobInfo startMyServiceJobInfo = new JobInfo.Builder(jobId, serviceName).setMinimumLatency(10L).build();
            jobScheduler.schedule(startMyServiceJobInfo);
        }
    }

    @TargetApi(value=21)
    private static int verifyJobId(List<JobInfo> allPendingJobs, int jobId) {
        if (allPendingJobs != null && !allPendingJobs.isEmpty()) {
            TreeSet<Integer> idsSet = new TreeSet<Integer>();
            for (JobInfo jobInfo : allPendingJobs) {
                idsSet.add(jobInfo.getId());
            }
            if (idsSet.contains(jobId)) {
                if ((Integer)idsSet.first() > Integer.MIN_VALUE) {
                    jobId = (Integer)idsSet.first() - 1;
                } else if ((Integer)idsSet.last() < Integer.MIN_VALUE) {
                    jobId = (Integer)idsSet.last() + 1;
                } else {
                    while (idsSet.contains(jobId)) {
                        jobId = new Random().nextInt();
                    }
                }
            }
        }
        return jobId;
    }

    @Nullable
    static Bitmap getBigPictureBitmap(Context context, String imageUrl) {
        Bitmap bigPicture = null;
        if (!TextUtils.isEmpty((CharSequence)imageUrl) && Build.VERSION.SDK_INT >= 16 && (bigPicture = BitmapUtil.getScaledBitmap((Context)context, (String)imageUrl)) == null) {
            Log.i((String)"Failed to download image for push notification: %s", (Object[])new Object[]{imageUrl});
        }
        return bigPicture;
    }
}

