/*
 * Decompiled with CFR 0.152.
 */
package com.leanplum;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.leanplum.LeanplumPushService;
import com.leanplum.internal.LeanplumManifestHelper;
import com.leanplum.internal.Log;

public class LeanplumPushReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        try {
            if (intent == null) {
                Log.e((String)"Received a null intent.", (Object[])new Object[0]);
                return;
            }
            String receiver = LeanplumManifestHelper.parseNotificationMetadata();
            if (receiver == null) {
                Log.d((String)"Custom broadcast receiver class not set, using default one.", (Object[])new Object[0]);
                LeanplumPushService.openNotification(context, intent);
            } else {
                Log.d((String)"Custom broadcast receiver class found, using it to handle push notifications.", (Object[])new Object[0]);
                Intent forwardIntent = new Intent();
                forwardIntent.setAction("LP_NOTIFICATION");
                forwardIntent.setClassName(context, receiver);
                forwardIntent.putExtras(intent.getExtras());
                context.sendBroadcast(forwardIntent);
            }
        }
        catch (Throwable t) {
            Log.exception((Throwable)t);
        }
    }
}

