/*
 * Decompiled with CFR 0.152.
 */
package com.leanplum;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.core.app.NotificationCompat;
import com.leanplum.ActionContext;
import com.leanplum.Leanplum;
import com.leanplum.LeanplumActivityHelper;
import com.leanplum.LeanplumNotificationHelper;
import com.leanplum.LeanplumPushNotificationCustomizer;
import com.leanplum.LeanplumPushReceiver;
import com.leanplum.PushProviders;
import com.leanplum.PushTracking;
import com.leanplum.callbacks.VariablesChangedCallback;
import com.leanplum.internal.JsonConverter;
import com.leanplum.internal.LeanplumInternal;
import com.leanplum.internal.Log;
import com.leanplum.internal.PushActionPersistenceKt;
import com.leanplum.internal.Request;
import com.leanplum.internal.RequestBuilder;
import com.leanplum.internal.RequestSender;
import com.leanplum.internal.Util;
import com.leanplum.internal.VarCache;
import com.leanplum.utils.BuildUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LeanplumPushService {
    public static final String LEANPLUM_SENDER_ID = "44059457771";
    public static final String LEANPLUM_NOTIFICATION = "LP_NOTIFICATION";
    public static final String LEANPLUM_ACTION_PARAM = "lp_action_param";
    public static final String LEANPLUM_MESSAGE_PARAM = "lp_message_param";
    public static final String LEANPLUM_MESSAGE_ID = "lp_message_id";
    private static final int NOTIFICATION_ID = 1;
    private static final String OPEN_URL = "Open URL";
    private static final String URL = "URL";
    private static final String OPEN_ACTION = "Open";
    private static Class<? extends Activity> callbackClass;
    private static final PushProviders pushProviders;
    private static LeanplumPushNotificationCustomizer customizer;
    private static boolean useNotificationBuilderCustomizer;

    @NonNull
    static PushProviders getPushProviders() {
        return pushProviders;
    }

    public static void setDefaultCallbackClass(Class<? extends Activity> callbackClass) {
        LeanplumPushService.callbackClass = callbackClass;
    }

    public static void setCustomizer(LeanplumPushNotificationCustomizer customizer) {
        LeanplumPushService.setCustomizer(customizer, false);
    }

    public static void setCustomizer(LeanplumPushNotificationCustomizer customizer, boolean useNotificationBuilderCustomizer) {
        LeanplumPushService.customizer = customizer;
        LeanplumPushService.useNotificationBuilderCustomizer = useNotificationBuilderCustomizer;
    }

    private static Class<? extends Activity> getCallbackClass() {
        return callbackClass;
    }

    private static boolean areActionsEmbedded(Bundle message) {
        return message.containsKey("_lpx");
    }

    private static void requireMessageContent(final String messageId, final VariablesChangedCallback onComplete) {
        Leanplum.addOnceVariablesChangedAndNoDownloadsPendingHandler((VariablesChangedCallback)new VariablesChangedCallback(){

            public void variablesChanged() {
                try {
                    Map messages = VarCache.messages();
                    if (messageId == null || messages != null && messages.containsKey(messageId)) {
                        onComplete.variablesChanged();
                    } else {
                        Request req = RequestBuilder.withGetVarsAction().andParam("includeDefaults", (Object)Boolean.toString(false)).andParam("includeMessageId", (Object)messageId).andType(Request.RequestType.IMMEDIATE).create();
                        req.onResponse(new Request.ResponseCallback(){

                            public void response(JSONObject response) {
                                try {
                                    if (response == null) {
                                        Log.e((String)"No response received from the server. Please contact us to investigate.", (Object[])new Object[0]);
                                    } else {
                                        Map values = JsonConverter.mapFromJson((JSONObject)response.optJSONObject("vars"));
                                        Map messages = JsonConverter.mapFromJson((JSONObject)response.optJSONObject("messages"));
                                        Map regions = JsonConverter.mapFromJson((JSONObject)response.optJSONObject("regions"));
                                        List variants = JsonConverter.listFromJson((JSONArray)response.optJSONArray("variants"));
                                        List localCaps = JsonConverter.listFromJson((JSONArray)response.optJSONArray("localCaps"));
                                        JSONObject varsJsonObj = response.optJSONObject("vars");
                                        String varsJson = varsJsonObj != null ? varsJsonObj.toString() : null;
                                        String varsSignature = response.optString("varsSignature");
                                        VarCache.applyVariableDiffs((Map)values, (Map)messages, (Map)regions, (List)variants, (List)localCaps, null, (String)varsJson, (String)varsSignature);
                                    }
                                    onComplete.variablesChanged();
                                }
                                catch (Throwable t) {
                                    Log.exception((Throwable)t);
                                }
                            }
                        });
                        req.onError(new Request.ErrorCallback(){

                            public void error(Exception e) {
                                onComplete.variablesChanged();
                            }
                        });
                        RequestSender.getInstance().send(req);
                    }
                }
                catch (Throwable t) {
                    Log.exception((Throwable)t);
                }
            }
        });
    }

    static String getMessageId(Bundle message) {
        String messageId = message.getString("_lpm");
        if (messageId == null && (messageId = message.getString("_lpu")) == null && (messageId = message.getString("_lpn")) == null) {
            messageId = message.getString("_lpv");
        }
        if (messageId != null) {
            message.putString("lp_messageId", messageId);
        }
        return messageId;
    }

    static boolean shouldMuteNotification(@NonNull Bundle message) {
        return LeanplumActivityHelper.getCurrentActivity() != null && !LeanplumActivityHelper.isActivityPaused && (message.containsKey("_lpu") || message.containsKey("_lpv"));
    }

    static void handleNotification(Context context, Bundle message) {
        PushTracking.trackDelivery(context, message);
        if (PushTracking.isFcmSilentPush(message)) {
            return;
        }
        if (LeanplumPushService.shouldMuteNotification(message)) {
            return;
        }
        String messageId = LeanplumPushService.getMessageId(message);
        if (messageId == null || !LeanplumInternal.hasCalledStart()) {
            LeanplumPushService.showNotification(context, message);
            return;
        }
        LeanplumPushService.showNotification(context, message);
    }

    @TargetApi(value=16)
    private static void showNotification(Context context, Bundle message) {
        String value;
        Notification.BigPictureStyle bigPictureStyle;
        Bitmap bigPicture;
        String messageText;
        Notification.Builder notificationBuilder;
        NotificationCompat.Builder notificationCompatBuilder;
        String title;
        NotificationManager notificationManager;
        block30: {
            block29: {
                if (context == null || message == null) {
                    return;
                }
                int defaultIconId = 0;
                if (!LeanplumNotificationHelper.isApplicationIconValid(context)) {
                    defaultIconId = LeanplumNotificationHelper.getDefaultPushNotificationIconResourceId(context);
                }
                if ((notificationManager = (NotificationManager)context.getSystemService("notification")) == null) {
                    return;
                }
                PendingIntent contentIntent = LeanplumPushService.createContentIntent(context, message);
                title = Util.getApplicationName((Context)context.getApplicationContext());
                if (message.getString("title") != null) {
                    title = message.getString("title");
                }
                notificationCompatBuilder = null;
                notificationBuilder = null;
                messageText = message.getString("lp_message");
                bigPicture = LeanplumNotificationHelper.getBigPictureBitmap(context, message.getString("lp_imageUrl"));
                if (customizer != null && !useNotificationBuilderCustomizer) {
                    notificationCompatBuilder = LeanplumNotificationHelper.getNotificationCompatBuilder(context, message, contentIntent, title, messageText, bigPicture, defaultIconId);
                } else {
                    notificationBuilder = LeanplumNotificationHelper.getNotificationBuilder(context, message, contentIntent, title, messageText, defaultIconId);
                }
                if (notificationCompatBuilder == null && notificationBuilder == null) break block29;
                boolean bl = customizer != null;
                boolean bl2 = !useNotificationBuilderCustomizer;
                if (!(bl & bl2 && notificationCompatBuilder == null || customizer != null && useNotificationBuilderCustomizer && notificationBuilder == null) && (customizer != null || notificationBuilder != null)) break block30;
            }
            return;
        }
        if (customizer != null) {
            try {
                if (useNotificationBuilderCustomizer) {
                    if (bigPicture != null) {
                        bigPictureStyle = LeanplumNotificationHelper.getBigPictureStyle(message, bigPicture, title, messageText);
                        customizer.customize(notificationBuilder, message, (Notification.Style)bigPictureStyle);
                        LeanplumNotificationHelper.setModifiedBigPictureStyle(notificationBuilder, (Notification.Style)bigPictureStyle);
                    }
                    customizer.customize(notificationBuilder, message, null);
                }
                customizer.customize(notificationCompatBuilder, message);
            }
            catch (Throwable t) {
                Log.e((String)"Unable to customize push notification: %s", (Object[])new Object[]{Log.getStackTraceString((Throwable)t)});
                return;
            }
        } else if (bigPicture != null) {
            bigPictureStyle = LeanplumNotificationHelper.getBigPictureStyle(message, bigPicture, title, messageText);
            LeanplumNotificationHelper.setModifiedBigPictureStyle(notificationBuilder, (Notification.Style)bigPictureStyle);
        }
        int notificationId = 1;
        Object notificationIdObject = message.get("lp_notificationId");
        if (notificationIdObject instanceof Number) {
            notificationId = ((Number)notificationIdObject).intValue();
        } else if (notificationIdObject instanceof String) {
            try {
                notificationId = Integer.parseInt((String)notificationIdObject);
            }
            catch (NumberFormatException e) {
                notificationId = 1;
            }
        } else if (message.containsKey("lp_messageId") && (value = message.getString("lp_messageId")) != null) {
            notificationId = value.hashCode();
        }
        try {
            if (ActionContext.shouldFetchChainedMessage((Map)JsonConverter.fromJson((String)message.getString("_lpx")))) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                Leanplum.forceContentUpdate((VariablesChangedCallback)new VariablesChangedCallback(){

                    public void variablesChanged() {
                        countDownLatch.countDown();
                    }
                });
                countDownLatch.await(3L, TimeUnit.SECONDS);
            }
            if (notificationBuilder != null) {
                notificationManager.notify(notificationId, notificationBuilder.build());
            } else {
                notificationManager.notify(notificationId, notificationCompatBuilder.build());
            }
        }
        catch (NullPointerException e) {
            Log.e((String)"Unable to show push notification.", (Throwable)e);
        }
        catch (Throwable t) {
            Log.e((String)"Unable to show push notification.", (Throwable)t);
            Log.exception((Throwable)t);
        }
    }

    private static PendingIntent createContentIntent(Context context, Bundle message) {
        PendingIntent contentIntent;
        if (BuildUtil.shouldDisableTrampolines((Context)context)) {
            Intent intent = LeanplumPushService.createActivityIntent(context, message);
            contentIntent = PendingIntent.getActivity((Context)context, (int)new Random().nextInt(), (Intent)intent, (int)BuildUtil.createIntentFlags((int)0x8000000));
        } else {
            Intent intent = LeanplumPushService.createBroadcastIntent(context, message);
            contentIntent = PendingIntent.getBroadcast((Context)context.getApplicationContext(), (int)new Random().nextInt(), (Intent)intent, (int)BuildUtil.createIntentFlags((int)0));
        }
        return contentIntent;
    }

    private static Intent createBroadcastIntent(Context context, Bundle message) {
        Intent intent = new Intent(context, LeanplumPushReceiver.class);
        intent.addCategory("lpAction");
        intent.putExtras(message);
        return intent;
    }

    @TargetApi(value=31)
    private static Intent createActivityIntent(Context context, Bundle message) {
        Intent deepLinkIntent;
        String action = message.getString("_lpx");
        if (action != null && action.contains(OPEN_URL) && (deepLinkIntent = LeanplumPushService.getDeepLinkIntent(message)) != null) {
            LeanplumPushService.resolveIntentActivity(context, deepLinkIntent);
            String messageId = LeanplumPushService.getMessageId(message);
            if (messageId != null) {
                deepLinkIntent.putExtras(message);
            }
            return deepLinkIntent;
        }
        Intent actionIntent = LeanplumPushService.getActionIntent(context);
        if (actionIntent == null) {
            return null;
        }
        actionIntent.putExtras(message);
        actionIntent.addFlags(0x14000000);
        return actionIntent;
    }

    static void openNotification(Context context, Intent intent) {
        Bundle notification = LeanplumPushService.preHandlePushNotification(context, intent);
        if (notification == null) {
            return;
        }
        LeanplumPushService.openNotification(context, notification);
    }

    static void openNotification(Context context, @NonNull Bundle notification) {
        Log.d((String)"Opening push notification action.", (Object[])new Object[0]);
        PushTracking.trackOpen(notification);
        if (LeanplumPushService.isActivityWithIntentStarted(context, notification)) {
            return;
        }
        Class<? extends Activity> callbackClass = LeanplumPushService.getCallbackClass();
        boolean shouldStartActivity = true;
        Activity currentActivity = LeanplumActivityHelper.getCurrentActivity();
        if (currentActivity != null && !LeanplumActivityHelper.isActivityPaused) {
            if (callbackClass == null) {
                shouldStartActivity = false;
            } else if (callbackClass.isInstance(currentActivity)) {
                shouldStartActivity = false;
            }
        }
        if (shouldStartActivity) {
            Intent actionIntent = LeanplumPushService.getActionIntent(context);
            if (actionIntent == null) {
                return;
            }
            actionIntent.putExtras(notification);
            actionIntent.addFlags(0x14000000);
            context.startActivity(actionIntent);
        }
        LeanplumPushService.performActionAfterIssuedStart(notification);
    }

    static void onActivityNotificationClick(@NonNull Bundle notification) {
        if (!notification.containsKey("lp_occurrence_id")) {
            Log.i((String)"Skipping execution of Open Action because occurrenceId is missing.", (Object[])new Object[0]);
            return;
        }
        String occurrenceId = (String)notification.get("lp_occurrence_id");
        if (PushActionPersistenceKt.isOpened(occurrenceId)) {
            Log.i((String)"Open Action from activity intent is already executed.", (Object[])new Object[0]);
        } else {
            Log.d((String)"Executing Open Action from push notification.", (Object[])new Object[0]);
            PushActionPersistenceKt.recordOpenAction(occurrenceId);
            PushTracking.trackOpen(notification);
            if (LeanplumPushService.getDeepLinkIntent(notification) != null) {
                String messageId = LeanplumPushService.getMessageId(notification);
                if (messageId != null) {
                    ActionContext actionContext = new ActionContext("__Push Notification", null, messageId);
                    actionContext.track(OPEN_ACTION, 0.0, null);
                }
                return;
            }
            LeanplumPushService.performActionAfterIssuedStart(notification);
        }
    }

    public static Map<String, Object> parseNotificationBundle(Bundle notificationBundle) {
        try {
            String notificationActions = notificationBundle.getString("_lpx");
            String notificationMessage = notificationBundle.getString("lp_message");
            String notificationMessageId = LeanplumPushService.getMessageId(notificationBundle);
            HashMap<String, Object> arguments = new HashMap<String, Object>();
            arguments.put(LEANPLUM_ACTION_PARAM, JsonConverter.fromJson((String)notificationActions));
            arguments.put(LEANPLUM_MESSAGE_PARAM, notificationMessage);
            arguments.put(LEANPLUM_MESSAGE_ID, notificationMessageId);
            return arguments;
        }
        catch (Throwable ignored) {
            Log.i((String)"Failed to parse notification bundle.", (Object[])new Object[0]);
            return null;
        }
    }

    public static Bundle preHandlePushNotification(Context context, Intent intent) {
        if (intent == null) {
            Log.i((String)"Unable to pre handle push notification, Intent is null.", (Object[])new Object[0]);
            return null;
        }
        Bundle notification = intent.getExtras();
        if (notification == null) {
            Log.i((String)"Unable to pre handle push notification, extras are null.", (Object[])new Object[0]);
            return null;
        }
        return notification;
    }

    public static void postHandlePushNotification(Context context, Intent intent) {
        Bundle notification = intent.getExtras();
        if (notification == null) {
            Log.d((String)"Could not post handle push notification, extras are null.", (Object[])new Object[0]);
            return;
        }
        LeanplumPushService.performActionAfterIssuedStart(notification);
    }

    private static void performActionAfterIssuedStart(@NonNull Bundle notification) {
        LeanplumInternal.addStartIssuedHandler(() -> LeanplumPushService.performPushNotificationAction(notification));
    }

    private static void performPushNotificationAction(final @NonNull Bundle notification) {
        LeanplumActivityHelper.queueActionUponActive((Runnable)new VariablesChangedCallback(){

            public void variablesChanged() {
                try {
                    final String messageId = LeanplumPushService.getMessageId(notification);
                    String actionName = "Open action";
                    if (messageId != null) {
                        if (LeanplumPushService.areActionsEmbedded(notification)) {
                            HashMap<String, Map> args = new HashMap<String, Map>();
                            args.put("Open action", JsonConverter.fromJson((String)notification.getString("_lpx")));
                            ActionContext context = new ActionContext("__Push Notification", args, messageId);
                            context.preventRealtimeUpdating();
                            context.update();
                            context.runTrackedActionNamed("Open action");
                        } else {
                            Leanplum.addOnceVariablesChangedAndNoDownloadsPendingHandler((VariablesChangedCallback)new VariablesChangedCallback(){

                                public void variablesChanged() {
                                    try {
                                        LeanplumPushService.requireMessageContent(messageId, new VariablesChangedCallback(){

                                            public void variablesChanged() {
                                                try {
                                                    LeanplumInternal.performTrackedAction((String)"Open action", (String)messageId);
                                                }
                                                catch (Throwable t) {
                                                    Log.exception((Throwable)t);
                                                }
                                            }
                                        });
                                    }
                                    catch (Throwable t) {
                                        Log.exception((Throwable)t);
                                    }
                                }
                            });
                        }
                    }
                }
                catch (Throwable t) {
                    Log.exception((Throwable)t);
                }
            }
        });
    }

    private static boolean isActivityWithIntentStarted(Context context, Bundle notification) {
        Intent deepLinkIntent;
        String action = notification.getString("_lpx");
        if (action != null && action.contains(OPEN_URL) && (deepLinkIntent = LeanplumPushService.getDeepLinkIntent(notification)) != null) {
            LeanplumPushService.resolveIntentActivity(context, deepLinkIntent);
            String messageId = LeanplumPushService.getMessageId(notification);
            if (messageId != null) {
                try {
                    context.startActivity(deepLinkIntent);
                    ActionContext actionContext = new ActionContext("__Push Notification", null, messageId);
                    actionContext.track(OPEN_ACTION, 0.0, null);
                }
                catch (ActivityNotFoundException e) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static Intent getDeepLinkIntent(Bundle notification) {
        try {
            String actionString = notification.getString("_lpx");
            if (actionString != null) {
                JSONObject openAction = new JSONObject(actionString);
                Intent deepLinkIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)openAction.getString(URL)));
                deepLinkIntent.setFlags(0x10000000);
                return deepLinkIntent;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    private static void resolveIntentActivity(Context context, Intent deepLinkIntent) {
        List resolveInfoList = context.getPackageManager().queryIntentActivities(deepLinkIntent, 0);
        if (resolveInfoList != null && !resolveInfoList.isEmpty()) {
            for (ResolveInfo resolveInfo : resolveInfoList) {
                if (resolveInfo == null || resolveInfo.activityInfo == null || resolveInfo.activityInfo.name == null) continue;
                if (resolveInfo.activityInfo.name.contains(context.getPackageName())) {
                    deepLinkIntent.setPackage(resolveInfo.activityInfo.packageName);
                }
                return;
            }
        }
    }

    private static Intent getActionIntent(Context context) {
        Class<? extends Activity> callbackClass = LeanplumPushService.getCallbackClass();
        if (callbackClass != null) {
            return new Intent(context, callbackClass);
        }
        PackageManager pm = context.getPackageManager();
        return pm.getLaunchIntentForPackage(context.getPackageName());
    }

    public static void unregister() {
        try {
            Intent unregisterIntent = new Intent("com.google.android.c2dm.intent.UNREGISTER");
            Context context = Leanplum.getContext();
            unregisterIntent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(), (int)BuildUtil.createIntentFlags((int)0)));
            unregisterIntent.setPackage("com.google.android.gms");
            context.startService(unregisterIntent);
        }
        catch (Throwable t) {
            Log.exception((Throwable)t);
        }
    }

    static void onStart() {
        pushProviders.init();
        pushProviders.updateRegistrationIdsAndBackend();
    }

    static void showDeviceRegisteredPush(Context context, Context currentContext) {
        try {
            NotificationCompat.Builder builder = LeanplumNotificationHelper.getDefaultCompatNotificationBuilder(context, BuildUtil.isNotificationChannelSupported((Context)context));
            if (builder == null) {
                return;
            }
            builder.setSmallIcon(17301620).setContentTitle((CharSequence)"Leanplum").setContentText((CharSequence)"Your device is registered.");
            builder.setContentIntent(PendingIntent.getActivity((Context)currentContext.getApplicationContext(), (int)0, (Intent)new Intent(), (int)BuildUtil.createIntentFlags((int)0)));
            NotificationManager mNotificationManager = (NotificationManager)currentContext.getSystemService("notification");
            mNotificationManager.notify(0, builder.build());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        pushProviders = new PushProviders();
        useNotificationBuilderCustomizer = false;
    }
}

