/*
 * Decompiled with CFR 0.152.
 */
package com.leanplum;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.leanplum.IPushProvider;
import com.leanplum.Leanplum;
import com.leanplum.PushProviderType;
import com.leanplum.internal.APIConfig;
import com.leanplum.internal.Log;
import com.leanplum.internal.OperationQueue;
import com.leanplum.internal.Util;
import com.leanplum.utils.SharedPreferencesUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class PushProviders {
    private static String FCM_PROVIDER_CLASS = "com.leanplum.LeanplumFcmProvider";
    private static String MIPUSH_PROVIDER_CLASS = "com.leanplum.LeanplumMiPushProvider";
    private static String HMS_PROVIDER_CLASS = "com.leanplum.LeanplumHmsProvider";
    private final Map<PushProviderType, IPushProvider> providers = new ConcurrentHashMap<PushProviderType, IPushProvider>();
    private boolean initialized = false;

    public PushProviders() {
        this.init();
    }

    public synchronized void init() {
        IPushProvider hms;
        IPushProvider miPush;
        if (this.initialized) {
            return;
        }
        if (Leanplum.getContext() == null) {
            return;
        }
        IPushProvider fcm = PushProviders.createFcm();
        if (fcm != null) {
            this.providers.put(PushProviderType.FCM, fcm);
        }
        if ((miPush = PushProviders.createMiPush()) != null) {
            this.providers.put(PushProviderType.MIPUSH, miPush);
        }
        if ((hms = PushProviders.createHms()) != null) {
            this.providers.put(PushProviderType.HMS, hms);
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRegistrationIdsAndBackend() {
        boolean hasAppIDChanged = PushProviders.hasAppIDChanged(APIConfig.getInstance().appId());
        Map<PushProviderType, IPushProvider> map = this.providers;
        synchronized (map) {
            for (final IPushProvider provider : this.providers.values()) {
                if (hasAppIDChanged) {
                    provider.unregister();
                }
                OperationQueue.sharedInstance().addParallelOperation(new Runnable(){

                    @Override
                    public void run() {
                        provider.updateRegistrationId();
                    }
                });
            }
        }
    }

    private static IPushProvider createFcm() {
        if (!Util.hasPlayServices()) {
            Log.i((String)"No valid Google Play Services APK found. FCM will not initialize.", (Object[])new Object[0]);
            return null;
        }
        try {
            IPushProvider fcmProvider = (IPushProvider)Class.forName(FCM_PROVIDER_CLASS).getConstructor(new Class[0]).newInstance(new Object[0]);
            return fcmProvider;
        }
        catch (Throwable t) {
            Log.i((String)"FCM module not found. For Firebase messaging include dependency \"com.leanplum:leanplum-fcm\".", (Object[])new Object[0]);
            return null;
        }
    }

    private static IPushProvider createMiPush() {
        try {
            Class<?> clazz = Class.forName(MIPUSH_PROVIDER_CLASS);
            if (!Util.isXiaomiDevice()) {
                Log.d((String)"Will not initialize MiPush provider for non-Xiaomi device.", (Object[])new Object[0]);
                return null;
            }
            return (IPushProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            Log.d((String)"MiPush module not found. For Mi Push messaging include dependency \"com.leanplum:leanplum-mipush\".", (Object[])new Object[0]);
            return null;
        }
    }

    private static IPushProvider createHms() {
        try {
            Class<?> clazz = Class.forName(HMS_PROVIDER_CLASS);
            if (!Util.isHuaweiServicesAvailable((Context)Leanplum.getContext())) {
                Log.d((String)"Will not initialize HMS provider for non-Huawei device.", (Object[])new Object[0]);
                return null;
            }
            return (IPushProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            Log.i((String)"HMS module not found. For Huawei Push Kit messaging include dependency \"com.leanplum:leanplum-hms\".", (Object[])new Object[0]);
            return null;
        }
    }

    @VisibleForTesting
    static boolean hasAppIDChanged(String currentAppId) {
        if (TextUtils.isEmpty((CharSequence)currentAppId)) {
            return false;
        }
        Context context = Leanplum.getContext();
        if (context == null) {
            return false;
        }
        String storedAppId = SharedPreferencesUtil.getString((Context)context, (String)"__leanplum_push__", (String)"__app_id");
        if (!currentAppId.equals(storedAppId)) {
            Log.d((String)"Saving the application id in the shared preferences.", (Object[])new Object[0]);
            SharedPreferencesUtil.setString((Context)context, (String)"__leanplum_push__", (String)"__app_id", (String)currentAppId);
            if (!"".equals(storedAppId)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegistrationId(PushProviderType type, String registrationId) {
        Map<PushProviderType, IPushProvider> map = this.providers;
        synchronized (map) {
            IPushProvider provider = this.providers.get(type);
            if (provider != null) {
                provider.setRegistrationId(registrationId);
            }
        }
    }
}

